% DISCLAIMER: This code was borrowed from IGL lab (see http://igl.ethz.ch/). 
% Please contact Alec Jacobson, jacobson@inf.ethz.ch, before using this 
% code outside of an informal setting, i.e. for comparisons in an 
% academic paper.

function [A] = adjacency_matrix(E)
  % ADJACENCY_MATRIX Build sparse adjacency matrix from edge list or face list
  % 
  % [A] = adjacency_matrix(E)
  % [A] = adjacency_matrix(F)
  % [A] = adjacency_matrix(T)
  %
  % Inputs:
  %  E  #E by 2 edges list
  %  or 
  %  F  #F by 3 triangle list
  %  or 
  %  T  #F by 4 tet list
  %
% DISCLAIMER: This code was borrowed from IGL lab (see http://igl.ethz.ch/). 
% Please contact Alec Jacobson, jacobson@inf.ethz.ch, before using this 
% code outside of an informal setting, i.e. for comparisons in an 
% academic paper.

  if(size(E,2)>2)
    F = E;
    E = edges(F);
  end

  A = sparse([E(:,1) E(:,2)],[E(:,2) E(:,1)],1);
end
