% DISCLAIMER: This code was borrowed from IGL lab (see http://igl.ethz.ch/). 
% Please contact Alec Jacobson, jacobson@inf.ethz.ch, before using this 
% code outside of an informal setting, i.e. for comparisons in an 
% academic paper.

function [V,F] = load_mesh(filename)
  % read in vertices and faces from a .off or .obj file
  % Input:
  %   filename  file holding mesh
  % Output:
  %   V (vertex list) 
  %   F (face list) fields
  %
  % Copyright 2011, Alec Jacobson (jacobson@inf.ethz.ch)
  %
  % See also: readOBJ, readOBJfast, readOFF
  %
  if ~isempty(regexp(filename,'\.off$'))
    [V,F] = readOFF(filename);
  elseif ~isempty(regexp(filename,'\.obj$'))
    try
      [V,F] = readOBJfast(filename);
    catch exception
      fprintf('Fast reader failed, retrying with more robust, slower reader\n');
      [V,F] = readOBJ(filename);
    end
  else
    error('Input file must be .off or .obj file.');
  end
end
