% DISCLAIMER: This code was borrowed from IGL lab (see http://igl.ethz.ch/). 
% Please contact Alec Jacobson, jacobson@inf.ethz.ch, before using this 
% code outside of an informal setting, i.e. for comparisons in an 
% academic paper.

function [ A ] = normalizerow( A )
  % NORMALIZEROW 
  %
  % Normalize each row
  %
  % [ A ] = normalizerow( A )
  %
  % Input:
  %  A  #A by D list of row vectors of dimension D
  % Output:
  %  B  #B by D list of normalized row vectors 
  %
  % Copyright 2011, Alec Jacobson (jacobson@inf.ethz.ch), Daniele Panozzo
  %

  if issparse(A)
    % speed up (20x) for large sparse matrices
    A = bsxfun(@times,A,1./sqrt(sum(A.^2,2)));
  else
    A = A./repmat(sqrt(sum(A.^2,2)),1,size(A,2));
  end
end

