function [ff HH Aleq Bleq Aeq Beq cones Mdb] = BD_build_convex_program(V,F,problem)
%++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
%  build the convex program (constraints and functional)

C_ = problem.C_;
s_ = problem.s_;
S_ = problem.S_;

%++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
% in case we already processed this mesh (like for given reference frames)
if (strcmp(problem.frame_initialization_method,'previously_processed')==1)
    Mdb=problem.Mdbref;
    
    if(problem.onlyU == 1) %if using only positional variables
        %update the rules for finding alpha,beta,gamma from coordinates U
        [Mdb] = BD_update_a_b_c_(Mdb);
    else %onlyU==0, using affine map per face variables
        %% do nothing here
    end
else
    
    %++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    % prepare mesh (frame field, data structures, etc...)
    Mdb = MESH_prepare_data(V,F);
    
    %++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    % construct initial frame field
    Mdb = MESH_build_frame_field(Mdb,problem);
    
    
    %++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    % build the variables indices map. e.g., ia(k) gives the index of a_k in X
    % Mdb = QCONF_build_index_maps_for_map_vars_CONES(Mdb);    
    Mdb = BD_build_index_maps(Mdb,problem);
    
end

M = Mdb.M; %number of faces
    

%++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
% initializing all constraints to empty
Aleq_cdc =[];        Bleq_cdc=[];          cones_cdc=[];
Aleq_svc = [];       Bleq_svc = [];
Aeq_svc=[];          Beq_svc=[];
Aeq_cc=[];           Beq_cc=[];
Aeq_pc=[];           Beq_pc=[];
cones_svc=[];
%++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
% Conformal Distortion Constraints (CDC)
if(~isempty(intersect(problem.constraints,'CDC')))
    [Aleq_cdc Bleq_cdc cones_cdc] = BD_conformal_distortion_constraints(Mdb,C_);
end

%++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
% Conformal Distortion Constraints Linf norm (CDC_Linf)
if(~isempty(intersect(problem.constraints,'CDC_Linf')))
    
    if(problem.onlyU==0)        
        [Aleq_cdc Bleq_cdc ] = BD_conformal_distortion_constraints_Linf(Mdb,problem);        
    else
        %use only U variables (not a,b,c,d,t1,t2)
        [Aleq_cdc Bleq_cdc ] = BD_conformal_distortion_constraints_Linf_onlyU(Mdb,problem);
    end
    
end

%++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
% Conformal Distortion Constraints L1 norm (CDC_L1)
if(~isempty(intersect(problem.constraints,'CDC_L1')))
    
    if(problem.onlyU==0)  
        %% 
        [Aleq_cdc Bleq_cdc ] = BD_conformal_distortion_constraints_L1(Mdb,problem);        
    else
        %use only U variables (not a,b,c,d,t1,t2)
        [Aleq_cdc Bleq_cdc ] = BD_conformal_distortion_constraints_L1_onlyU(Mdb,problem);
    end
    
end


%++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
% Conformal Distortion Constraints As-Possible (CDC-AP)
if(~isempty(intersect(problem.constraints,'CDC-AP')))
    [Aleq_cdc Bleq_cdc cones_cdc] = BD_conformal_distortion_constraints_as_possible(Mdb,C_);
    % % %     %to create purely harmonic map
    %     Aleq_cdc = [];
    %     Bleq_cdc = [];
end


%++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
% Singular Values Constraints (SVC)
if(~isempty(intersect(problem.constraints,'SVC')))
    [Aleq_svc Bleq_svc Aeq_svc Beq_svc cones_svc] = ...
        BD_singular_values_constraints(Mdb,s_,S_,C_);

end

%++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
% L_infSingular Values Constraints (SVC_Linf)
if(~isempty(intersect(problem.constraints,'SVC_Linf')))
    
    if(problem.onlyU==0)
        
        
        [Aleq_svc Bleq_svc Aeq_svc Beq_svc ] = ...
            BD_Linf_singular_values_constraints(Mdb,s_,S_,C_);
        
    else
        
        %we dont use a,b,c,d,t1,t2,e
        [Aleq_svc Bleq_svc ] = BD_Linf_singular_values_constraints_onlyU(Mdb,s_,S_,C_);
        
    end
    
end

%++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
% Lower Bound on a (LBa) - so to have bounded conf distortion and det>0
if(~isempty(intersect(problem.constraints,'LBa')))
    [Aleq_lba Bleq_lba ] = ...
        BD_bounded_a_from_below(Mdb);
else
    Aleq_lba = [];       Bleq_lba = [];
end

%++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
% Lower Bound on r (LBr) - so to have bounded conf distortion and det>0
if(~isempty(intersect(problem.constraints,'LBr')))
    [Aleq_lbr Bleq_lbr ] = ...
        BD_bounded_r_from_below(Mdb);
else
    Aleq_lbr = [];       Bleq_lbr = [];
end

%++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
% epsilon Lower Bound on r (LBr) - so to have bounded conf distortion and det>0
if(~isempty(intersect(problem.constraints,'LBr_eps')))
    [Aleq_lbre Bleq_lbre ] = ...
        BD_bounded_r_from_below_epsilon(Mdb);
else
    Aleq_lbre = [];       Bleq_lbre = [];
end


%++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
% Harmonic Constraints (HC) - add |alpha_j|<= e_j
if(~isempty(intersect(problem.constraints,'HC')))
    [cones_hc] = BD_harmonic_constraints(Mdb);
    Aleq_hc = [];       Bleq_hc = [];
    Aeq_hc=[];       Beq_hc=[];
else
    Aleq_hc = [];       Bleq_hc = [];
    Aeq_hc=[];       Beq_hc=[];
    cones_hc=[];
end



%++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
% Energy functional
Aeq_e=[]; Beq_e=[]; Aleq_e=[]; Bleq_e=[]; ff_e=[];
HH_e.ii = [];       HH_e.jj = [];      HH_e.ss = [];
HH_e.HH=[];


if(~isempty(intersect(problem.energy,'linf_Linf')))
    [ff_e Aleq_e Bleq_e] = BD_error_functional_linf_Linf(Mdb);
    
    
elseif(~isempty(intersect(problem.energy,'l2_ARAP')))
    
    [H ii jj ss f] = QCONF_l2_ARAP_energy(Mdb);
    HH_e.ii = ii;
    HH_e.jj = jj;
    HH_e.ss = ss;
    HH_e.HH = H;
    ff_e=f;
    
elseif(~isempty(intersect(problem.energy,'l1_Linf')))
    [ff_e Aleq_e Bleq_e] = BD_error_functional_l1_Linf(Mdb);
    
elseif(~isempty(intersect(problem.energy,'l1_L1')))
    [ff_e Aleq_e Bleq_e Aeq_e Beq_e] = BD_error_functional_l1_L1(Mdb);
    
elseif(~isempty(intersect(problem.energy,'linf_Linf_SMOOTH')))
    [ff_e Aleq_e Bleq_e] = BD_error_functional_linf_smooth(Mdb);
    
elseif(~isempty(intersect(problem.energy,'l1_L2')))
    ff_e=zeros(1,Mdb.NN);
    ff_e(Mdb.ir)=Mdb.F_area;
    
elseif(~isempty(intersect(problem.energy,'l1_H2')))
    ff_e=zeros(1,Mdb.NN);
    ff_e(Mdb.ir)=Mdb.F_area;
    ff_e(Mdb.ie)=Mdb.F_area;
    
elseif(~isempty(intersect(problem.energy,'l1_SV')))%sum of singular values
    ff_e=zeros(1,Mdb.NN);
    ff_e(Mdb.ie)=Mdb.F_area;
    
elseif(~isempty(intersect(problem.energy,'l2_BIH')))
    %smoothness energy
    [HH ii jj ss] = QCONF_construct_biharmonic_quad_energy(Mdb);
    HH_e.ii = ii;
    HH_e.jj = jj;
    HH_e.ss = ss;
    HH_e.HH=sparse(ii,jj,ss,Mdb.NN,Mdb.NN);
    
elseif(~isempty(intersect(problem.energy,'l2_BIH_COT')))
    %smoothness energy
    [HH ii jj ss] = QCONF_construct_biharmonic_quad_energy_COT(Mdb);
    HH_e.ii = ii;
    HH_e.jj = jj;
    HH_e.ss = ss;
    HH_e.HH=HH;
    
elseif(~isempty(intersect(problem.energy,'l2_H2')))
    tt = 1:M;
    ii(tt) = Mdb.ic;
    jj(tt) = Mdb.ic;
    ss(tt) = Mdb.F_area;
    %
    ii(tt+M) = Mdb.id;
    jj(tt+M) = Mdb.id;
    ss(tt+M) = Mdb.F_area;
    %
    ii(tt+2*M) = Mdb.ia;
    jj(tt+2*M) = Mdb.ia;
    ss(tt+2*M) = Mdb.F_area;
    %
    ii(tt+3*M) = Mdb.ib;
    jj(tt+3*M) = Mdb.ib;
    ss(tt+3*M) = Mdb.F_area;
    %
    HH_e.ii = ii;
    HH_e.jj = jj;
    HH_e.ss = ss;
    HH_e.HH=sparse(ii,jj,ss,Mdb.NN,Mdb.NN);
    
    
elseif(~isempty(intersect(problem.energy,'l2_L2')))
    
    %check if we have only U variables
    if(problem.onlyU == 0)
        
        tt = 1:M;
        ii(tt) = Mdb.ic;
        jj(tt) = Mdb.ic;
        ss(tt) = Mdb.F_area;
        %
        ii(tt+M) = Mdb.id;
        jj(tt+M) = Mdb.id;
        ss(tt+M) = Mdb.F_area;
        %
        HH_e.ii = ii;
        HH_e.jj = jj;
        HH_e.ss = ss;
        HH_e.HH=sparse(ii,jj,ss,Mdb.NN,Mdb.NN);
        
    else %Linf only U vars
        [H,ii,jj,ss] = QCONF_construct_LSCM_quad_energy_only_U(Mdb);
        HH_e.ii = ii;
        HH_e.jj = jj;
        HH_e.ss = ss;
        HH_e.HH=H;
        
    end
    
    
elseif(~isempty(intersect(problem.energy,'l1_H2-AP')))
    ff_e=zeros(1,Mdb.NN);
    ff_e(Mdb.iw) = 1;

elseif(~isempty(intersect(problem.energy,'linf_L2')))
    %to be implemented
    
    
else %no energy
    ff_e=[];
    
end


%++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
% Continuity Constraints (CC)
if(problem.onlyU==0)
    
    if(strcmp(problem.frame_initialization_method,'remesh')==1)
        [Aeq_cc Beq_cc] = BD_continuity_constraints_NON_ORTHONORMAL_FRAMES(Mdb);
    elseif(~isempty(intersect(problem.constraints,'CC')))
        if(problem.onlyU == 0)
            [Aeq_cc Beq_cc] = BD_continuity_constraints(Mdb);
        end
    end
    
end


%++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
% add Positional Constraints (PC)
% there are two types of positional constraints:
% 1) 'point' ; 2) 'pl_boundary' 
% in point constraints: U00 -> U11 (we take closest points in mesh to U00 
% and force them to be mapped to U11)

% P = V(:,1)+1i*V(:,2);

switch problem.user_constraints{1}    
    case 'point'
        U00 = problem.U00;
        U11 = problem.U11;
        
    case 'pl_boundary'
        bverts = CORR_locate_boundary_vertices(Mdb.E2V,Mdb.V2F);
        U00 = V(bverts,:); U00 = U00(:,1)+1i*U00(:,2);
        U11=U00*0;
        for k=1:(length(U00))
            p = U00(k);
            [ind_e lambda] = MESH_find_poly_edge_containing_point(problem.P1,p);
            
            if (ind_e == length(problem.P1) )
                ind_next = 1;
            else
                ind_next = ind_e+1;
            end
            
            temp =  lambda*problem.P2(ind_e,:) + (1-lambda)*problem.P2(ind_next,:);
            U11(k,:) = temp(1)+1i*temp(2);
        end
        
    case 'no_contraints'
        disp('no point constraints were chosen.');
        
    otherwise
        error('type of user constraints not implemented.');
        
end


if(~isempty(intersect(problem.constraints,'PC')))
    [Aeq_pc Beq_pc] = QCONF_build_positional_constraints(Mdb,U00,U11);
end


%++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
% set functional, equality/inequality matrices and cones 
Aeq = [Aeq_cc ; Aeq_svc;   Aeq_e ; Aeq_pc];
Beq = [Beq_cc ; Beq_svc;   Beq_e ; Beq_pc];

Aleq = [ Aleq_cdc; Aleq_svc; Aleq_e ; Aleq_lba; Aleq_lbr ; Aleq_lbre];
Bleq = [ Bleq_cdc; Bleq_svc; Bleq_e ; Bleq_lba; Bleq_lbr ; Bleq_lbre];

cones = [ cones_cdc ; cones_svc ; cones_hc];

ff = ff_e;

HH = HH_e;
