function  Mdb = BD_build_index_maps(Mdb,problem)
%++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
% This function builds the index maps for bounded distortion tri mapping:
% we build the indices map that provide the location
% of each variable (a,b,etc...) in the big unknown vector X


M=Mdb.M;
N=Mdb.N;

%++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
% basic variables (depends on QP or CONE problem)
if( problem.onlyU == 0)
    %exact cones
        X  = {'a','b','c','d','t1','t2','u1','u2'};
        ind= [ M , M , M , M , M  , M  , N  , N  ];
else        
    %we use Linf cones so we can use solely U variables
        X  = {'u1','u2'};
        ind= [ N  , N  ];
end     

%++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
% add variables needed for requested constraints
% CDC
if(~isempty(intersect(problem.constraints,'CDC')))
   X{end+1} = 'r';
   ind(end+1) = M;
end
% CDC_Linf
if(~isempty(intersect(problem.constraints,'CDC_Linf')))
%    X{end+1} = 'r';
%    ind(end+1) = M;
end
% CDC-AP (as-possible)
if(~isempty(intersect(problem.constraints,'CDC-AP')))
   X{end+1} = 'r';
   ind(end+1) = M;   
   X{end+1} = 'w';
   ind(end+1) = 1;
end
% SVC
if(~isempty(intersect(problem.constraints,'SVC')))
   X{end+1} = 'e';
   ind(end+1) = M;
end
% % SVC_Linf
if(~isempty(intersect(problem.constraints,'SVC_Linf')) && problem.onlyU == 0)
    %%changed || -> && 
   X{end+1} = 'e';
   ind(end+1) = M;
end
% HC
if(~isempty(intersect(problem.constraints,'HC')))
   X{end+1} = 'e';
   ind(end+1) = M;
end
% l1_H2_ap
if(~isempty(intersect(problem.constraints,'HC')))
   X{end+1} = 'e';
   ind(end+1) = M;
end

%++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
% add variables needed for energy
% CDC
if(~isempty(intersect(problem.energy,'linf_Linf')))
   X{end+1} = 'q';
   ind(end+1) = 1;
end
if(~isempty(intersect(problem.energy,'l1_Linf')))
   X{end+1} = 'q';
   ind(end+1) = M;
end
if(~isempty(intersect(problem.energy,'l1_L1')))
   X{end+1} = 'cp';
   ind(end+1) = M;
   X{end+1} = 'cm';
   ind(end+1) = M;
   X{end+1} = 'dp';
   ind(end+1) = M;
   X{end+1} = 'dm';
   ind(end+1) = M;
end
if(~isempty(intersect(problem.energy,'linf_L2')))
   X{end+1} = 'R';
   ind(end+1) = 1;
end
if(~isempty(intersect(problem.energy,'linf_Linf_SMOOTH')))
   X{end+1} = 'q';
   ind(end+1) = 1;
end


%++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
% build the indices map

for n=1:length(X)
   if strcmp(X{n},'a')==1
       Mdb.ia = (sum(ind(1:(n-1)))+1):(sum(ind(1:(n-1)))+ind(n));       
   end
   if strcmp(X{n},'b')==1
       Mdb.ib = (sum(ind(1:(n-1)))+1):(sum(ind(1:(n-1)))+ind(n));       
   end
   if strcmp(X{n},'c')==1
       Mdb.ic = (sum(ind(1:(n-1)))+1):(sum(ind(1:(n-1)))+ind(n));       
   end
   if strcmp(X{n},'d')==1
       Mdb.id = (sum(ind(1:(n-1)))+1):(sum(ind(1:(n-1)))+ind(n));       
   end
   if strcmp(X{n},'t1')==1
       Mdb.it1 = (sum(ind(1:(n-1)))+1):(sum(ind(1:(n-1)))+ind(n));       
   end
   if strcmp(X{n},'t2')==1
       Mdb.it2 = (sum(ind(1:(n-1)))+1):(sum(ind(1:(n-1)))+ind(n));       
   end
   if strcmp(X{n},'u1')==1
       Mdb.iu1 = (sum(ind(1:(n-1)))+1):(sum(ind(1:(n-1)))+ind(n));       
   end
   if strcmp(X{n},'u2')==1
       Mdb.iu2 = (sum(ind(1:(n-1)))+1):(sum(ind(1:(n-1)))+ind(n));       
   end
   %
   if strcmp(X{n},'r')==1
       Mdb.ir = (sum(ind(1:(n-1)))+1):(sum(ind(1:(n-1)))+ind(n));       
   end
   if strcmp(X{n},'R')==1
       Mdb.iR = (sum(ind(1:(n-1)))+1):(sum(ind(1:(n-1)))+ind(n));       
   end
   if strcmp(X{n},'e')==1
       Mdb.ie = (sum(ind(1:(n-1)))+1):(sum(ind(1:(n-1)))+ind(n));       
   end
   if strcmp(X{n},'q')==1
       Mdb.iq = (sum(ind(1:(n-1)))+1):(sum(ind(1:(n-1)))+ind(n));       
   end
   if strcmp(X{n},'w')==1
       Mdb.iw = (sum(ind(1:(n-1)))+1):(sum(ind(1:(n-1)))+ind(n));       
   end
   %
   if strcmp(X{n},'cp')==1
       Mdb.icp = (sum(ind(1:(n-1)))+1):(sum(ind(1:(n-1)))+ind(n));       
   end
   if strcmp(X{n},'cm')==1
       Mdb.icm = (sum(ind(1:(n-1)))+1):(sum(ind(1:(n-1)))+ind(n));       
   end
   if strcmp(X{n},'dp')==1
       Mdb.idp = (sum(ind(1:(n-1)))+1):(sum(ind(1:(n-1)))+ind(n));       
   end
   if strcmp(X{n},'dm')==1
       Mdb.idm = (sum(ind(1:(n-1)))+1):(sum(ind(1:(n-1)))+ind(n));       
   end
    
end



NN = sum(ind); %the total size of the unknown vector X
Mdb.NN=NN;
