function [Aleq Bleq cones] = BD_conformal_distortion_constraints_L1(Mdb,problem)
%++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
% the cone condition with Linf norm using the affine map per face as
% variables.
% We build matrices Aleq and Bleq so that the bounded distortion equations
% correspond to Aleq*X <= Bleq, where X is the unknown vector

%++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
% load index maps and variables
ia=Mdb.ia;ib=Mdb.ib;ic=Mdb.ic;id=Mdb.id;
it1=Mdb.it1;it2=Mdb.it2;iu1=Mdb.iu1;iu2=Mdb.iu2;
% ir=Mdb.ir;

M=Mdb.M;
N=Mdb.N;
NN=Mdb.NN;

C_ = problem.C_;

%++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
% build Aleq and Bleq

per_face_num = 5; %how many equations per face?
% non_zeros_in_line_num = 3; %upper_bound to how many non-zeros in each equation?
upper_bound_num_non_zeros=M*per_face_num*8; %put here a more precise upper bounds
ii=zeros(upper_bound_num_non_zeros,1);
jj=zeros(upper_bound_num_non_zeros,1);
ss=zeros(upper_bound_num_non_zeros,1);

Bleq=zeros(M*per_face_num,1);

cnt=0;
for k=1:M
    
    %---------------------------------------
    %---------------------------------------
    % Re(alpha_j) > 0
    %---------------------------------------
    %---------------------------------------
    
    
    line_num=1;
    
    cnt=cnt+1;
    ii(cnt) = per_face_num*(k-1) + line_num;
    jj(cnt) = ia(k);
    ss(cnt) = -1;
    

    if(~isempty(intersect(problem.constraints,'free_boundary')))
        Bleq(per_face_num*(k-1) + line_num)=-1;
    else
        Bleq(per_face_num*(k-1) + line_num)=-10^-8;
    end

    
    %---------------------------------------
    %---------------------------------------
    % |beta_j|_1 <= r_j (C-1)/((C+1))
    %---------------------------------------
    %---------------------------------------
    RHSconst = -(C_-1)/((C_+1));
    
    %---------------------------------------
    % c_j + d_j <= Re(alpha_j) (C-1)/((C+1))
    
    line_num=2;
    
    cnt=cnt+1;
    ii(cnt) = per_face_num*(k-1) + line_num;
    jj(cnt) = ic(k);
    ss(cnt) = 1;
    
    cnt=cnt+1;
    ii(cnt) = per_face_num*(k-1) + line_num;
    jj(cnt) = id(k);
    ss(cnt) = 1;
    
    cnt=cnt+1;
    ii(cnt) = per_face_num*(k-1) + line_num;
    jj(cnt) = ia(k);
    ss(cnt) = RHSconst;
    
    Bleq(per_face_num*(k-1) + line_num)=0;
    
    %---------------------------------------
    % -c_j + d_j <= Re(alpha_j) (C-1)/((C+1))
    
    line_num=3;
    
    cnt=cnt+1;
    ii(cnt) = per_face_num*(k-1) + line_num;
    jj(cnt) = ic(k);
    ss(cnt) = -1;
    
    cnt=cnt+1;
    ii(cnt) = per_face_num*(k-1) + line_num;
    jj(cnt) = id(k);
    ss(cnt) = 1;
    
   cnt=cnt+1;
    ii(cnt) = per_face_num*(k-1) + line_num;
    jj(cnt) = ia(k);
    ss(cnt) = RHSconst;
    
    Bleq(per_face_num*(k-1) + line_num)=0;
    
    %---------------------------------------
    % c_j -d_j  <= Re(alpha_j) (C-1)/((C+1))
    
    line_num=4;
    
    cnt=cnt+1;
    ii(cnt) = per_face_num*(k-1) + line_num;
    jj(cnt) = ic(k);
    ss(cnt) = 1;
       
    cnt=cnt+1;
    ii(cnt) = per_face_num*(k-1) + line_num;
    jj(cnt) = id(k);
    ss(cnt) = -1;
    
    cnt=cnt+1;
    ii(cnt) = per_face_num*(k-1) + line_num;
    jj(cnt) = ia(k);
    ss(cnt) = RHSconst;
    
    Bleq(per_face_num*(k-1) + line_num)=0;
    
    %---------------------------------------
    % -c_j -d_j  <= Re(alpha_j) (C-1)/((C+1))
    
    line_num=5;
    
    cnt=cnt+1;
    ii(cnt) = per_face_num*(k-1) + line_num;
    jj(cnt) = ic(k);
    ss(cnt) = -1;
    
    cnt=cnt+1;
    ii(cnt) = per_face_num*(k-1) + line_num;
    jj(cnt) = id(k);
    ss(cnt) = -1;
    
    cnt=cnt+1;
    ii(cnt) = per_face_num*(k-1) + line_num;
    jj(cnt) = ia(k);
    ss(cnt) = RHSconst;
    
    Bleq(per_face_num*(k-1) + line_num)=0;
    
end

%truncate ii,jj,ss we didn't use
ii(cnt+1:end)=[];
jj(cnt+1:end)=[];
ss(cnt+1:end)=[];
%build the matrix
Aleq=sparse(ii,jj,ss,max(ii),NN);

%++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
% build CDC cones
cones=[];
% cones = cell(M,1);
% for k=1:M
%     %in face k: |beta| \leq r
%     cones{k}.type = 'MSK_CT_QUAD';
%     cones{k}.sub = [ir(k) ic(k) id(k)];
% end

