function [Aleq Bleq cones] = BD_conformal_distortion_constraints_Linf_onlyU(Mdb,problem)
%++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
% the bounded distortion inequalities with the Linf norm relaxation
% and only vertex position as variables are constructed.
% We build matrices Aleq and Bleq so that the bounded distortion equations
% correspond to Aleq*X <= Bleq, where X is the unknown vector

%++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
% load index maps and variables
iu1=Mdb.iu1;iu2=Mdb.iu2;
% ir=Mdb.ir;

a_ = Mdb.a_;
b_ = Mdb.b_;


M=Mdb.M;
N=Mdb.N;
NN=Mdb.NN;

F=Mdb.F;


C_ = problem.C_;
%++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
% build Aleq and Bleq

per_face_num = 5; %how many equations per face?
% non_zeros_in_line_num = 3; %upper_bound to how many non-zeros in each equation?
upper_bound_num_non_zeros=M*per_face_num*8; %put here a more precise upper bounds
ii=zeros(upper_bound_num_non_zeros,1);
jj=zeros(upper_bound_num_non_zeros,1);
ss=zeros(upper_bound_num_non_zeros,1);

Bleq=zeros(M*per_face_num,1);
cnt=0;ti=1:3;
for k=1:M
    
    %---------------------------------------
    %---------------------------------------
    % Re(alpha_j) > 0
    %---------------------------------------
    %---------------------------------------
    
    line_num=1;
    
    %this is -Re(alpha_j)
    ii(cnt+ti) = per_face_num*(k-1) + line_num;
    jj(cnt+ti) = iu1(F(k,ti));
    ss(cnt+ti) = real(a_(k,ti))*(-1);
    cnt=cnt+3;
    ii(cnt+ti) = per_face_num*(k-1) + line_num;
    jj(cnt+ti) = iu2(F(k,ti));
    ss(cnt+ti) = -imag(a_(k,ti))*(-1);
    cnt=cnt+3;
    
    
    if(~isempty(intersect(problem.constraints,'free_boundary')))
        Bleq(per_face_num*(k-1) + line_num)=-1;
    else
        Bleq(per_face_num*(k-1) + line_num)=-10^-8;
    end
    
    
    
    
    %---------------------------------------
    %---------------------------------------
    % |beta_j|_inf <= Re(alpha_j) (C-1)/((C+1)sqrt(2))
    %---------------------------------------
    %---------------------------------------
    RHSconst = -(C_-1)/((C_+1)*sqrt(2));
    
    %---------------------------------------
    % c_j  <= Re(alpha_j) (C-1)/((C+1)sqrt(2))
    
    line_num=2;
    
    %this enters c_j (as linear combination of the vertices' positions,
    %   please see the paper for omre details)
    ii(cnt+ti) = per_face_num*(k-1) + line_num;
    jj(cnt+ti) = iu1(F(k,ti));
    ss(cnt+ti) = real(b_(k,ti));
    cnt=cnt+3;
    ii(cnt+ti) = per_face_num*(k-1) + line_num;
    jj(cnt+ti) = iu2(F(k,ti));
    ss(cnt+ti) = -imag(b_(k,ti));
    cnt=cnt+3;
    
    %this is -Re(alpha_j)(C-1)/((C+1)sqrt(2))
    ii(cnt+ti) = per_face_num*(k-1) + line_num;
    jj(cnt+ti) = iu1(F(k,ti));
    ss(cnt+ti) = real(a_(k,ti))*(RHSconst);
    cnt=cnt+3;
    ii(cnt+ti) = per_face_num*(k-1) + line_num;
    jj(cnt+ti) = iu2(F(k,ti));
    ss(cnt+ti) = -imag(a_(k,ti))*(RHSconst);
    cnt=cnt+3;
    
    Bleq(per_face_num*(k-1) + line_num)=0;
    
    %---------------------------------------
    % -c_j  <= Re(alpha_j) (C-1)/((C+1)sqrt(2))
    
    line_num=3;
    
    %-c_j
    ii(cnt+ti) = per_face_num*(k-1) + line_num;
    jj(cnt+ti) = iu1(F(k,ti));
    ss(cnt+ti) = -real(b_(k,ti));
    cnt=cnt+3;
    ii(cnt+ti) = per_face_num*(k-1) + line_num;
    jj(cnt+ti) = iu2(F(k,ti));
    ss(cnt+ti) = imag(b_(k,ti));
    cnt=cnt+3;
    
    %this is -Re(alpha_j)(C-1)/((C+1)sqrt(2))
    ii(cnt+ti) = per_face_num*(k-1) + line_num;
    jj(cnt+ti) = iu1(F(k,ti));
    ss(cnt+ti) = real(a_(k,ti))*(RHSconst);
    cnt=cnt+3;
    ii(cnt+ti) = per_face_num*(k-1) + line_num;
    jj(cnt+ti) = iu2(F(k,ti));
    ss(cnt+ti) = -imag(a_(k,ti))*(RHSconst);
    cnt=cnt+3;
    
    Bleq(per_face_num*(k-1) + line_num)=0;
    
    %---------------------------------------
    % d_j  <= Re(alpha_j) (C-1)/((C+1)sqrt(2))
    
    line_num=4;
    
    %d_j
    ii(cnt+ti) = per_face_num*(k-1) + line_num;
    jj(cnt+ti) = iu2(F(k,ti));
    ss(cnt+ti) = real(b_(k,ti));
    cnt=cnt+3;
    ii(cnt+ti) = per_face_num*(k-1) + line_num;
    jj(cnt+ti) = iu1(F(k,ti));
    ss(cnt+ti) = imag(b_(k,ti));
    cnt=cnt+3;
    
    
    %this is -Re(alpha_j)(C-1)/((C+1)sqrt(2))
    ii(cnt+ti) = per_face_num*(k-1) + line_num;
    jj(cnt+ti) = iu1(F(k,ti));
    ss(cnt+ti) = real(a_(k,ti))*(RHSconst);
    cnt=cnt+3;
    ii(cnt+ti) = per_face_num*(k-1) + line_num;
    jj(cnt+ti) = iu2(F(k,ti));
    ss(cnt+ti) = -imag(a_(k,ti))*(RHSconst);
    cnt=cnt+3;
    
    Bleq(per_face_num*(k-1) + line_num)=0;
    
    %---------------------------------------
    % -d_j  <= Re(alpha_j) (C-1)/((C+1)sqrt(2))
    line_num=5;
    
    %-d_j
    ii(cnt+ti) = per_face_num*(k-1) + line_num;
    jj(cnt+ti) = iu2(F(k,ti));
    ss(cnt+ti) = -real(b_(k,ti));
    cnt=cnt+3;
    ii(cnt+ti) = per_face_num*(k-1) + line_num;
    jj(cnt+ti) = iu1(F(k,ti));
    ss(cnt+ti) = -imag(b_(k,ti));
    cnt=cnt+3;
    
    %this is -Re(alpha_j)(C-1)/((C+1)sqrt(2))
    ii(cnt+ti) = per_face_num*(k-1) + line_num;
    jj(cnt+ti) = iu1(F(k,ti));
    ss(cnt+ti) = real(a_(k,ti))*(RHSconst);
    cnt=cnt+3;
    ii(cnt+ti) = per_face_num*(k-1) + line_num;
    jj(cnt+ti) = iu2(F(k,ti));
    ss(cnt+ti) = -imag(a_(k,ti))*(RHSconst);
    cnt=cnt+3;
    
    Bleq(per_face_num*(k-1) + line_num)=0;
    
end

%truncate ii,jj,ss we didn't use
ii(cnt+1:end)=[];
jj(cnt+1:end)=[];
ss(cnt+1:end)=[];
%build the matrix
Aleq=sparse(ii,jj,ss,max(ii),NN);

%++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
% build CDC cones
cones=[];
% cones = cell(M,1);
% for k=1:M
%     %in face k: |beta| \leq r
%     cones{k}.type = 'MSK_CT_QUAD';
%     cones{k}.sub = [ir(k) ic(k) id(k)];
% end

