function [Aeq Beq] = BD_continuity_constraints(Mdb)

M = Mdb.M; %number of faces
P=Mdb.P; %the centroids of the faces
FB1=Mdb.FB1;
FB2=Mdb.FB2;
V=Mdb.V;
F=Mdb.F;

ia=Mdb.ia;
ib=Mdb.ib;
ic=Mdb.ic;
id=Mdb.id;
it1=Mdb.it1;
it2=Mdb.it2;
iu1=Mdb.iu1;
iu2=Mdb.iu2;
NN=Mdb.NN;

per_face_num = 6; %how many equations per face
non_zeros_in_line_num = 6; %how many non-zeros in each equation
Beq = zeros(per_face_num*M,1);
ii=zeros(non_zeros_in_line_num*M*per_face_num,1);
jj=zeros(non_zeros_in_line_num*M*per_face_num,1);
ss=zeros(non_zeros_in_line_num*M*per_face_num,1);
cnt=0;
for j=1:M
    f=F(j,:);
    p=P(j,:); %the origin of local frame
    b1 = FB1(j,:);
    b2 = FB2(j,:);
    %for each vertex in face f
    for ell=1:3
        v = V(f(ell),:);
        x1_jl = dot(v-p,b1);
        x2_jl = dot(v-p,b2);
        I_jl = f(ell);
        
        %one equality
        line_num = ell;
        cnt=cnt+1;
        ii(cnt) = per_face_num*(j-1) + line_num;
        jj(cnt) = ia(j);
        ss(cnt) = x1_jl;
        
        cnt=cnt+1;
        ii(cnt) = per_face_num*(j-1) + line_num;
        jj(cnt) = ic(j);
        ss(cnt) = x1_jl;
        
        cnt=cnt+1;
        ii(cnt) = per_face_num*(j-1) + line_num;
        jj(cnt) = ib(j);
        ss(cnt) = -x2_jl;
        
        cnt=cnt+1;
        ii(cnt) = per_face_num*(j-1) + line_num;
        jj(cnt) = id(j);
        ss(cnt) = x2_jl;
        
        cnt=cnt+1;
        ii(cnt) = per_face_num*(j-1) + line_num;
        jj(cnt) = it1(j);
        ss(cnt) = 1;
        
        cnt=cnt+1;
        ii(cnt) = per_face_num*(j-1) + line_num;
        jj(cnt) = iu1(I_jl);
        ss(cnt) = -1;
        
        
        %second equality
        line_num = 3+ell;
        cnt=cnt+1;
        ii(cnt) = per_face_num*(j-1) + line_num;
        jj(cnt) = ib(j);
        ss(cnt) = x1_jl;
        
        cnt=cnt+1;
        ii(cnt) = per_face_num*(j-1) + line_num;
        jj(cnt) = id(j);
        ss(cnt) = x1_jl;
        
        cnt=cnt+1;
        ii(cnt) = per_face_num*(j-1) + line_num;
        jj(cnt) = ia(j);
        ss(cnt) = x2_jl;
        
        cnt=cnt+1;
        ii(cnt) = per_face_num*(j-1) + line_num;
        jj(cnt) = ic(j);
        ss(cnt) = -x2_jl;
        
        cnt=cnt+1;
        ii(cnt) = per_face_num*(j-1) + line_num;
        jj(cnt) = it2(j);
        ss(cnt) = 1;
        
        cnt=cnt+1;
        ii(cnt) = per_face_num*(j-1) + line_num;
        jj(cnt) = iu2(I_jl);
        ss(cnt) = -1;
        
    end
    
    
    
end

%the 2 is for the two vertices constraints
Aeq=sparse(ii,jj,ss,M*per_face_num,NN);
