function [Mdb] = BD_update_a_b_c_(Mdb)
%++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
% for each face j, find the linear functional giving a,b,c 
% (=alpha,beta,delta in the paper) where
% [a b c] = Z^-1 * u(F(j,:)).'


M=Mdb.M;
FB1=Mdb.FB1;
FB2=Mdb.FB2;


Q = zeros(M,3,3);
a_ = zeros(M,3);
b_ = zeros(M,3);
c_ = zeros(M,3);
F_area=zeros(M,1);
for  k=1:M
%   progressbar(k,M,20);

    %write the vertices position of each triangles' vertices in local
    %complex frame
    v=Mdb.V(Mdb.F(k,:),:);
    v=v-ones(3,1)*Mdb.P(k,:);
    
    Z = v*[FB1(k,:).' FB2(k,:).' ];
    %F_area(k) = norm(cross(Z(:,1),Z(:,2)));
    F_area(k) = sqrt(det(Z'*Z)); % ROI: faster to do this
    Z = Z(:,1) + 1i*Z(:,2);
    
    Q(k,:,:) = inv( [ Z conj(Z) ones(3,1)  ] );
    a_(k,:) = Q(k,1,:);
    %b_(k,:) = Q(k,2,:);
    c_(k,:) = Q(k,3,:);
    
    % do not change frames for the anti-similarity
    % (to get monotonicity)
    Z = v*[Mdb.oFB1(k,:).' Mdb.oFB2(k,:).' ];
    F_area(k) = sqrt(det(Z'*Z));
    Z = Z(:,1) + 1i*Z(:,2);
    
    Q(k,:,:) = inv( [ Z conj(Z) ones(3,1)  ] );
%     a_(k,:) = Q(k,1,:);
    b_(k,:) = Q(k,2,:);
%     c_(k,:) = Q(k,3,:);


end


Mdb.a_ = a_;
Mdb.b_ = b_;
Mdb.c_ = c_;

Mdb.F_area = F_area;
