function [E2F] = CORR_compute_edge2face(E2V,edge_num,V2F)
% E2F(k,:) are the indices of the two faces touching edge k
%(if one face touching edge the second index is zero)

E2F = zeros(edge_num,2); %edges with one face touching them will get a zero

for k=1:edge_num
    
    iv = E2V(k,:);
    if1 = [V2F{iv(1)}]; 
    if2 = [V2F{iv(2)}]; 
    
    %the faces that touch the two two vertices that define edge k are the
    %faces touching edge k
    ife = intersect(if1,if2);
    if(length(ife)==1)
        E2F(k,1) = ife;
    elseif(length(ife)==2)
        E2F(k,:) = ife;
        
    else
        error('found edge with more than two faces touching - not a manifold!');
    end
end

