function [M edge_to_vertex_map edge_num M_orientation] = CORR_compute_edge_numbering_fast(F)
disp('compute edge numbering');
%use Gabriel Peyr's code
num_of_vertices = max(max(F));

face=F';
n=max(F(:));

  i = [face(1,:) face(2,:) face(3,:) face(2,:) face(3,:) face(1,:)];
    j = [face(2,:) face(3,:) face(1,:) face(1,:) face(2,:) face(3,:)];
    I = find(i<j);
    i = i(I); j = j(I);
    [tmp,I] = unique(i + 1234567*j);
    i = i(I); j = j(I);
    ne = length(i); % number of edges
    s = (1:ne);

    A = sparse([i;j],[j;i],[s;s],n,n);

    edge_num = ne;
    M=A;
    
    M_orientation = [];
    
   edge_to_vertex_map = [i' j'];
   
   %on the boundary make sure the edges are positively oriented
    i = [face(1,:) face(2,:) face(3,:) ];
    j = [face(2,:) face(3,:) face(1,:) ];
    M_orientation = sparse(i,j,ones(1,length(i)),n,n);
    M_orientation = M_orientation - M_orientation';
    tinds = find(M_orientation>10^-8); %the boundary edges
     [row col] = find(M_orientation>10^-8);
    edge_to_vertex_map(A(tinds),:) = [row col];

   
%M=-ones(num_of_vertices,num_of_vertices);
% M = sparse(num_of_vertices, num_of_vertices);
% M_orientation = sparse(num_of_vertices, num_of_vertices);
% 
% cnt=0;
% for i=1:size(F,1)
%     progressbar(i,size(F,1),40);
%     n1 = F(i,1);
%     n2 = F(i,2);
%     n3 = F(i,3);
%     
%     if(  M(n1,n2) == 0 )
%         cnt=cnt+1;
%          
%         M(n1,n2)=cnt;
%         M(n2,n1)=cnt;
%         M_orientation(n1,n2)=1;
%         M_orientation(n2,n1)=-1;
%     end
%     
%     if( M(n3,n1) == 0)
%         cnt=cnt+1;
%         M(n1,n3)=cnt;
%         M(n3,n1)=cnt;        
%         M_orientation(n1,n3)=-1;
%         M_orientation(n3,n1)=1;        
%     end
%     
%     if( M(n2,n3) == 0)
%         cnt=cnt+1;
%         M(n3,n2)=cnt;
%         M(n2,n3)=cnt;        
%         M_orientation(n3,n2)=-1;
%         M_orientation(n2,n3)=1;     
%     end
%     
%    
%     
%     
% end
% 
% edge_num = cnt;
% 
% %new code
% [row col] = find(M_orientation == 1);%take correct orientation at boundary
% edge_to_vertex_map = [row col];
% 
% % % edge_to_vertex_map = zeros(edge_num,2);
% % % ind = find(M ~= 0);%old no orientation
% % % % ind = find(M_orientation == 1);%take correct orientation at boundary
% % % dimM=size(M,1);
% % % for k=1:length(ind)
% % %     %where ind is in the matrix M\
% % %     temp = mod(ind(k),dimM);
% % %     edge_to_vertex_map(M(ind(k)),:) = [int32(1 + ( (ind(k)-temp)/dimM ) ) , temp ];
% % %     
% % % end