function [Mdb] = MESH_build_frame_field(Mdb,problem)
%++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
% build the initial frame field on faces 
% (based on type of initialization described in the struct problem).

M=Mdb.M;

switch(problem.frame_initialization_method)
    
    case 'harmonic'
        %discrete harmonic frame field
        %assume one boundary component 
        disp('Build initial frame field - assume one boundary component...');
        [FB1 FB2 U pinds NF] = PARAM_calc_harmonic_local_frames_in_faces(Mdb.V,Mdb.F,Mdb);
  
    case 'identity'
        %take all identity frames
        e1=1;
        e2=1i;
        M=Mdb.M;
        FB1 = ones(M,1)*[real(e1) imag(e1) 0];
        FB2 = ones(M,1)*[real(e2) imag(e2) 0];
        NF = cross(FB1,FB2);
        pinds = [];
        
    
    case 'remesh' 
        %here we assume planar setting
        %choose non-orthonormal frames such that in that frame each
        %triangle is equilateral
        M=Mdb.M;
        F=Mdb.F;
        V=Mdb.V;
        if(size(V,2)==3)
            V=V(:,1:2);
        end
        %equilateral
        FB1=zeros(M,3);
        FB2=zeros(M,3);
        for k=1:M
            Z=V(F(k,:),1)+1i*V(F(k,:),2);
          
            %find the best similarity taking W to Z
            W = exp(1i*2*pi*[0; 1/3; 2/3]);
            sim_and_t = [W ones(3,1)]\Z;
            W=W*sim_and_t(1) +sim_and_t(2);
            
            %fix the frame
            A = [Z conj(Z) ones(3,1)];
            L = A\W;
            alph = L(1);
            beta = L(2);
            T = [ real(alph)+real(beta) imag(beta)-imag(alph) ; ...
                imag(beta)+imag(alph) real(alph)-real(beta)];
            Bas = inv(T);
            FB1(k,:) = [Bas(:,1)' 0];
            FB2(k,:) = [Bas(:,2)' 0];
            
        end
        
        NF = cross(FB1,FB2);
        pinds = [];%[1 2];
        
  
    case 'previously_processed'
        %in case frame field is already given
        
end

Mdb.FB1=FB1;
Mdb.FB2=FB2;
Mdb.pinds=pinds;
Mdb.NF=NF;

% keep also an original version of frames (for the anti-similarity -> to get
% monotonicity)
Mdb.oFB1=FB1;
Mdb.oFB2=FB2;

%++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
% for each face j, find the linear functional giving a,b,c where
% [a b c] = Z^-1 * u(F(j,:)).'
Q = zeros(M,3,3);
a_ = zeros(M,3);
b_ = zeros(M,3);
c_ = zeros(M,3);
F_area=zeros(M,1);
for  k=1:M
    progressbar(k,M,20);
    
    %write the vertices position of each triangles' vertices in local
    %complex frame
    v=Mdb.V(Mdb.F(k,:),:);
    v=v-ones(3,1)*Mdb.P(k,:);
    
    Z = v*[FB1(k,:).' FB2(k,:).' ];
    F_area(k) = norm(cross(Z(:,1),Z(:,2)));
    Z = Z(:,1) + 1i*Z(:,2);
    
    Q(k,:,:) = inv( [ Z conj(Z) ones(3,1)  ] );
    a_(k,:) = Q(k,1,:);
    %b_(k,:) = Q(k,2,:);
    c_(k,:) = Q(k,3,:);
    
    % do not change frames for the anti-similarity
    % (to get monotonicity)
    Z = v*[Mdb.oFB1(k,:).' Mdb.oFB2(k,:).' ];
    F_area(k) = norm(cross(Z(:,1),Z(:,2)));
    Z = Z(:,1) + 1i*Z(:,2);
    
    Q(k,:,:) = inv( [ Z conj(Z) ones(3,1)  ] );
%     a_(k,:) = Q(k,1,:);
    b_(k,:) = Q(k,2,:);
%     c_(k,:) = Q(k,3,:);
    
    
        
end


Mdb.a_ = a_;
Mdb.b_ = b_;
Mdb.c_ = c_;

Mdb.F_area = F_area;


