function Mdb =MESH_prepare_data(V,F)
%++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
% build the mesh data structure 
%
%
% we assume V(vertices),F(faces) are in R^{Nx3} and R^{Mx3}, respectively,
% where N=#vertices, M=#faces.

Mdb.N=size(V,1);
Mdb.M=size(F,1);
M=Mdb.M;
N=Mdb.N;

Mdb.V=V;
Mdb.F=F;

%find centroids of triangles
P=zeros(M,3);
for k=1:M
    P(k,:) = mean(V(F(k,:),:));
end
Mdb.P=P;


Mdb.A = triangulation2adjacency(F,V); %adjacency matrix

%%old and safe but slow:
%[M1 edge_to_vertex_map1 edge_num1] = CORR_compute_edge_numbering(F);

%%new and fast 
[M1 edge_to_vertex_map1 edge_num1] = CORR_compute_edge_numbering_fast(F);
Mdb.E2V = edge_to_vertex_map1;
Mdb.num_edges = edge_num1;
Mdb.V2F = compute_vertex_face_ring(F);
Mdb.adj2edgenum=M1; %this is useful to find the edge number (name) between two connected vertices
Mdb.E2F = CORR_compute_edge2face(Mdb.E2V,Mdb.num_edges,Mdb.V2F);


