function [G NF] = PARAM_calc_gradient_on_faces(V,F,U)
%calculate the per-face gradients of a scalar fucntion U
%return also the normals to the faces NF

% disp('calculate per-face gradient');

M=size(F,1);
N=size(V,1);


G=zeros(M,3);
NF=zeros(M,3);
v = zeros(3,3);
for k=1:M
    progressbar(k,M,40);
    
    f=F(k,:);
    
    %the boundary vectors
    for j=1:3
        if(j==3)
            jnext=1;
        else
            jnext=j+1;
        end
        v(j,:) = V(f(jnext),:) - V(f(j),:);
    end
    
    %calculate the gradient of face k
    %for rotating by 90deg on face by cross product with orthonormal vector
    r = cross(v(1,:),-v(3,:));
    area2 = norm(r);
    r=r/area2;
    
    NF(k,:) = r;   %record the normal to the face
    
    g = zeros(1,3);
    tind = [3 1 2]; %the indices of the opposite vertex
    for j=1:3
        g = g + U(f(tind(j)))*cross(r,v(j,:))/area2;        
    end
       
    G(k,:) = g;
    
    
    
end