function [FB1 FB2 U pinds NF] = PARAM_calc_harmonic_local_frames_in_faces(V,F,Mdb)
%++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
% Calculating the frame field based on a harmonic potential function U
% FB1,FB2 are the frames (per face),
% pinds are the boundary vertices' indices used for constructing U, 
% NF are the faces' normals 
%
% NOTE: HERE WE BUILD THE FRAME FIELD ASSUMING ONE BOUNDARY COMPONENT.

%++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
M = Mdb.M; %number of faces
N = Mdb.N; % number of vertices
% A = Mdb.A;
E2V = Mdb.E2V;
V2F = Mdb.V2F;


%++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
% define local frame per face 
% find two boundary points (we are not checking if they are on the same boundary component)
% to constrain the field
binds = CORR_locate_boundary_vertices(E2V,V2F);
pinds = CORR_spread_points_euclidean(V(binds,:),[],2);
pinds = binds(pinds); %the final two indices on the boundary

%++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
% define a smooth scalar field and use its gradient for frame definition
% use Mean-Value-Coordinates.

% L = compute_geometric_laplacian(V,F,'distance');
% L = compute_combinatorial_laplacian(A);
L = CORR_compute_mvc_laplacian(V,F);
% [L T] = PARAM_calc_mass(V,F);


% % %take two charges +/-1 on pinds and get potential
L(pinds(1),:) = zeros(1,N); L(pinds(1),pinds(1)) = 1;
L(pinds(2),:) = zeros(1,N); L(pinds(2),pinds(2)) = 1;
B = zeros(N,1); B(pinds(1))=1; B(pinds(2))=-1;
%the potential field
U = L\B;

% % %for debug
% TEETH_output_vtk('harmonic_field.vtk',V,F,U);


%++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
%take the gradient at each face to define the 1st frame basis vector
[GF NF] = PARAM_calc_gradient_on_faces(V,F,U);
%determine the frame for each face
FB1 = zeros(M,3);
FB2 = zeros(M,3);
for k=1:M
    FB1(k,:) = GF(k,:)/norm(GF(k,:));
    FB2(k,:) = cross(NF(k,:),GF(k,:));    
    FB2(k,:) = FB2(k,:)/norm(FB2(k,:));
    
    %for testing: rotate the frames
    tet=(2*rand-1)*pi*0.0;%used 0,0.4,0.7
    te1=FB1(k,:); te2=FB2(k,:);
    FB1(k,:) = te1*cos(tet) + te2*sin(tet);
    FB2(k,:) = -te1*sin(tet) +te2*cos(tet);
    
end
