function [FB1 FB2 U pinds NF] = PARAM_calc_local_frames_in_faces(V,F,Mdb)
%--------------------------------------------------------------------------
% FB1,FB2 are the bases, P is the center of each face (center of local
%frame)
%pinds are two vertices on boundary


%--------------------------------------------------------------------------
% since we are not using that we now simply set an arbitrary frame per face
M = Mdb.M; %number of faces
N = Mdb.N; % number of vertices
% disp('WARNING: compute arbitrary frame per face -- NOT harmonic!');
FB1 = zeros(M,3);
FB2 = zeros(M,3);
NF = zeros(M,3);
for k=1:M
    progressbar(k,M,40);
    v=V(F(k,:),:);
    b1 = v(2,:)- v(1,:);
    b2 = v(3,:)- v(1,:);
    nf = cross(b1,b2);
    nf = nf / sqrt(nf*nf');
    e1=b1/sqrt(b1*b1');
    e2 = cross(nf,e1); 
    e2=e2/sqrt(e2*e2');
    
    NF(k,:)=nf;
    FB1(k,:) = e1;
    FB2(k,:) = e2;
    
end

U = [];
pinds = [];

return;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%  from here below is really an harmonic frame
M = Mdb.M; %number of faces
N = Mdb.N; % number of vertices
% A = Mdb.A;
E2V = Mdb.E2V;
V2F = Mdb.V2F;


%define local frame per face 
% define a smooth scalar field and use its gradient for frames
%find two boundary points to constrain the field
binds = CORR_locate_boundary_vertices(E2V,V2F);
pinds = CORR_spread_points_euclidean(V(binds,:),[],2);
pinds = binds(pinds); %the final two indices on the boundary
% % %select manuall
% pinds= [107 376];%[75 394];%[124 363];%[557 749];%[358 120];%hand
% pinds = [654 1706];%bull 83 1226 483

% pinds

% L = compute_geometric_laplacian(V,F,'distance');
% L = compute_combinatorial_laplacian(A);
L = CORR_compute_mvc_laplacian(V,F);
% [L T] = PARAM_calc_mass(V,F);


% % %take two charges +/-1 and get potential
L(pinds(1),:) = zeros(1,N); L(pinds(1),pinds(1)) = 1;
L(pinds(2),:) = zeros(1,N); L(pinds(2),pinds(2)) = 1;
B = zeros(N,1); B(pinds(1))=1; B(pinds(2))=-1;
%the smooth field
U = L\B;

% %use eigenfunctions
% [teg tev] = eigs(L,6,'sm');
% U=teg(:,3);

% % %for debug
% TEETH_output_vtk('harmonic_field.vtk',V,F,U);
% find(L>0)

%take the gradient at each face to define the 1st frame basis vector
[GF NF] = PARAM_calc_gradient_on_faces(V,F,U);
%determine the frame for each face
FB1 = zeros(M,3);
FB2 = zeros(M,3);
for k=1:M
    FB1(k,:) = GF(k,:)/norm(GF(k,:));
    FB2(k,:) = cross(NF(k,:),GF(k,:));    
    FB2(k,:) = FB2(k,:)/norm(FB2(k,:));
end

% P = zeros(M,3);
% for k=1:M
%     P(k,:) = mean(V(F(k,:),:));
% end