function [tP X Mdb] = QCONF_apply_image_deformation(Z,W,P,method, ...
    TRI,AA, Xref, Mdb,tP_ref,poly_deform,C_, iter)
%TRI is a mesh for the points P
%AA is a matrix for d/dbar{z}
% Xref, Mdb are results from a previous run (optional)
% tP_ref is in case the initial guess comes from outside source (e.g. ARAP
% algorithm) in this case we transform it first to Xref,Mdb
%%parameters:
we_arap = 1000;
we=1000;
X=[];

problem.onlyU=0; %use redundant representation (affine map per face)
problem.quiet=1;
problem.iter_max =10;%maximal number of iterations


switch method
    
         %--------------------------------------------------------
         %  BD_LSCM
    case 'BD_LSCM'
        problem.iter = iter; %3; %number of iterations
        %problem.constraints =  {  'CC' ,'PC', 'CDC_Linf','LBr_eps'};%_Linf'}%,'HC'}%_Linf'}%,'HC'}%,'LBa'}%_Linf'}%, 'SVC' } %,CDC_Linf 'HC'} %'CDC','CDC-AP' 'SVC' };%, 'PC'  };
        problem.constraints =  {  'CC' ,'PC', 'CDC_L1','LBr_eps'};
        problem.energy = { 'l2_L2' };%'l2_BIH','l1_L2','l2_L2','l1_Linf','l1_L1','l1_H2','l2_H2','l1_H2-AP','linf_Linf','linf_Linf_SMOOTH' };
        problem.user_constraints = {'point'};% 'pl_boundary' 'point' 'rotation_scale'
        problem.solver = {'QP_Matlab'};% 'Mosek','QP_Matlab'
        problem.C_ = C_; %1.5;
        q=2*sqrt(problem.C_);
        problem.s_ = 1/q;
        problem.S_ = q;
        problem.frame_initialization_method = 'identity'; %'harmonic','identity','polydeform'
        problem.U00 = Z;
        problem.U11 = W;
        
        if(poly_deform==1)
            problem.frame_initialization_method = 'polydeform'; %choose: 'harmonic' or 'identity' or 'polydeform'
            problem.user_constraints = {'pl_boundary'};% 'pl_boundary' 'point' 'rotation_scale'
            problem.P1=[real(problem.U00) imag(problem.U00)];
            problem.P2= [real(problem.U11) imag(problem.U11)];
        end
        
        [tP X Mdb] = QCONF_warp([real(P) imag(P)],TRI,problem,Xref, Mdb);
        tP = tP(:,1)+1i*tP(:,2);
   
       %--------------------------------------------------------
        %  init_BD_LSCM : take LSCM to build initial frames
    case 'init_BD_LSCM'
        problem.iter = iter; %3; %number of iterations
        %problem.constraints =  { 'CC',  'PC', 'CDC_Linf'};%,'SVC_Linf'};%_Linf'}%,'HC'}%_Linf'}%,'HC'}%,'LBa'}%_Linf'}%, 'SVC' } %,CDC_Linf 'HC'} %'CDC','CDC-AP' 'SVC' };%, 'PC'  };
        problem.constraints =  { 'CC',  'PC', 'CDC_L1'};%,'SVC_Linf'};%_Linf'}%,'HC'}%_Linf'}%,'HC'}%,'LBa'}%_Linf'}%, 'SVC' } %,CDC_Linf 'HC'} %'CDC','CDC-AP' 'SVC' };%, 'PC'  };
        problem.energy = { 'l2_L2' };%'l2_BIH','l1_L2','l2_L2','l1_Linf','l1_L1','l1_H2','l2_H2','l1_H2-AP','linf_Linf','linf_Linf_SMOOTH' };
        problem.user_constraints = {'point'};% 'pl_boundary' 'point' 'rotation_scale'
        problem.solver = {'QP_Matlab'};% 'Mosek','QP_Matlab'
        problem.C_ = C_; %1.5;
        q=2*sqrt(problem.C_);
        problem.s_ = 1/q;
        problem.S_ = q;
        problem.frame_initialization_method = 'identity'; %'harmonic','identity','polydeform'
        problem.U00 = Z;
        problem.U11 = W;
        problem.onlyU=1;
        
         if(poly_deform==1)
            problem.frame_initialization_method = 'polydeform'; %choose: 'harmonic' or 'identity' or 'polydeform'
            problem.user_constraints = {'pl_boundary'};% 'pl_boundary' 'point' 'rotation_scale'
            problem.P1=[real(problem.U00) imag(problem.U00)];
            problem.P2= [real(problem.U11) imag(problem.U11)];
        end
        
        %if there is an initial deformation guess, construct X,Mdb outof it
        %for initial starting the warp procedure
        if(exist('tP_ref'))
            if(~isempty(tP_ref))
                disp('found initial guess for init_BD_LSCM from outside deformation algorithm.');
                [Xref Mdb] = QCONF_build_Xsol([real(P) imag(P) 0*imag(P)],...
                                                TRI,tP_ref,problem);
            end
        end
        
        [tP X Mdb] = QCONF_map([real(P) imag(P)],TRI,problem,Xref, Mdb);
        tP = tP(:,1)+1i*tP(:,2);
            
        %--------------------------------------------------------
        %  init_BD_l2_ARAP
    case 'init_BD_l2_ARAP'
        problem.iter = iter; %2; %number of iterations
%         problem.constraints =  {  'CC' ,'PC', 'CDC_Linf'};%,'LBr_eps'}%,'SVC_Linf'};%_Linf'}%,'HC'}%_Linf'}%,'HC'}%,'LBa'}%_Linf'}%, 'SVC' } %,CDC_Linf 'HC'} %'CDC','CDC-AP' 'SVC' };%, 'PC'  };
        problem.constraints =  {  'CC' ,'PC', 'CDC_L1'};%,'LBr_eps'}%,'SVC_Linf'};%_Linf'}%,'HC'}%_Linf'}%,'HC'}%,'LBa'}%_Linf'}%, 'SVC' } %,CDC_Linf 'HC'} %'CDC','CDC-AP' 'SVC' };%, 'PC'  };
        problem.energy = { 'l2_ARAP' };%'l2_BIH','l1_L2','l2_L2','l1_Linf','l1_L1','l1_H2','l2_H2','l1_H2-AP','linf_Linf','linf_Linf_SMOOTH' };
        problem.user_constraints = {'point'};% 'pl_boundary' 'point' 'rotation_scale'
        problem.solver = {'QP_Matlab'};% 'Mosek','QP_Matlab'
        problem.C_ = C_; %2;
        q=2*sqrt(problem.C_);
        problem.s_ = 1/q;
        problem.S_ = q;
        problem.frame_initialization_method = 'identity'; %'harmonic','identity','polydeform'
        problem.U00 = Z;
        problem.U11 = W;
        
        %if there is an initial deformation guess, construct X,Mdb outof it
        %for initial starting the warp procedure
        if(exist('tP_ref'))
            if(~isempty(tP_ref))
                disp('found initial guess for BD_l2_ARAP from outside deformation algorithm.');
                [Xref Mdb] = QCONF_build_Xsol([real(P) imag(P) 0*imag(P)],...
                                                TRI,tP_ref,problem);
            end
        end
        
        [tP X Mdb] = QCONF_map([real(P) imag(P)],TRI,problem,Xref, Mdb);
%          [tP X Mdb] = QCONF_warp([real(P) imag(P)],TRI,problem,[], []);
        tP = tP(:,1)+1i*tP(:,2);
           
        
        %--------------------------------------------------------
        %  BD_CM_l2_L2_ARAP
    case 'BD_CM_l2_L2_ARAP'
        problem.iter = iter; %3; %number of iterations
%         problem.constraints =  {  'CC' ,'PC', 'CDC_Linf','SVC_Linf','LBr_eps'};%_Linf'}%,'HC'}%_Linf'}%,'HC'}%,'LBa'}%_Linf'}%, 'SVC' } %,CDC_Linf 'HC'} %'CDC','CDC-AP' 'SVC' };%, 'PC'  };
        problem.constraints =  {  'CC' ,'PC', 'CDC_L1','SVC_Linf','LBr_eps'};%_Linf'}%,'HC'}%_Linf'}%,'HC'}%,'LBa'}%_Linf'}%, 'SVC' } %,CDC_Linf 'HC'} %'CDC','CDC-AP' 'SVC' };%, 'PC'  };
        problem.energy = { 'l2_L2' };%'l2_BIH','l1_L2','l2_L2','l1_Linf','l1_L1','l1_H2','l2_H2','l1_H2-AP','linf_Linf','linf_Linf_SMOOTH' };
        problem.user_constraints = {'point'};% 'pl_boundary' 'point' 'rotation_scale'
        problem.solver = {'QP_Matlab'};% 'Mosek','QP_Matlab'
        problem.C_ = C_; %1.5;
        q=1.25*sqrt(problem.C_);
        problem.s_ = 1/q;
        problem.S_ = q;
        problem.frame_initialization_method = 'identity'; %'harmonic','identity','polydeform'
        problem.U00 = Z;
        problem.U11 = W;
        
        
        [tP X Mdb] = QCONF_warp([real(P) imag(P)],TRI,problem,Xref, Mdb);
        tP = tP(:,1)+1i*tP(:,2);
     
       %--------------------------------------------------------
        %  BD_l2_ARAP_NO_ITER
    case 'BD_l2_ARAP_NO_ITER'
        problem.iter = iter; %0; %number of iterations
        %problem.constraints =  {  'CC' ,'PC', 'CDC_Linf','SVC_Linf'};%_Linf'}%,'HC'}%_Linf'}%,'HC'}%,'LBa'}%_Linf'}%, 'SVC' } %,CDC_Linf 'HC'} %'CDC','CDC-AP' 'SVC' };%, 'PC'  };
        problem.constraints =  {  'CC' ,'PC', 'CDC_L1','SVC_Linf'};%_Linf'}%,'HC'}%_Linf'}%,'HC'}%,'LBa'}%_Linf'}%, 'SVC' } %,CDC_Linf 'HC'} %'CDC','CDC-AP' 'SVC' };%, 'PC'  };
        problem.energy = { 'l2_ARAP' };%'l2_BIH','l1_L2','l2_L2','l1_Linf','l1_L1','l1_H2','l2_H2','l1_H2-AP','linf_Linf','linf_Linf_SMOOTH' };
        problem.user_constraints = {'point'};% 'pl_boundary' 'point' 'rotation_scale'
        problem.solver = {'QP_Matlab'};% 'Mosek','QP_Matlab'
        problem.C_ = C_; %1.5;
        q=2*sqrt(problem.C_);
        problem.s_ = 1/q;
        problem.S_ = q;
        problem.frame_initialization_method = 'identity'; %'harmonic','identity','polydeform'
        problem.U00 = Z;
        problem.U11 = W;
           
        
        [tP X Mdb] = QCONF_warp([real(P) imag(P)],TRI,problem,Xref, Mdb);
%         tP = tP(:,1)+1i*tP(:,2);
       %--------------------------------------------------------
        %  BD_NO_l2_ARAP - no boundeed distortion
    case 'BD_NO_l2_ARAP'
        problem.iter = iter; %3; %number of iterations
        problem.constraints =  {  'CC' ,'PC'}%, 'CDC_Linf','SVC_Linf'};%_Linf'}%,'HC'}%_Linf'}%,'HC'}%,'LBa'}%_Linf'}%, 'SVC' } %,CDC_Linf 'HC'} %'CDC','CDC-AP' 'SVC' };%, 'PC'  };
        problem.energy = { 'l2_ARAP' };%'l2_BIH','l1_L2','l2_L2','l1_Linf','l1_L1','l1_H2','l2_H2','l1_H2-AP','linf_Linf','linf_Linf_SMOOTH' };
        problem.user_constraints = {'point'};% 'pl_boundary' 'point' 'rotation_scale'
        problem.solver = {'Mosek'};% 'Mosek','QP_Matlab'
        problem.C_ = C_; %1.5;
        q=2*sqrt(problem.C_);
        problem.s_ = 1/q;
        problem.S_ = q;
        problem.frame_initialization_method = 'identity'; %'harmonic','identity','polydeform'
        problem.U00 = Z;
        problem.U11 = W;
        
        
        [tP X Mdb] = QCONF_warp([real(P) imag(P)],TRI,problem,Xref, Mdb);
        tP = tP(:,1)+1i*tP(:,2);
           
        %--------------------------------------------------------
        %  BD_BIH
    case 'BD_BIH'
        problem.iter = iter; %3; %number of iterations
%         problem.constraints =  {  'CC' ,'PC', 'CDC_Linf'};%_Linf'}%,'HC'}%_Linf'}%,'HC'}%,'LBa'}%_Linf'}%, 'SVC' } %,CDC_Linf 'HC'} %'CDC','CDC-AP' 'SVC' };%, 'PC'  };
        problem.constraints =  {  'CC' ,'PC', 'CDC_L1'};%_Linf'}%,'HC'}%_Linf'}%,'HC'}%,'LBa'}%_Linf'}%, 'SVC' } %,CDC_Linf 'HC'} %'CDC','CDC-AP' 'SVC' };%, 'PC'  };
        problem.energy = { 'l2_BIH' };%'l2_BIH','l1_L2','l2_L2','l1_Linf','l1_L1','l1_H2','l2_H2','l1_H2-AP','linf_Linf','linf_Linf_SMOOTH' };
        problem.user_constraints = {'point'};% 'pl_boundary' 'point' 'rotation_scale'
        problem.solver = {'QP_Matlab'};% 'Mosek','QP_Matlab'
        problem.C_ = C_; %5;
        q=2*sqrt(problem.C_);
        problem.s_ = 1/q;
        problem.S_ = q;
        problem.frame_initialization_method = 'identity'; %'harmonic','identity','polydeform'
        if(Mdb.fix_boundary>0)
            [binds] = QCONF_locate_grid_boundary_vertex_layer(1.5,Mdb.dt,P);
            problem.U00 = [P(binds); Z];
            problem.U11 = [P(binds); W];
            
        else
            problem.U00 = Z;
            problem.U11 = W;
        end
        
        [tP X Mdb] = QCONF_warp([real(P) imag(P)],TRI,problem,Xref, Mdb);
        tP = tP(:,1)+1i*tP(:,2);
      %--------------------------------------------------------
        %  BD_BIH_COT_noCDC - biharmonic with cot weights on vertices with no
        %  bounded distortion
    case 'BD_BIH_COT_noCDC'
        problem.iter = iter; %3; %number of iterations
        problem.constraints =  {  'CC' ,'PC'};%_Linf'}%,'HC'}%_Linf'}%,'HC'}%,'LBa'}%_Linf'}%, 'SVC' } %,CDC_Linf 'HC'} %'CDC','CDC-AP' 'SVC' };%, 'PC'  };
        problem.energy = { 'l2_BIH_COT' };%'l2_BIH','l1_L2','l2_L2','l1_Linf','l1_L1','l1_H2','l2_H2','l1_H2-AP','linf_Linf','linf_Linf_SMOOTH' };
        problem.user_constraints = {'point'};% 'pl_boundary' 'point' 'rotation_scale'
        problem.solver = {'QP_Matlab'};% 'Mosek','QP_Matlab'
        problem.C_ = C_; %5;
        q=2*sqrt(problem.C_);
        problem.s_ = 1/q;
        problem.S_ = q;
        problem.frame_initialization_method = 'identity'; %'harmonic','identity','polydeform'
        if(Mdb.fix_boundary>0)
            [binds] = QCONF_locate_grid_boundary_vertex_layer(1.5,Mdb.dt,P);
            problem.U00 = [P(binds); Z];
            problem.U11 = [P(binds); W];
            
        else
            problem.U00 = Z;
            problem.U11 = W;
        end
        
        problem.onlyU=1;
        [tP X Mdb] = QCONF_warp([real(P) imag(P)],TRI,problem,Xref, Mdb);
        tP = tP(:,1)+1i*tP(:,2);
        
        
        
        %--------------------------------------------------------
        %  BD_BIH_COT - biharmonic with cot weights on vertices
    case 'BD_BIH_COT'
        problem.iter = iter; %3; %number of iterations
        %problem.constraints =  {  'CC' ,'PC', 'CDC_Linf'};%_Linf'}%,'HC'}%_Linf'}%,'HC'}%,'LBa'}%_Linf'}%, 'SVC' } %,CDC_Linf 'HC'} %'CDC','CDC-AP' 'SVC' };%, 'PC'  };
        problem.constraints =  {  'CC' ,'PC', 'CDC_L1'};%_Linf'}%,'HC'}%_Linf'}%,'HC'}%,'LBa'}%_Linf'}%, 'SVC' } %,CDC_Linf 'HC'} %'CDC','CDC-AP' 'SVC' };%, 'PC'  };
        problem.energy = { 'l2_BIH_COT' };%'l2_BIH','l1_L2','l2_L2','l1_Linf','l1_L1','l1_H2','l2_H2','l1_H2-AP','linf_Linf','linf_Linf_SMOOTH' };
        problem.user_constraints = {'point'};% 'pl_boundary' 'point' 'rotation_scale'
        problem.solver = {'QP_Matlab'};% 'Mosek','QP_Matlab'
        problem.C_ = C_; %5;
        q=2*sqrt(problem.C_);
        problem.s_ = 1/q;
        problem.S_ = q;
        problem.frame_initialization_method = 'identity'; %'harmonic','identity','polydeform'
        if(Mdb.fix_boundary>0)
            [binds] = QCONF_locate_grid_boundary_vertex_layer(1.5,Mdb.dt,P);
            problem.U00 = [P(binds); Z];
            problem.U11 = [P(binds); W];
            
        else
            problem.U00 = Z;
            problem.U11 = W;
        end
        
        problem.onlyU=1;
        [tP X Mdb] = QCONF_map([real(P) imag(P)],TRI,problem,Xref, Mdb);
        tP = tP(:,1)+1i*tP(:,2);
      
        %--------------------------------------------------------
        %  BD_BIH_COT_ARAP - biharmonic with cot weights on vertices ARAP
    case 'BD_BIH_COT_ARAP'
        problem.iter = iter; %3; %number of iterations
        %problem.constraints =  {  'CC' ,'PC', 'CDC_Linf','SVC_Linf'};%_Linf'}%,'HC'}%_Linf'}%,'HC'}%,'LBa'}%_Linf'}%, 'SVC' } %,CDC_Linf 'HC'} %'CDC','CDC-AP' 'SVC' };%, 'PC'  };
        problem.constraints =  {  'CC' ,'PC', 'CDC_L1','SVC_Linf'};%_Linf'}%,'HC'}%_Linf'}%,'HC'}%,'LBa'}%_Linf'}%, 'SVC' } %,CDC_Linf 'HC'} %'CDC','CDC-AP' 'SVC' };%, 'PC'  };
        problem.energy = { 'l2_BIH_COT' };%'l2_BIH','l1_L2','l2_L2','l1_Linf','l1_L1','l1_H2','l2_H2','l1_H2-AP','linf_Linf','linf_Linf_SMOOTH' };
        problem.user_constraints = {'point'};% 'pl_boundary' 'point' 'rotation_scale'
        problem.solver = {'QP_Matlab'};% 'Mosek','QP_Matlab'
        problem.C_ = C_; %1.5;
        q=1.5*sqrt(problem.C_);
        problem.s_ = 1/q;
        problem.S_ = q;
        problem.frame_initialization_method = 'identity'; %'harmonic','identity','polydeform'
        if(Mdb.fix_boundary>0)
            [binds] = QCONF_locate_grid_boundary_vertex_layer(1.5,Mdb.dt,P);
            problem.U00 = [P(binds); Z];
            problem.U11 = [P(binds); W];
            
        else
            problem.U00 = Z;
            problem.U11 = W;
        end
        
        
        [tP X Mdb] = QCONF_warp([real(P) imag(P)],TRI,problem,Xref, Mdb);
        tP = tP(:,1)+1i*tP(:,2);
           
          
        
        %--------------------------------------------------------
        %  BD_H_l1L2
    case 'BD_H_l1L2'
        problem.iter = iter; %2; %number of iterations
        problem.constraints =  {  'CC' ,'PC', 'CDC','HC'};%_Linf'}%,'HC'}%_Linf'}%,'HC'}%,'LBa'}%_Linf'}%, 'SVC' } %,CDC_Linf 'HC'} %'CDC','CDC-AP' 'SVC' };%, 'PC'  };
        problem.energy = { 'l1_H2' };%'l2_BIH','l1_L2','l2_L2','l1_Linf','l1_L1','l1_H2','l2_H2','l1_H2-AP','linf_Linf','linf_Linf_SMOOTH' };
        problem.user_constraints = {'point'};% 'pl_boundary' 'point' 'rotation_scale'
        problem.solver = {'Mosek'};% 'Mosek','QP_Matlab'
        problem.C_ = C_; %5;
        q=1.5*sqrt(problem.C_);
        problem.s_ = 1/q;
        problem.S_ = q;
        problem.frame_initialization_method = 'identity'; %'harmonic','identity','polydeform'
        problem.U00 = Z;
        problem.U11 = W;
        
        
        [tP X Mdb] = QCONF_warp([real(P) imag(P)],TRI,problem,Xref, Mdb);
        tP = tP(:,1)+1i*tP(:,2);
        
        %--------------------------------------------------------
        %  BD_H_l2L2
    case 'BD_H_l2L2'
        problem.iter = iter; %2; %number of iterations
        %problem.constraints =  {  'CC' ,'PC', 'CDC_Linf'};%_Linf'}%,'HC'}%_Linf'}%,'HC'}%,'LBa'}%_Linf'}%, 'SVC' } %,CDC_Linf 'HC'} %'CDC','CDC-AP' 'SVC' };%, 'PC'  };
        problem.constraints =  {  'CC' ,'PC', 'CDC_L1'};%_Linf'}%,'HC'}%_Linf'}%,'HC'}%,'LBa'}%_Linf'}%, 'SVC' } %,CDC_Linf 'HC'} %'CDC','CDC-AP' 'SVC' };%, 'PC'  };
        problem.energy = { 'l2_H2' };%'l2_BIH','l1_L2','l2_L2','l1_Linf','l1_L1','l1_H2','l2_H2','l1_H2-AP','linf_Linf','linf_Linf_SMOOTH' };
        problem.user_constraints = {'point'};% 'pl_boundary' 'point' 'rotation_scale'
        problem.solver = {'QP_Matlab'};% 'Mosek','QP_Matlab'
        problem.C_ = C_; %5;
        q=1.5*sqrt(problem.C_);
        problem.s_ = 1/q;
        problem.S_ = q;
        problem.frame_initialization_method = 'identity'; %'harmonic','identity','polydeform'
        problem.U00 = Z;
        problem.U11 = W;
        
        
        [tP X Mdb] = QCONF_warp([real(P) imag(P)],TRI,problem,Xref, Mdb);
        tP = tP(:,1)+1i*tP(:,2);
        
        
        
        %--------------------------------------------------------
        %  BD_BIH_ARAP
    case 'BD_BIH_ARAP'
        problem.iter = iter; %3; %number of iterations
        %problem.constraints =  {  'CC' ,'PC', 'CDC_Linf','SVC_Linf'};%_Linf'}%,'HC'}%_Linf'}%,'HC'}%,'LBa'}%_Linf'}%, 'SVC' } %,CDC_Linf 'HC'} %'CDC','CDC-AP' 'SVC' };%, 'PC'  };
        problem.constraints =  {  'CC' ,'PC', 'CDC_L1','SVC_Linf'};%_Linf'}%,'HC'}%_Linf'}%,'HC'}%,'LBa'}%_Linf'}%, 'SVC' } %,CDC_Linf 'HC'} %'CDC','CDC-AP' 'SVC' };%, 'PC'  };
        problem.energy = { 'l2_BIH' };%'l2_BIH','l1_L2','l2_L2','l1_Linf','l1_L1','l1_H2','l2_H2','l1_H2-AP','linf_Linf','linf_Linf_SMOOTH' };
        problem.user_constraints = {'point'};% 'pl_boundary' 'point' 'rotation_scale'
        problem.solver = {'QP_Matlab'};% 'Mosek','QP_Matlab'
        problem.C_ = C_; %1.5;
        q=1.5*sqrt(problem.C_);
        problem.s_ = 1/q;
        problem.S_ = q;
        problem.frame_initialization_method = 'identity'; %'harmonic','identity','polydeform'
        problem.U00 = Z;
        problem.U11 = W;
        
        
        [tP X Mdb] = QCONF_warp([real(P) imag(P)],TRI,problem,Xref, Mdb);
        tP = tP(:,1)+1i*tP(:,2);
        
        %--------------------------------------------------------
        %  BD_CM_l1_Linf_ARAP
    case 'BD_CM_l1_Linf_ARAP'
        problem.iter = iter; %5; %number of iterations
        problem.constraints =  {  'CC' ,'PC', 'CDC','SVC'};%_Linf'}%,'HC'}%_Linf'}%,'HC'}%,'LBa'}%_Linf'}%, 'SVC' } %,CDC_Linf 'HC'} %'CDC','CDC-AP' 'SVC' };%, 'PC'  };
        problem.energy = { 'l1_Linf' };%'l2_BIH','l1_L2','l2_L2','l1_Linf','l1_L1','l1_H2','l2_H2','l1_H2-AP','linf_Linf','linf_Linf_SMOOTH' };
        problem.user_constraints = {'point'};% 'pl_boundary' 'point' 'rotation_scale'
        problem.solver = {'Mosek'};% 'Mosek','QP_Matlab'
        problem.C_ = C_; %1.5;
        q=1.5*sqrt(problem.C_);
        problem.s_ = 1/q;
        problem.S_ = q;
        problem.frame_initialization_method = 'identity'; %'harmonic','identity','polydeform'
        problem.U00 = Z;
        problem.U11 = W;
        
        
        [tP X Mdb] = QCONF_warp([real(P) imag(P)],TRI,problem,Xref, Mdb);
        tP = tP(:,1)+1i*tP(:,2);
        
        %--------------------------------------------------------
        %  BD_CM_l1_Linf
    case 'BD_CM_l1_Linf'
        problem.iter = iter; %5; %number of iterations
        problem.constraints =  {  'CC' ,'PC', 'CDC'};%_Linf'}%,'HC'}%_Linf'}%,'HC'}%,'LBa'}%_Linf'}%, 'SVC' } %,CDC_Linf 'HC'} %'CDC','CDC-AP' 'SVC' };%, 'PC'  };
        problem.energy = { 'l1_Linf' };%'l2_BIH','l1_L2','l2_L2','l1_Linf','l1_L1','l1_H2','l2_H2','l1_H2-AP','linf_Linf','linf_Linf_SMOOTH' };
        problem.user_constraints = {'point'};% 'pl_boundary' 'point' 'rotation_scale'
        problem.solver = {'Mosek'};% 'Mosek','QP_Matlab'
        problem.C_ = C_; %1.5;
        q=1.1*sqrt(problem.C_);
        problem.s_ = 1/q;
        problem.S_ = q;
        problem.frame_initialization_method = 'identity'; %'harmonic','identity','polydeform'
        problem.U00 = Z;
        problem.U11 = W;
        
        
        [tP X Mdb] = QCONF_warp([real(P) imag(P)],TRI,problem,Xref, Mdb);
        tP = tP(:,1)+1i*tP(:,2);
        
        
        %--------------------------------------------------------
        % BBW (olga's siggraph 2011 paper)
    case 'BBW'
%         path(path,'C:\Users\ylipman\Dropbox\Projects_working\parameterization\bbw\');
        
        if(Mdb.fix_boundary>0)
            [binds] = QCONF_locate_grid_boundary_vertex_layer(0.5,Mdb.dt,P);
            Z = [P(binds); Z];
            W = [P(binds); W];
        end
        
        [b,bc] = boundary_conditions([real(P) imag(P)],TRI,[real(Z) imag(Z)]);
        % Compute weights
        BBW = biharmonic_bounded([real(P) imag(P)],TRI,b,bc,'conic'); % if mosek is installed this is the fastest option
        % Normalize weights
        BBW = BBW./repmat(sum(BBW,2),1,size(BBW,2));
        
        tP = P + BBW*(W-Z);
        
        
        %--------------------------------------------------------
        % 'takeo-arap-iterative'
    case 'takeo-arap-iterative'
%         path(path,'C:\Users\ylipman\Dropbox\Projects_working\parameterization\ARAP_alec\');
        
        %find indices of U00 in mesh
        U = P; U00=Z;
        cinds=zeros(1,length(U00));
        for k=1:length(U00)
            [tv ti] = min(U-U00(k));
            cinds(k) = ti;
        end
        
        tP = takeo_arap( ...
            [real(P) imag(P)],TRI,cinds,[real(W) imag(W)], ...
            'MaxIter',100, ...
            'Tol',0.75);%    'V0',guess,
%   tP = takeo_arap( ...
%             [real(P) imag(P)],TRI,cinds,[real(W) imag(W)], ...
%             'MaxIter',1000, ...
%             'Tol',0.1);%    'V0',guess,
        
        tP = tP(:,1)+1i*tP(:,2);
        
        %--------------------------------------------------------
        % 'sorkine-arap-iterative'
    case 'sorkine-arap-iterative'
%         path(path,'C:\Users\ylipman\Dropbox\Projects_working\parameterization\ARAP_alec\');
        
        if(Mdb.fix_boundary>0)
            [binds] = QCONF_locate_grid_boundary_vertex_layer(1.5,Mdb.dt,P);
            Z = [P(binds); Z];
            W = [P(binds); W];
        end
        
        %find indices of U00 in mesh
        U = P; U00=Z;
        cinds=zeros(1,length(U00));
        for k=1:length(U00)
            [tv ti] = min(U-U00(k));
            cinds(k) = ti;
        end
        
        tP = arap( ...
            [real(P) imag(P)],TRI,cinds,[real(W) imag(W)]);%, ...
        %       'MaxIter',100, ...
        %           'Tol',0.75);%    'V0',guess,
        tP = tP(:,1)+1i*tP(:,2);
        
        
        
        %--------------------------------------------------------
        % MOBIUS
    case 'MOBIUS'
        [a b c d] = CORR_find_mobius_LS(Z,W,[]);
        tP = CORR_apply_mobius(a,b,c,d,P);
        
        
        
        
        
        %--------------------------------------------------------
        % FPI
    case 'FPI'
        if(length(Z)==4)
            [Zm,Zell] = QCONF_take_polygon_to_affine_ngon_LS(Z);
            [Wm,Well] = QCONF_take_polygon_to_affine_ngon_LS(W);
            tZ = CORR_apply_mobius_as_matrix(Zm,Z);
            tW = CORR_apply_mobius_as_matrix(Wm,W);
            %
            %             P = X(:)+1i*Y(:);%
            tP = CORR_apply_mobius_as_matrix(Zm,P);
            [A1 A2] = QCONF_calc_affine_mobius_from_4_points_on_makbilit(tZ,tW);
            tP = A1*tP + A2*conj(tP);
            tP = CORR_apply_mobius_as_matrix(inv(Wm),tP);
            
            
            
        end
        
        %--------------------------------------------------------------
        %SC
    case 'SC'
        if (length(Z)==4)
            [tP] = QCONF_optimal_quadruplet_SCmap(Z,W,P);
        end
        
        %--------------------------------------------------------------
        %BILINEAR
    case 'BIL'
        if (length(Z)==4)
            [tP] = QCONF_bilinear_warp(Z,W,P);
        end
        
        %--------------------------------------------------------------
        %PROJECTIVE
    case 'PROJ'
        if (length(Z)==4)
            projTrans = maketform('projective',[real(Z) imag(Z)],[real(W) imag(W)]);
            [tX, tY] = tformfwd(projTrans, real(P), imag(P));
            tP = tX+1i*tY;
        end
        
        
        
        %--------------------------------------------------------
        %least-squares conformal map
    case 'LSCM'
        s=length(Z);
        %now find the indices of the mesh vertices (ZZ) that correspond
        %to Z(1),Z(2),Z(3),Z(4)
        sinds=zeros(1,s);
        for jj=1:s
            temp = P-Z(jj); temp=temp.*conj(temp);
            [minval minind] = min(temp);
            sinds(jj) = minind(1);
        end
        A=AA;
        m=size(A,1);
        b=zeros(m+s,1);
        for k=1:s
            A(k+m, sinds(k) ) = we*1;
            b(k+m) = we*W(k);
        end
        
        %solve in the LS sense
        tP = A\b;
        
    case 'LSCM_DBL'
        
        %          [tP] = QCONF_LSCM_dbl_layer(Z,W,P,edge_con,AA,we);
        
        
        
        
        
        %-------------------------------------------------------------
        %ARAP (from the LS-conformal field)
    case 'ARAP'
        s=length(Z);
        %now find the indices of the mesh vertices (ZZ) that correspond
        %to Z(1),Z(2),Z(3),Z(4)
        sinds=zeros(1,s);
        for jj=1:s
            temp = P-Z(jj); temp=temp.*conj(temp);
            [minval minind] = min(temp);
            sinds(jj) = minind(1);
        end
        A=AA;
        m=size(A,1);
        b=zeros(m+s,1);
        for k=1:s
            A(k+m, sinds(k) ) = we*1;
            b(k+m) = we*W(k);
        end
        
        %solve in the LS sense
        tP = A\b;
        
        [L b] = QCONF_calc_ARAP_matrix(P,tP,TRI);%for solving ARAP
        en = size(L,1);
        for k=1:s
            L(k+en, sinds(k) ) = we_arap*1;
            b(k+en) = we_arap*W(k);
        end
        tP = L\b;
        
        
        %-------------------------------------------------------------
        %ARAP_ITER iterative (from the LS-conformal field)
    case 'ARAP_ITER'
        s=length(Z);
        %now find the indices of the mesh vertices (ZZ) that correspond
        %to Z(1),Z(2),Z(3),Z(4)
        sinds=zeros(1,s);
        for jj=1:s
            temp = P-Z(jj); temp=temp.*conj(temp);
            [minval minind] = min(temp);
            sinds(jj) = minind(1);
        end
        A=AA;
        m=size(A,1);
        b=zeros(m+s,1);
        for k=1:s
            A(k+m, sinds(k) ) = we*1;
            b(k+m) = we*W(k);
        end
        
        %solve in the LS sense
        tP = A\b;
        
        for iter=1:3
            
            [L b] = QCONF_calc_ARAP_matrix(P,tP,TRI);%for solving ARAP
            en = size(L,1);
            for k=1:s
                L(k+en, sinds(k) ) = we_arap*1;
                b(k+en) = we_arap*W(k);
            end
            tP = L\b;
            
        end
        
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        %% MVC
        %--------------------------------------------------------------
        % MVC
        
    case 'MVC'
        [tP] = QCONF_MVC_deform(Z,W,P);
        
        
        %MVC - same boundary as FPI
    case 'MVC_sameboundary'
        [tP] = QCONF_MVC_deform_same_boundary(Z,W,P);
        
        %--------------------------------------------------------
        %least-squares FPI MVC
        
    case 'LSFPI_MVC'
        [tP] = QCONF_LSFPI_MVC_deform(Z,W,P);
        
    case 'LSFPI_MVC_MVCw'
        [tP] = QCONF_LSFPI_MVC_deform_with_MVC_weights(Z,W,P);
        
        %----------------------------------------------------------
        %use MVC to stitch FPI
    case 'FPI_stitch_MVC'
        [tP] = QCONF_stitch_FPI_with_MVC(Z,W,P);
        
        %--------------------------------------------------------
        %FPI::: MVC with 2  mobius change of coordinates
    case 'MVCFPI'
        [Zm,Zell] = QCONF_take_polygon_to_affine_ngon_LS(Z);
        [Wm,Well] = QCONF_take_polygon_to_affine_ngon_LS(W);
        tZ = CORR_apply_mobius_as_matrix(Zm,Z);
        tW = CORR_apply_mobius_as_matrix(Wm,W);
        %
        %             P = X(:)+1i*Y(:);%
        tP = CORR_apply_mobius_as_matrix(Zm,P);
        [tP] = QCONF_MVC_deform(tZ,tW,tP);
        tP = CORR_apply_mobius_as_matrix(inv(Wm),tP);
        
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        %% TPS
        %--------------------------------------------------------------
        % TPS
    case 'TPS'
        %         if(~isempty(find(strcmp('TPS',methods))))
        
        if(Mdb.fix_boundary>0)
            [binds] = QCONF_locate_grid_boundary_vertex_layer(1.5,Mdb.dt,P);
            Z = [P(binds); Z];
            W = [P(binds); W];
        end
        
        
        cen= [real(Z) imag(Z)];
        F =  [real(W) imag(W)];
        [ftps] = tpaps(cen.',F.',1);%TEETH_calc_TPS(cen,F);
        tP = fnval(ftps,[real(P) imag(P)].');
        tP=tP.';
        tP = tP(:,1)+1i*tP(:,2);
        %--------------------------------------------------------------
        % TPS double layer for local with derivative continuity
    case 'TPS_DBL'
        %         [tP] = QCONF_TPS_dbl_layer(Z,W,P,edge_con);
        
        %use TPS to deform FPI to smoothley connect to similarities defined
        %at edges
    case 'FPI_stitch_TPS'
        %         [tP]=QCONF_hermite_FPI_with_TPS(Z,W,P,edge_con);
        
        %--------------------------------------------------------
        %FPI:TPS
    case 'TPSFPI'
        [Zm,Zell] = QCONF_take_polygon_to_affine_ngon_LS(Z);
        [Wm,Well] = QCONF_take_polygon_to_affine_ngon_LS(W);
        tZ = CORR_apply_mobius_as_matrix(Zm,Z);
        tW = CORR_apply_mobius_as_matrix(Wm,W);
        %
        %             P = X(:)+1i*Y(:);%
        tP = CORR_apply_mobius_as_matrix(Zm,P);
        cen= [real(tZ) imag(tZ)];
        F =  [real(tW) imag(tW)];
        [ftps] = tpaps(cen.',F.',1);%TEETH_calc_TPS(cen,F);
        tP = fnval(ftps,[real(tP) imag(tP)].');
        tP=tP.';
        tP = tP(:,1)+1i*tP(:,2);
        tP = CORR_apply_mobius_as_matrix(inv(Wm),tP);
        
        %--------------------------------------------------------
        %TPS using local FPI affine
    case 'LSFPI_TPS'
        [tP] = QCONF_LSFPI_TPS_deform(Z,W,P);
        
        
        
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        %% MLS
        
        %--------------------------------------------------------
        %MLS (schaefer) using FPI affine - with weight r^-0.5
    case {'MLSFPIAFF','MLSFPIAFF-0.5'}
        [tP] = QCONF_FPI_MLS(Z,W,P,'aff',-0.5);
        
    case {'MLSFPIAFF_fixedge','MLSFPIAFF-0.5_fixedge'}
        %         [tP] = QCONF_FPI_MLS_fix_an_edge(Z,W,P,'aff',-0.5);
        [tP] = QCONF_FPI_MLS_fix_an_edge_brute(Z,W,P,'aff',-0.5);
        
    case 'MLSFPIAFF-1'
        [tP] = QCONF_FPI_MLS(Z,W,P,'aff',-1);
        
    case 'MLSFPIAFF-2'
        [tP] = QCONF_FPI_MLS(Z,W,P,'aff',-2);
        
        %%% MLS using raif interior weights
    case 'MLSFPI_RAIF'
        [tP] = QCONF_FPI_MLS_RAIF(Z,W,P,'aff',-1);
        
        
    case 'MLSFPIAFF-1-mvcweights'
        [tP] = QCONF_FPI_MLS_inside_weights(Z,W,P,'aff',-1);
        
        
        %--------------------------------------------------------
        %MLS (schaefer) using FPI similarity
    case 'MLSFPISIM'
        decay=-0.5;
        [tP] = QCONF_FPI_MLS(Z,W,P,'sim',decay);
        
        %--------------------------------------------------------
        %MLS (schaefer) using FPI similarity
    case 'MLSFPIRIG'
        decay=-0.5;
        [tP] = QCONF_FPI_MLS(Z,W,P,'rig',decay);
        
        %-------------------------------------------------------------
        %ARAP-MLSFPI
    case 'MLSFPIARAP'
        decay=-0.5;
        [tP] = QCONF_FPI_MLS(Z,W,P,'aff',decay);
        [L b] = QCONF_calc_ARAP_matrix(P,tP,TRI);%for solving ARAP
        en = size(L,1);
        s=length(W);
        %find the Z in P
        sinds=zeros(1,s);
        for jj=1:s
            temp = P-Z(jj); temp=temp.*conj(temp);
            [minval minind] = min(temp);
            sinds(jj) = minind(1);
        end
        
        for k=1:s
            L(k+en, sinds(k) ) = we_arap*1;
            b(k+en) = we_arap*W(k);
        end
        tP = L\b;
        
        %--------------------------------------------------------
        %MLS (schaefer) using FPI for general points (fit only one
        %mobius)
    case 'MLSFPIgeneral'
        [tP] = QCONF_FPI_MLS_generalnpoints(Z,W,P);
        
        %--------------------------------------------------------
        %MLS (schaefer) SIMILARITY
    case 'MLSSIM'
        [tP] = QCONF_schaefer_MLS(Z,W,P,2);
        
        %--------------------------------------------------------
        %MLS (schaefer) RIGID
    case 'MLSRIG'
        [tP] = QCONF_schaefer_MLS(Z,W,P,1);
        
        
        
        %--------------------------------------------------------
        %Green Coordinates
    case 'GC'
        IN = inpolygon(real(P),imag(P),real(Z),imag(Z));
        tinds = find(IN==1);
        tP=P*NaN;
        [tP(tinds)] = GLC_deform(Z,W,P(tinds));
        
        
        
        %         %--------------------------------------------------------------
end