function [X Mdb] = QCONF_build_Xsol(V,F,tP,problem)
%++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
% takes a mesh (V,F) and a map of this mesh to the plane (tP), and
% produce a vector X with a per face affine map.
% usually this is used to convert a solution w.r.t. only positions
% (onlyU=1) to the solution w.r.t affine map representation (onlyU=0).




%++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
% prepare mesh (frame field, data structures, etc...)
Mdb = MESH_prepare_data(V,F);
M = Mdb.M; %number of faces

%++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
% construct initial frame field

Mdb = MESH_build_frame_field(Mdb,problem);

%++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
%the variables indecies. e.g. ia(k) gives the index of a_k in X
% Mdb = QCONF_build_index_maps_for_map_vars_CONES(Mdb);

Mdb = BD_build_index_maps(Mdb,problem);
iu1=Mdb.iu1;iu2=Mdb.iu2;
X=zeros(Mdb.NN,1);

%update u1,u2
X(iu1,1)=real(tP);
X(iu2,1)=imag(tP);

if(problem.onlyU == 0)
    ia=Mdb.ia;ib=Mdb.ib;ic=Mdb.ic;id=Mdb.id;
    it1=Mdb.it1;it2=Mdb.it2;
    
    
    
    %update the a,b,c,d,t1,t2 based on tP
    for k=1:M
        alpha_k = Mdb.a_(k,:)*(X(iu1(F(k,:)))+1i*X(iu2(F(k,:))));
        X(ia(k)) = real(alpha_k);
        X(ib(k)) = imag(alpha_k);
        %
        beta_k = Mdb.b_(k,:)*(X(iu1(F(k,:)))+1i*X(iu2(F(k,:))));
        X(ic(k)) = real(beta_k);
        X(id(k)) = imag(beta_k);
        %
        delta_k = Mdb.c_(k,:)*(X(iu1(F(k,:)))+1i*X(iu2(F(k,:))));
        X(it1(k)) = real(delta_k);
        X(it2(k)) = imag(delta_k);
    end
    
end