function [Apos Bpos] = QCONF_build_positional_constraints(Mdb,U00,U11)
%build positional constraints equalities.
%U00 source locations.
%U11 target locations

% if(size(U00,2) > 1) %not in complex form -> make complex
%     U00= U00(:,1)+1i*U00(:,2);
% end
% if(size(U11,2) > 1) %not in complex form -> make complex
%     U11= U11(:,1)+1i*U11(:,2);
% end


V=Mdb.V;
iu1=Mdb.iu1;
iu2=Mdb.iu2;
NN=Mdb.NN;


%find indices of U00 in mesh
U = V(:,1)+1i*V(:,2);
cinds=zeros(1,size(U00,1));%length(U00));
for k=1:size(U00,1)%length(U00)
    
    %find indices of U00 in mesh
    if(size(U00,2)==1) %if planar points (complex)
        [tv ti] = min((U-U00(k)).*conj(U-U00(k)));
        
    elseif(size(U00,2)==3) %3d points
        [tv ti] = min( sum ( (V - ones(size(V,1),1)*U00(k,:)).^2 , 2) );
    end
    
    cinds(k) = ti;
end


npos = length(cinds);
Bpos = zeros(2*npos,1);
ii=zeros(npos*2,1);
jj=zeros(npos*2,1);
ss=zeros(npos*2,1);
cnt=0;
 for k=1:npos
 % ttind=1:1;
 cnt=cnt+1;
 ii(cnt) = 2*k-1;
 jj(cnt) = iu1(cinds(k));
 ss(cnt) = 1;
 Bpos(cnt) = real(U11(k));
 %
 cnt=cnt+1;
 ii(cnt) = 2*k;
 jj(cnt) = iu2(cinds(k));
 ss(cnt) = 1;
 Bpos(cnt) = imag(U11(k));
 end
 
%construct positional matrix
Apos=sparse(ii,jj,ss,2*npos,NN);

