function [A B] = QCONF_calc_LS_ditortion_matrix(Z,TRI)
%Z,TRI described the vertices (complex numbers) and the faces of the
%initial mesh
%the function returns a matrices A,B such that if W are the new positions
%then abs(AW./BW) is the conformal distortion
%provides the complex distortion (its abs value is 0 iff similarity)

%%left this from previous function:
%create LS conformal map: start with constructing the matrix 
%we have a row for each face, and row for constraints
% A*z = [0 .... 0 | anchors].';

m=size(TRI,1); %num of triangles
n=length(Z); %num of vertices

A=sparse(m,n);
B=sparse(m,n); 
%first a row for each triangle, and create matrix for d/dz
for k=1:m
    progressbar(k,m,40);
    tri=TRI(k,:);
    i=tri(1); j=tri(2); l=tri(3);
    zi = Z(i);    zj = Z(j);    zl = Z(l);
    
    Det = (zj-zi)*conj(zl-zi) - conj(zj-zi)*(zl-zi);
    A(k,i) = zl-zj;
    A(k,j) = zi-zl;
    A(k,l) = zj-zi;
    A(k,:) = A(k,:)./Det;   
    
    B(k,i) = conj(zj-zl);
    B(k,j) = conj(zl-zi);
    B(k,l) = conj(zi-zj);
    B(k,:) = B(k,:)./Det;   
end

% %conformal distortion 
% dz = B*W; 
% dbz = A*W;
% [sval sind] = sort(abs(dbz./dz),1,'descend');
% % 
% % lsc_distor=abs(dbz./dz);
% % 
% % fig=figure;  set(fig,'color','white');
% % trisurf(TRI,real(W),imag(W),zeros(size(tZ)),lsc_distor);
% % colorbar
% % %triplot(TRI,real(W),imag(W));
% % axis equal;hold on
% % oursdis = abs(Af(2)/Af(1));
% % triplot(TRI(sind(sval>oursdis),:),real(W),imag(W),'r','linewidth',2);
% % cax=caxis;
% % % cax=[0 0.5];
% % caxis(cax);
% % % plot(sZ,'.','Markersize',20);plot(sW,'.k','Markersize',20);axis off;
% % plot3(real(sZ),imag(sZ),0.01+zeros(size(sZ)),'.r','Markersize',30);
% % plot3(real(sW),imag(sW),0.01+zeros(size(sZ)),'.k','Markersize',30);
% % axis off;
% % 
% % 
% % oursdis = abs(Af(2)/Af(1));
% % fig=figure
% % trisurf(TRI,real(tZ),imag(tZ),zeros(size(tZ)),oursdis);
% % caxis(cax);
% % % triplot(TRI,real(tZ),imag(tZ));
% % axis equal;hold on;axis off;set(fig,'color','white');
% % %plot(sZ,'.','Markersize',20);plot(sW,'.k','Markersize',20);
% % plot3(real(sZ),imag(sZ),0.01+zeros(size(sZ)),'.r','Markersize',30);
% % plot3(real(sW),imag(sW),0.01+zeros(size(sZ)),'.k','Markersize',30);
% % 
% % 
% 
% 

