function [A B] = QCONF_calc_LS_ditortion_matrix_meshes_NOT_ORTHOGONAL(V,FB1,FB2,TRI)
%V vertices, FB1,FB2 an orthonormal frame per face, and TRI is the
%faces list
%the function returns a matrices A,B such that if W are the new positions
%then abs(AW./BW) is the conformal distortion
%provides the complex distortion (its abs value is 0 iff similarity)

%%left this from previous function:
%create LS conformal map: start with constructing the matrix 
%we have a row for each face, and row for constraints
% A*z = [0 .... 0 | anchors].';

disp('calculate distortion matrix not orthogonal');

m=size(TRI,1); %num of triangles
n=size(V,1); %num of vertices

% A=sparse(m,n);
% B=sparse(m,n); 

ii = zeros(1,m*3);
jj = zeros(1,m*3);
ss_A = zeros(1,m*3);
ss_B = zeros(1,m*3);


%first a row for each triangle, and create matrix for d/dz
cnt=0;
for k=1:m
%     progressbar(k,m,40);
    tri=TRI(k,:);
    i=tri(1); j=tri(2); l=tri(3);
    %extract the local coordinates
    vi = V(i,:); vj=V(j,:); vl=V(l,:);
    
    zi=0; 
    zjl = [FB1(k,:)' FB2(k,:)']\[(vj-vi)' (vl-vi)'];
    zj = zjl(1,1) + 1i*zjl(2,1);
    zl = zjl(1,2) + 1i*zjl(2,2);
    
    
    %old: orthonormal frames
%     zj = dot(vj-vi,FB1(k,:))+1i*dot(vj-vi,FB2(k,:));
%     zl = dot(vl-vi,FB1(k,:))+1i*dot(vl-vi,FB2(k,:));


    %zi = Z(i);    zj = Z(j);    zl = Z(l);
    
    Det = (zj-zi)*conj(zl-zi) - conj(zj-zi)*(zl-zi);
    
    cc = 1./Det;
    %
    cnt=cnt+1;
    ii(cnt) = k;
    jj(cnt) = i;
    ss_A(cnt) = cc*(zl-zj);
    ss_B(cnt) = cc*conj(zj-zl);
    %
    cnt=cnt+1;
    ii(cnt) = k;
    jj(cnt) = j;
    ss_A(cnt) = cc*(zi-zl);
    ss_B(cnt) = cc*conj(zl-zi);
    %
    cnt=cnt+1;
    ii(cnt) = k;
    jj(cnt) = l;
    ss_A(cnt) = cc*(zj-zi);
    ss_B(cnt) = cc*conj(zi-zj);
    %
%     
%     A(k,i) = zl-zj;
%     A(k,j) = zi-zl;
%     A(k,l) = zj-zi;
%     A(k,:) = A(k,:)./Det;   
%     
%     B(k,i) = conj(zj-zl);
%     B(k,j) = conj(zl-zi);
%     B(k,l) = conj(zi-zj);
%     B(k,:) = B(k,:)./Det;   
end

A = sparse(ii,jj,ss_A,m,n);
B = sparse(ii,jj,ss_B,m,n);


% %conformal distortion 
% dz = B*W; 
% dbz = A*W;
% [sval sind] = sort(abs(dbz./dz),1,'descend');
% % 
% % lsc_distor=abs(dbz./dz);
% % 
% % fig=figure;  set(fig,'color','white');
% % trisurf(TRI,real(W),imag(W),zeros(size(tZ)),lsc_distor);
% % colorbar
% % %triplot(TRI,real(W),imag(W));
% % axis equal;hold on
% % oursdis = abs(Af(2)/Af(1));
% % triplot(TRI(sind(sval>oursdis),:),real(W),imag(W),'r','linewidth',2);
% % cax=caxis;
% % % cax=[0 0.5];
% % caxis(cax);
% % % plot(sZ,'.','Markersize',20);plot(sW,'.k','Markersize',20);axis off;
% % plot3(real(sZ),imag(sZ),0.01+zeros(size(sZ)),'.r','Markersize',30);
% % plot3(real(sW),imag(sW),0.01+zeros(size(sZ)),'.k','Markersize',30);
% % axis off;
% % 
% % 
% % oursdis = abs(Af(2)/Af(1));
% % fig=figure
% % trisurf(TRI,real(tZ),imag(tZ),zeros(size(tZ)),oursdis);
% % caxis(cax);
% % % triplot(TRI,real(tZ),imag(tZ));
% % axis equal;hold on;axis off;set(fig,'color','white');
% % %plot(sZ,'.','Markersize',20);plot(sW,'.k','Markersize',20);
% % plot3(real(sZ),imag(sZ),0.01+zeros(size(sZ)),'.r','Markersize',30);
% % plot3(real(sW),imag(sW),0.01+zeros(size(sZ)),'.k','Markersize',30);
% % 
% % 
% 
% 

