function [H,ii,jj,ss] = QCONF_construct_LSCM_quad_energy_only_U(Mdb) 


%++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
% load index maps and variables
iu1=Mdb.iu1;iu2=Mdb.iu2;
% ir=Mdb.ir;

% a_ = Mdb.a_;
b_ = Mdb.b_;


M=Mdb.M;
% N=Mdb.N;
NN=Mdb.NN;

F=Mdb.F;
F_area = Mdb.F_area;

%++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
% build the quadratic LSCM matrix directly

%++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
% LSCM energy
ii=zeros(12*M+NN,1);
jj=zeros(12*M+NN,1);
ss=zeros(12*M+NN,1);
cnt=0;
for j=1:M   
    bj = b_(j,:); 
    
    f = F(j,:);
    
    %
    btb = real(bj'*bj); 
    
    ii((cnt+1):(cnt+9)) = ([1 1 1]'*iu1(f))';
    jj((cnt+1):(cnt+9)) = [1 1 1]'*iu1(f);
    ss((cnt+1):(cnt+9)) = F_area(j)*btb(:);
    cnt=cnt+9;
    
    %
    btb = real((1i*bj)'*bj); 
    
    ii((cnt+1):(cnt+9)) = ([1 1 1]'*iu2(f))';
    jj((cnt+1):(cnt+9)) = [1 1 1]'*iu1(f);
    ss((cnt+1):(cnt+9)) = F_area(j)*btb(:);
    cnt=cnt+9;
    
    
    %
    btb = real(bj'*(1i*bj)); 
    
    ii((cnt+1):(cnt+9)) = ([1 1 1]'*iu1(f))';
    jj((cnt+1):(cnt+9)) = [1 1 1]'*iu2(f);
    ss((cnt+1):(cnt+9)) = F_area(j)*btb(:);
    cnt=cnt+9;
    
    %
    ibtib = real((1i*bj)'*(1i*bj));
    
    ii((cnt+1):(cnt+9)) = ([1 1 1]'*iu2(f))';
    jj((cnt+1):(cnt+9)) = [1 1 1]'*iu2(f);
    ss((cnt+1):(cnt+9)) = F_area(j)*ibtib(:);
    cnt=cnt+9;
    
    
end


% % % add small number along diagonal to cancel very small negative eigs
% ii((cnt+1):(cnt+NN)) = 1:NN;
% jj((cnt+1):(cnt+NN)) = 1:NN;
% ss((cnt+1):(cnt+NN)) = 10^-12;
% cnt = cnt+NN;

%truncate ii,jj,ss we didn't use
ii(cnt+1:end)=[];
jj(cnt+1:end)=[];
ss(cnt+1:end)=[];
H=sparse(ii,jj,ss,NN,NN);




