function QCONF_display_deformations(show_checkerboard,show_distortion,useimage, ...
    myfigs, AA, BB, ax,cax, tP, hCBcols, cols, D,S, TRI, Ximg, mapimg, siz, ...
    method, kk, psiz, pline)

myfontsize = 8;



Cdist=abs((AA*tP)./(BB*tP));
CCdist = abs( (abs(AA*tP)+abs(BB*tP))./(abs(AA*tP)-abs(BB*tP))   );
Cvol = (abs(AA*tP)+abs(BB*tP)).*(abs(BB*tP)-abs(AA*tP)) ;



tind = find(Cdist>1);

tind2 = find(CCdist>50); %close to degenerating

tind3 = find(CCdist>25); %close to degenerating


%color flipped triangles in:
flipped_color = [130 19 80]./255;


txt = '*******************************************************';
disp(txt);
txt = [method ': CD: ' num2str(max(CCdist)) ...
    ' <-> ' num2str(min(CCdist)) ... 
    ' | mean CD:' num2str(mean(CCdist))...
                    ' | AD: ' num2str(max(Cvol)) ...
                    ' <-> ' num2str(min(Cvol)) ];
%  ' | maxAD/minAD :' num2str(max(Cvol) + 1/min(Cvol)) ...
%    ' | maxAD/minAD :' num2str(max(Cvol)/min(Cvol))];
%   ' | std CD:' num2str(std(CCdist))...% ];
disp(txt);

figcnt=0;
if(length(myfigs)>1)
incol = [0 0.8 0];%   [255 240 130]./255;%[.49 1 .63]
else
incol = [255 240 130]./255; %source color
end
incolS = [0 0 0.8];%   [255 240 130]./255;%[.49 1 .63]
if(show_checkerboard)
    figcnt=figcnt+1;
    f1=myfigs(kk,figcnt);
    figure(f1);clf(f1);hold on;
    %QCONF_plot2Dmesh_no_edges(f1,ax,tP,TRI,hCBcols,cols);hold on;%;colorbar
    QCONF_plot2Dmesh(f1,ax,tP,TRI,hCBcols,cols,'black',1);hold on;%;colorbar
    axis equal;axis off; set(f1,'color','white');
    
    caxis(cax);title(txt,'FontSize',myfontsize);
    
    if(~isempty(S))
        for kkk=1:5
        plot(S(:,1),S(:,2),'o','LineWidth',pline,'MarkerEdgeColor','k','MarkerFaceColor',incolS,'MarkerSize',psiz);
        end
        
        
    else
        for kkk=1:6
        plot(D(:,1),D(:,2),'o','LineWidth',pline,'MarkerEdgeColor','k','MarkerFaceColor',incol,'MarkerSize',psiz);
        end
    end
    
    axis off;
    
    %                     plot(D(:,1),D(:,2),'.k','markersize',15); plot(D(:,1),D(:,2),'om','linewidth',2,'markersize',7); %color the chosen one                      colormap(cols);
    %                     plot(D(:,1),D(:,2),'.k','markersize',15); plot(D(:,1),D(:,2),'om','linewidth',2,'markersize',7); %color the chosen one                      colormap(cols);
end

if(show_distortion)
    figcnt=figcnt+1;
    f1=myfigs(kk,figcnt);
    figure(f1);clf(f1);hold on;
    set(f1,'color','white');
    %QCONF_plot2Dmesh_no_edges(f1,ax,tP,TRI,Cdist,cols);drawnow;colorbar;hold on;
    QCONF_plot2Dmesh(f1,ax,tP,TRI,CCdist,cols,'black',1);drawnow;hold on;
    %colorbar;hold on;
    axis equal;axis off; set(f1,'color','white');
    patch(real(tP(TRI(tind,:)))',imag(tP(TRI(tind,:)))',ones(3,length(tind)),'LineWidth',1,'EdgeColor',[229 225 46]./255,'FaceColor',flipped_color,'FaceAlpha',0.85);
    caxis(cax);
    
    
          patch(real(tP(TRI(tind3,:)))',imag(tP(TRI(tind3,:)))',ones(3,length(tind3)),'LineWidth',1,'EdgeColor',[0 1 0]);

        patch(real(tP(TRI(tind2,:)))',imag(tP(TRI(tind2,:)))',ones(3,length(tind2)),'LineWidth',1,'EdgeColor',[0 0 1]);

    
%     txt
    title(txt,'FontSize',myfontsize,'Interpreter', 'none');
%     psiz=15;%was 7
    if(~isempty(S))
        for kkk=1:5
            plot(S(:,1),S(:,2),'o','LineWidth',pline,'MarkerEdgeColor','k','MarkerFaceColor',incolS,'MarkerSize',psiz);
        end
        
        
    else
        for kkk=1:5
            plot(D(:,1),D(:,2),'o','LineWidth',pline,'MarkerEdgeColor','k','MarkerFaceColor',incol,'MarkerSize',psiz);
        end
    end
    axis off;
    %                     plot(D(:,1),D(:,2),'.k','markersize',15); plot(D(:,1),D(:,2),'om','linewidth',2,'markersize',7); %color the chosen one                      colormap(cols);
    %                     plot(D(:,1),D(:,2),'.k','markersize',15); plot(D(:,1),D(:,2),'om','linewidth',2,'markersize',7); %color the chosen one                      colormap(cols);
end

if(useimage)
    figcnt=figcnt+1;
    f1=myfigs(kk,figcnt);
    figure(f1);clf(f1); axis equal;hold on;axis off;
    set(gcf,'renderer','zbuffer');%to prevent matlab from crashing!!
    QCONF_texturemap(f1,ax,tP,siz,Ximg);
    %                     plot(D(:,1),D(:,2),'.k','markersize',15);
    title(txt,'FontSize',myfontsize);
    for kkk=1:5
        plot(D(:,1),D(:,2),'o','LineWidth',pline,'MarkerEdgeColor','k','MarkerFaceColor',incol,'MarkerSize',psiz);
    end
    
    
end
