function [CCdist] = QCONF_display_param_result(V,F,U,cax,edgecolor,alg,myfig)
%++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
% Display parametrization U of the mesh (V,F).
% cax is the color-axis for the conformal distortion.
% edgecolor = 'none' or 'black' the color of the flatten mesh's edges.
% alg is a string (usually name of algorithm used) to be displayed.
% myfig is the ID of the figure we want to draw the parametrization.
% the textured mesh is also saved in vtk file

%++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
% if no figure ID is specified
if(~exist('myfig'))
    myfig=1;
end


%++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
% my color scheme for distortion
CBcols = [0.85 0.85 0.85];%[0.9 0.9 0.9];
t=(1:64) /64;t=t';
cols = (1-t)*CBcols + t*[0.7 0 0];
cols(cols>1) =1;


%++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
% calculate the true distortion of each face
Mdb =MESH_prepare_data(V,F);
%choose a frame per face
[FB1 FB2 temp1 temp2 temp3] = PARAM_calc_local_frames_in_faces(V,F,Mdb);
%calculate the Dz and Dbar{z} matrices
% [AA BB] = QCONF_calc_LS_ditortion_matrix_meshes(V,FB1,FB2,F);
[AA BB] = QCONF_calc_LS_ditortion_matrix_meshes_NOT_ORTHOGONAL(V,FB1,FB2,F);

%plot conformal distortion
if(size(U,2)>1)
    U = U(:,1)+1i*U(:,2);
end
cU = U;
U1=real(cU); U2=imag(cU);

% %normalize mesh so that mean area distortion is 1
%          [area2 F_area2] = CORR_calculate_area(F,[U1 U2 U1*0]);
%          [area F_area] = CORR_calculate_area(F,V);
%          Adist = F_area2 ./ F_area;
%          cU = cU./sqrt(median(Adist));

Cdist=abs((AA*cU)./(BB*cU)); %dilation
CCdist = abs( (abs(AA*cU)+abs(BB*cU))./(abs(AA*cU)-abs(BB*cU))   ); %conformal distortion
SV = [ (abs(BB*cU)+abs(AA*cU)) abs(abs(BB*cU)-abs(AA*cU))];
max(SV(:,1));
min(SV(:,2));

tind = find(Cdist>(1-10^-8)); %find degenerate faces

tind2 = find(CCdist>50); %find very close to degenerating faces

tind3 = find(CCdist>25); %find close to degenerating faces

%color flipped triangles in:
flipped_color = [130 19 80]./255;



%++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
% plot conformal distortion


f1=figure(myfig);clf(f1);hold on;
set(f1,'color','white');
jetcols=colormap;
QCONF_plot2Dmesh(f1,[],cU,F,CCdist,cols,edgecolor,0.8);
hold on;
%draw boundary
Mdb =MESH_prepare_data(V,F);
binds = CORR_locate_boundary_edges(Mdb.V2F,Mdb.E2V);
for k=1:length(binds)
    plot( [cU(Mdb.E2V(binds(k),1)) cU(Mdb.E2V(binds(k),2))],'-k'  );
end

axis equal;axis off; set(f1,'color','white');

%highlight ditorted faces
patch(real(cU(F(tind3,:)))',imag(cU(F(tind3,:)))',ones(3,length(tind3)),'LineWidth',1,'EdgeColor',[0 1 0]);%
patch(real(cU(F(tind2,:)))',imag(cU(F(tind2,:)))',ones(3,length(tind2)),'LineWidth',1,'EdgeColor',[0 0 1]);
patch(real(cU(F(tind,:)))',imag(cU(F(tind,:)))',ones(3,length(tind)),'LineWidth',1,'EdgeColor',[229 225 46]./255,'FaceColor',flipped_color,'FaceAlpha',0.85);


colorbar;
caxis(cax);
txt = [alg ' -> '];
txt= [txt 'max CD: ' num2str(max(CCdist))];
txt = [txt '  mean CD: ' num2str(mean(CCdist))];
txt= [txt ' max CDil: ' num2str(max(Cdist))];
title(txt);



%++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
% output vtk file
maxx = max(U1); minx=min(U1); maxy = max(U2); miny=min(U2);
ts = max([maxx-minx maxy-miny]);
U1=(U1-minx)/ts; U1=U1*2-1;
U2=(U2-miny)/ts; U2=U2*2-1;
% U1=U1*20;
% U2=U2*20;

%save vtk file with textured mesh
TEETH_output_vtk_texture('mesh_uv.vtk',V,F,[U1 U2]);






