function [H ii jj ss f] = QCONF_l2_ARAP_energy(Mdb)
%the energy sum_j |f_j|( |alpha_j-1|^2 +|beta_j|^2 )
%for the quadratic form  1/2*x'*H*x + f'*x. %% x'Hx + f'x


%build the ARAP energy
M=Mdb.M;
NN=Mdb.NN;

tt = 1:M;
ii(tt) = Mdb.ic;
jj(tt) = Mdb.ic;
ss(tt) = 2*Mdb.F_area;
%
ii(tt+M) = Mdb.id;
jj(tt+M) = Mdb.id;
ss(tt+M) = 2*Mdb.F_area;
%
ii(tt+2*M) = Mdb.ia;
jj(tt+2*M) = Mdb.ia;
ss(tt+2*M) = 2*Mdb.F_area;
%
ii(tt+3*M) = Mdb.ib;
jj(tt+3*M) = Mdb.ib;
ss(tt+3*M) = 2*Mdb.F_area;
%
H=sparse(ii,jj,ss,Mdb.NN,Mdb.NN);

f=zeros(1,NN);
f(Mdb.ia)=-2*Mdb.F_area;