function [tV X Mdb res] = QCONF_map(V,F,problem,Xref, Mdbref)
%++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
% map a mesh (V,F) with bounded distortion.
% problem is a structure with parameters
% Xref,Mdbref give an optional initial guess

if (size(V,2)<3)
    V = [V 0*V(:,1)];
end

%++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
% build the convex program
%
% BD_build_convex_program takes a mesh and an input problem data
% and construct:
% 1) functional: X'*HH.HH*X + ff*X, where X is a column vector of the
% unknowns. Mdb contains indices arrays that relate each place in X to the
% unknowns of the problem. For example, if the unknowns are two coorinates 
% (u1(i),u2(i)) per vertex i, then u1(:) = X(Mdb.iu1), 
% and u2(:) = X(Mdb.u2).
% 2) inequality and equality constraints: Aleq*X <= Bleq , and Aeq*X = Beq.
% 3) cone contraints (if applicable). 

[ff HH Aleq Bleq Aeq Beq cones Mdb] = BD_build_convex_program(V,F,problem);
M = Mdb.M; %number of faces
N = Mdb.N; % number of vertices
FB1=Mdb.FB1;FB2=Mdb.FB2; %alpha frame per face
oFB1=Mdb.oFB1;oFB2=Mdb.oFB2; %alpha frame per face

NF=Mdb.NF; %normal per face



%++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
% optimize with Matlab / Mosek
clear prob;

% set the problem
prob.qosubi= HH.ii;
prob.qosubj= HH.jj;
prob.qoval = HH.ss;
prob.q=HH.HH;
prob.c = ff;
prob.a = [Aleq ; Aeq];
prob.blc = [-inf*ones(size(Bleq)) ; Beq];
prob.buc = [Bleq ;Beq];
prob.cones = cones;
prob.Aeq = Aeq; %for matlab's quadprog
prob.Beq = Beq;
prob.Aleq = Aleq; %for matlab's quadprog
prob.Bleq = Bleq;

%start measuring optimization time
tic

disp('------------------------------------------------');
disp('Start optimizing...');
disp('------------------------------------------------');
%for terminateing after iter of feasibile solutions
found_feasible = 0;
for kk=1:problem.iter_max
    
    if(isempty(Xref))
        
        switch problem.solver{1}
            case 'QP_Matlab'
                if(problem.quiet==1)
                    %options = optimset('Display','final','Algorithm','interior-point-convex','MaxIter',20);%,'param2',value2)
%                     options = optimset('Display','off','Algorithm','interior-point-convex','MaxIter',100);%,'param2',value2)
                    
                    mytol = 10^-12;%min([10^-12*problem.global_scale 10^-8]);
                    options = optimset('Display','off','Algorithm','interior-point-convex','MaxIter',100,'TolFun',mytol,'TolCon',mytol,'TolX',mytol);

                    
                else
                    %options = optimset('Display','iter','Algorithm','interior-point-convex','MaxIter',20);%,'param2',value2)
%                     options = optimset('Display','iter','Algorithm','interior-point-convex','MaxIter',100);%,'param2',value2)
                 mytol = 10^-12;%min([10^-12*problem.global_scale 10^-8]);
                 options = optimset('Display','iter','Algorithm','interior-point-convex','MaxIter',100,'TolFun',mytol,'TolCon',mytol,'TolX',mytol);

                end
                if(~isempty(ff))
                    [X,fval,exitflag,res] = quadprog(prob.q,ff,...
                        prob.Aleq,prob.Bleq,prob.Aeq,prob.Beq,[],[],[],options);
                    disp(['Functional value: ' num2str(fval) '      exit flag: ' num2str(exitflag)]);
                else
                    [X,fval,exitflag,res] = quadprog(prob.q,[],...
                        prob.Aleq,prob.Bleq,prob.Aeq,prob.Beq,[],[],[],options);
                    disp(['Functional value: ' num2str(fval) '      exit flag: ' num2str(exitflag)]);
                end
                
                %set solution report compatible to Mosek
                if(exitflag==1)
                    res.sol.itr.solsta = 'OPTIMAL';
                    if(found_feasible == problem.iter-1)
                        break;
                    else
                        found_feasible=found_feasible+1;
                    end
                else
                    res.sol.itr.solsta = 'NOT_OPTIMAL';
                end
                
                
            case 'Mosek'
                if(problem.quiet==1)
                    [r,res ]= mosekopt ('minimize echo(0)', prob );
                    %                  disp(res.rcodestr);
                    if(strcmp(res.rcodestr,'MSK_RES_ERR_BASIS_SINGULAR')==1)
                        X=[];
                        res.sol.itr.solsta = 'FAILED';
                        tV=[];
                        return;
                    end
                    
                    
                    disp(res.sol.itr.prosta);
                    disp(res.sol.itr.solsta);
                    X=res.sol.itr.xx;
                    
                else
                    [r,res ]= mosekopt ('minimize', prob );
                    % [res] = mskqpopt (prob.q,prob.c,prob.a,prob.blc ,prob.buc);% ,blx ,bux );
                    X=res.sol.itr.xx;
                end
                
            otherwise
                error('Not implemented solver.');
                
        end
        
    else
        X=Xref;
        Mdb=Mdbref;
        FB1=Mdb.FB1;FB2=Mdb.FB2;
        oFB1=Mdb.oFB1;oFB2=Mdb.oFB2; %alpha frame per face

        Xref=[];
    end
    
    
    %++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    %  update frames    
    if(problem.onlyU == 0) %in case we use affine map per face as free variables
        ia=Mdb.ia;ib=Mdb.ib;
        ic=Mdb.ic;id=Mdb.id;
    else %in case we use only positions as free variables (default)
        iu1=Mdb.iu1; iu2=Mdb.iu2;
    end
    
    %rotate the alpha frames and the beta frames
    for k=1:M
        if(problem.onlyU == 0)
            temp = X(ia(k))+1i*X(ib(k));%alpha
            
            temp_beta = X(ic(k))+1i*X(id(k));%beta
            
        else
            %get alpha from U coordinates
            temp = Mdb.a_(k,:)*(X(iu1(F(k,:)))+1i*X(iu2(F(k,:))));
            
            %get beta from U coordinates
            temp_beta = Mdb.b_(k,:)*(X(iu1(F(k,:)))+1i*X(iu2(F(k,:))));
            
        end
        temp = temp/abs(temp); %extract the rotation the frame undergo
        temp_beta = temp_beta/abs(temp_beta); %extract the rotation the frame undergo
        
        
        %rotate the local alpha frame by -rotation
        temp=conj(temp);
        FB1(k,:) = FB1(k,:)*real(temp) + ...
            (cross(NF(k,:),FB1(k,:)))*imag(temp);
        FB2(k,:) = FB2(k,:)*real(temp) + ...
            (cross(NF(k,:),FB2(k,:)))*imag(temp);
        
        %rotate the local beta frame by -rotation
%         temp_beta=conj(temp_beta);
        oFB1(k,:) = oFB1(k,:)*real(temp_beta) + ...
            (cross(NF(k,:),oFB1(k,:)))*imag(temp_beta);
        oFB2(k,:) = oFB2(k,:)*real(temp_beta) + ...
            (cross(NF(k,:),oFB2(k,:)))*imag(temp_beta);
        
        
        
    end
    %update the alpha frames
    Mdb.FB1=FB1;     Mdb.FB2=FB2;
    %update the beta frames
    Mdb.oFB1=oFB1;    Mdb.oFB2=oFB2;
    
    
    %update the necessary constraints and/or functional

        problem.Mdbref = Mdb;
        problem.frame_initialization_method='previously_processed';
        [ff HH Aleq Bleq Aeq Beq cones Mdb] = BD_build_convex_program(V,F,problem);

        clear prob;
        prob.qosubi= HH.ii;
        prob.qosubj= HH.jj;
        prob.qoval = HH.ss;
        prob.q=HH.HH;
        prob.c = ff;
        prob.a = [Aleq ; Aeq];
        prob.blc = [-inf*ones(size(Bleq)) ; Beq];
        prob.buc = [Bleq ;Beq];
        prob.cones = cones;
        prob.Aeq = Aeq; %for matlab's quadprog
        prob.Beq = Beq;
        prob.Aleq = Aleq; %for matlab's quadprog
        prob.Bleq = Bleq;
    
end



    disp('------------------------------------------------');    
    disp(['Optimization time: ' num2str(toc) ' seconds']);    
    disp('------------------------------------------------');
    

if(strcmp(res.sol.itr.solsta,'OPTIMAL'))
    disp(['Functional value at argmin: ' num2str(fval)]);    
    disp('------------------------------------------------');
    disp('->  Algorithm converged to a feasible solution!');
    
else
    disp('------------------------------------------------');
    disp('-> Algorithm did *NOT* converge to a feasible solution...');
end
    disp('------------------------------------------------');
    disp('-Done-------------------------------------------');
    disp('------------------------------------------------');

if(problem.iter_max<1)
    tV=[];X=[];
else
    tV = [X(Mdb.iu1) X(Mdb.iu2)];
end

