function [] = TEETH_output_vtk_texture_with_bounding_box(filename,V1,F1,UV,BB)
source_id = 355;
ofid = fopen(filename,'w');
fprintf(ofid, '# vtk DataFile Version 3.0\n');
fprintf(ofid,'vtk output\n');
fprintf(ofid,'ASCII\n');
fprintf(ofid,'DATASET POLYDATA\n');
fprintf(ofid,'POINTS %d float\n', size(V1,1));
fprintf(ofid,'%g %g %g\n', V1');
fprintf(ofid,'POLYGONS %d %d\n', size(F1,1), 4*size(F1,1))
fprintf(ofid,'3 %d %d %d\n', F1'-1);
fprintf(ofid,'\n');
%texture coordinates

%make the transfoormation taking the bounding box to [0,1]^2
UV(:,1) = (UV(:,1)-BB(1))/(BB(2)-BB(1));
UV(:,2) = (UV(:,2)-BB(3))/(BB(4)-BB(3));

figure
plot(UV(:,1),UV(:,2),'.');
axis([0 1 0 1]);
axis equal;

% UV(:,1) = 0.5*(UV(:,1)+1);
% UV(:,2) = 0.5*(UV(:,2)+1);

% %for debug
% figure;
% plot(UV(:,1),UV(:,2),'.');
% 
% % %old: might have caused problems
% %move textures to [0,1]^2
% UV(:,1) = UV(:,1) - min(UV(:,1));
% UV(:,2) = UV(:,2) - min(UV(:,2));
% UV(:,1) = UV(:,1)./max(UV(:,1));
% UV(:,2) = UV(:,2)./max(UV(:,2));

fprintf(ofid,'POINT_DATA %d\n', size(V1,1));

fprintf(ofid,'TEXTURE_COORDINATES TCoords 2 float\n');
% fprintf(ofid,'TEXTURE_COORDINATES texturecoords 2 float\n');
fprintf(ofid,'%g %g\n', UV');

% 
% 
% 
% fprintf(ofid,'SCALARS distance_from float\n');
% fprintf(ofid,'LOOKUP_TABLE default\n');
% fprintf(ofid,'%g\n',vals);% W(:,end-40));

fclose(ofid);