%--------------------------------------------------------------------------
%--------------------------------------------------------------------------
% Bounded Distortion Plane Deformation
%
%
% August 2012, Y.Lipman
%--------------------------------------------------------------------------

%--------------------------------------------------------------------------
% Usage:
% mark points: left click
% select point to move: right click, 
%    >   then set destination location for chosen point: left click
% apply deformation: right click somewhere LEFT to the axis
% exit: right click somewhere RIGHT to the axis

%--------------------------------------------------------------------------
clear all;
close all;

%--------------------------------------------------------------------------
% parameters.

%rename the base path to the root directory of the code
base_path = 'C:\Users\ylipman\Dropbox\Projects_working\BoundedDistortion_Distribute_V1.1';

% conformal distortion bound
C_=1.5;

%number of successful (=feasible) iterations
iter=3;

% parameters for the grid creation
square = [0 2 0 0.5]; % the axis of the grid
dt = 0.125;%2*0.0625;%125;%125;%grid resolution
ax=[-0.5 2.5 -1 2];
cax = [1 3]; %the conformal distortion COLOR axis (cax(1) is grey, cax(2) is red)


% Uncomment the desired methods

% %Least-Squares Conformal Map and its bounded distortion
methods = {'LSCM','init_BD_LSCM'};

% %As-Rigid-As-Possible and its bounded distortion map
% %the ARAP code was borrowed from IGL lab (see credit inside) 
% %and is based on papers by Alexa and Sorkine 08, and Igarashi et al. 05.
% methods = {'takeo-arap-iterative','init_BD_l2_ARAP','sorkine-arap-iterative','init_BD_l2_ARAP'};

%--------------------------------------------------------------------------
% unused parameters (in this version) - PLEASE IGNORE...

useimage=0; %deform an image? 0:no 1:yes - possible only with grid
image_name = 'warped.jpg';%'checkerboard.jpg';%;%name of image to use
mesh_type = 'grid'; %'grid' ; 'mesh'
mesh_name = 'birdy.off';%'elephant01.off';%'mydino.off';%'woody.off';%'man.off';%;alligator2
reflect=0;
pad=25;
show_checkerboard = 0; %whether to show deformation on checkerboard 0:no 1:yes
show_distortion =1;%whether to show conformal distortion  0:no 1:yes
fix_boundary = 0; %the width (this #*dt) of the boundary of the grid to fix; 0 - no boundary
poly_deform = 0; %deform using the polyline
we=1000; %weights for lscm
we_arap=1000; %weights for arap (both FPI and LSCM)
psiz = 7;% the size of the points to draw (anchors)
pline = 2; %width of points' boundary line


%--------------------------------------------------------------------------
% setting path
path(path,[base_path '\toolbox_graph\']); path(path,[base_path '\toolbox_graph\toolbox_graph\']); path(path,[base_path '\toolbox_graph\toolbox_graph\toolbox\']);
path(path,[base_path '\CORR_functions\']);
path(path,[base_path '\ARAP_IGL\']);
imagepath=[base_path '\images\'];
meshpath=[base_path '\meshes\'];
controlpnts_path = [base_path '\saved_control_points\'] ;



%--------------------------------------------------------------------------
% set colors
colormap('default'); %we will use this color map to color conformal distortion
colormap(gray);
cols1=colormap; close all;
CBcols = [0.9 0.9 0.9];
t=(1:64) /64;t=t';
cols = (1-t)*CBcols + t*[0.7 0 0];
cols(cols>1) =1;


%--------------------------------------------------------------------------
% load mesh or setup grid

switch mesh_type
    case 'grid'
        
        [X Y] = meshgrid(square(1):dt:square(2),square(3):dt:square(4));
        % oX=X;oY=Y;siz=size(oX);%for texture mapping remember the original matrix lattices
        siz=size(X);
        X=X(:); Y=Y(:); V=[X Y];
        TRI = delaunay(X,Y);
        
    case 'mesh'
        [V TRI] = read_off([meshpath mesh_name]);V=V'; TRI=TRI';
        
        %reflect
        if(reflect)
            V(:,2)=mean(V(:,2))*ones(size(V,1),1) -V(:,2);
        end
        
        %         pad=100;
        ax = [min(V(:,1))-pad pad+max(V(:,1)) -pad+min(V(:,2)) pad+max(V(:,2))];
        siz=[];
        
end

%set up mesh and complex derivative operators
X=V(:,1); Y=V(:,2);
P=X+1i*Y;
[AA BB] = QCONF_calc_LS_ditortion_matrix(P,TRI); %calculate matrices to compute
Ximg=[];
mapimg=[];



%--------------------------------------------------------------------------
% load image, if relevant
if(useimage==1)
    [Ximg, mapimg] = imread([imagepath image_name],'jpg');
    %     %flip image
    %     for kk=1:3
    %         Ximg(:,:,kk) = flipud(Ximg(:,:,kk));
    %     end
else
    Ximg=[];
    mapimg=[];
end


%--------------------------------------------------------------------------
% start editing session
refind = zeros(1,length(methods)); %indicator whether method kk has a reference data for next iteration

%PLOT initial mesh (possibly with texture)
fig=figure;axis equal;axis off;
if (useimage)
    image(square(1:2),square([4 3]),Ximg);axis equal; axis(ax);hold on;
    set(gca,'YDir','normal');
    colormap(mapimg);
else
    QCONF_plot2Dmesh(fig,ax,P,TRI,CBcols,cols1,'black',1);hold on;
end

%create figures for all the methods
numofcopies = useimage + show_checkerboard + show_distortion ;%number of figures shown for ech method
myfigs = zeros(length(methods),numofcopies);
for kk=1:length(methods)
    for jj=1:numofcopies
        myfigs(kk,jj)=figure;
    end
end
figure(fig); %return focus to main image

mode =  'src' ; %the mode is either 'src' or 'dest' for marking source or destanation points
endthis = 0;
S = []; sind=0;
D =[]; dind =0;
oldtrans_num=0;
oldtrans = cell(5,1);

while(~endthis)
    
    [x y but]=ginput(1);
    if(but == 1) %left button pressed: choose source points S
        if( x>ax(1) && x<ax(2) )%inside the axis
            sind=sind+1;
            %find nearest point on mesh
            [tval tind] = min(  (P - x-1i*y).*conj(P - x-1i*y) );
            x = real(P(tind));
            y = imag(P(tind));
            S(sind,:) = [x y];
            D=S; %mark D as destination
            plot(S(:,1),S(:,2),'.k','markersize',15);%,'o','linewidth',3);
            % scatter(S(:,1),S(:,2),15,[0 0 0],'filled');
        else %reset the deformation
            D=S; %bring the destination points back to source
            figure(fig);
            if (useimage)
                %QCONF_texturemap(fig,ax,P,siz,Ximg,mapimg); hold on;
                image(square(1:2),square([4 3]),Ximg);axis equal; axis(ax);hold on;
                set(gca,'YDir','normal');
                colormap(mapimg);
            else
                %                 QCONF_plot2Dmesh_no_edges(fig,ax,P,TRI,int32(CBcols),cols);hold on;
                QCONF_plot2Dmesh(fig,ax,P,TRI,CBcols,cols1,[0 0 0],1);hold on;
                
                %                 QCONF_plot2Dmesh_no_edges(fig,ax,htP,hTRI,int32(hCBcols),cols);hold on;%;colorbar
            end
            plot(S(:,1),S(:,2),'.g','markersize',15);%,'og','linewidth',3);
            plot(D(:,1),D(:,2),'.k','markersize',15);%,'o','linewidth',3);
        end
        
        
    elseif (but ==3) %right button pressed
        
        
        
        if (x>ax(2)) %and if pressed to the right of the axis
            endthis=1;
        elseif (x<ax(1)) %if to the left then perform TPS deformation
            
            W = (D(:,1) + 1i*D(:,2)); %the conj is because the image axis reverse orientation: positive Y-axis is down
            Z = (S(:,1) + 1i*S(:,2));%the conj is because the image axis reverse orientation: positive Y-axis is down
            
            %--------------------------------------------------------------
            %--------------------------------------------------------------
            %--------------------------------------------------------------
            %--------------------------------------------------------------
            % perform the deformation!
            for kk=1:length(methods)
                method = methods{kk};
                P = X(:)+1i*Y(:);%
                
                %insert grid data into mdb in case boundary conditions are
                %required
                Mdbref{kk}.fix_boundary=fix_boundary;
                Mdbref{kk}.dt=dt;
                
                if(length(method)>=5 && strcmp(method(1:5),'init_'))%make sure BD_l2_ARAP is AFTER what you want to improve in 'methods"
                    
                    tic
                    [tP Xref{kk} Mdbref{kk}] = QCONF_apply_image_deformation(Z,W,P,method,TRI,AA, ...
                        [],[],tP_ref,poly_deform, C_, iter);
                    toc
                    %NOTE: we take the reference solution from previous
                    %method (should be some ARAP technique).
                    
                elseif(refind(kk)==1 && strcmp(method(1:3),'BD_'))
                    [tP Xref{kk} Mdbref{kk}] = QCONF_apply_image_deformation(Z,W,P,method,TRI,AA,Xref{kk},Mdbref{kk},[],poly_deform, C_, iter);
                elseif (strcmp(method(1:3),'BD_'))
                    [tP Xref{kk} Mdbref{kk}] = QCONF_apply_image_deformation(Z,W,P,method,TRI,AA,[],Mdbref{kk},[],poly_deform, C_, iter);
                    refind(kk)=1;
                else
                    [tP temp1 temp2] = QCONF_apply_image_deformation(Z,W,P,method,TRI,AA,[],Mdbref{kk},[],poly_deform, C_, iter);
                    %build Xref out of this result with FB1,FB2 standard
                    if(size(V,2)==3)
                        tV=V;
                    else
                        tV=[V 0*V(:,1)];
                    end
                    tP_ref=tP;
                    %[Xref{kk} Mdbref{kk}] = QCONF_build_Xsol(tV,TRI,tP);
                end
                
                
                htP = tP;
                QCONF_display_deformations(show_checkerboard,show_distortion,useimage, myfigs, ...
                    AA,BB, ax,cax, tP, CBcols, cols, D,[], TRI, ...
                    Ximg, mapimg, siz, method, kk, psiz, pline);
                
                
            end
            %return focus to working figure
            figure(fig)
            
            
            %--------------------------------------------------------------
            
            figure(fig);
        elseif( x<ax(2) && x>ax(1))
            %right button pressed: choose dest points
            plot(S(:,1),S(:,2),'.g','markersize',15);%,'og','linewidth',3);
            plot(D(:,1),D(:,2),'.k','markersize',15);%,'o','linewidth',3);
            figure(fig)
            
            tdist = sum((D - ones(sind,1)*[x y]).^2,2);
            [tval tind] = min(tdist);
            plot(D(tind,1),D(tind,2),'or','linewidth',3); %color the chosen one
            [xx yy but]=ginput(1); %get the destination point
            D(tind,:) = [xx yy];
            plot(D(tind,1),D(tind,2),'or','linewidth',3); %color the dest
            
            figure(fig);clf;
            if (useimage)
                image(square(1:2),square([4 3]),Ximg);axis equal; axis(ax);hold on;
                set(gca,'YDir','normal');
                colormap(mapimg);
            else
                QCONF_plot2Dmesh(fig,ax,P,TRI,CBcols,cols1,[0 0 0],1);hold on;
                
            end
            plot(S(:,1),S(:,2),'.g','markersize',15);%,'og','linewidth',3);
            plot(D(:,1),D(:,2),'.k','markersize',15);%,'o','linewidth',3);
            figure(fig)
            
            
        end
        
        %%% Proccess KEYS: save and load configurations
    elseif (char(but) == 's') %save the source and target cages
        %start writing after last file
        mydir = dir(controlpnts_path);
        [filenames] = QCONF_find_all_files_in_dir_of_type(mydir,'pnts');
        cnt_poly=0;
        if(isempty(filenames)) %then should start with cnt_poly=0
        else
            for kk=1:length(filenames)
                temp=strtok(filenames(kk).name,'.');
                temp = temp(6:end);
                if (cnt_poly< str2num(temp))
                    cnt_poly = str2num(temp);
                end
                
            end
        end
        cnt_poly=cnt_poly+1;
        save([controlpnts_path 'pnts_'  num2str(cnt_poly) ]);%, 'D' , 'S');
        disp('-> Done saving pnts+data!')
        
    end
    
    
end