%--------------------------------------------------------------------------
%--------------------------------------------------------------------------
% Bounded Distortion LSCM Parameterization
%
% August 2012, Y.Lipman
%--------------------------------------------------------------------------
%--------------------------------------------------------------------------

close all;
clear all;
disp('------------------------------------------------');
restoredefaultpath;

%--------------------------------------------------------------------------
% parameters.

problem.C_ = 2; %the conformal distortion bound, default=5

quiet = 1; %1-minimal data on screen. 0-alot of data on screen.
problem.iter = 2; %number of feasible iteration until stop (usually 2-3).
                  %If 0, always perfor iter_max iterations.
                  %
                  %NOTE: energy is guaranteed to monotonically decrease...
                  %      so more interations => lower energy level
                  
                  
problem.iter_max = 10; %maximal number of iterations

problem.onlyU=1; % (do not change) 1:use only positional variables ; 0:use the (redundant) affine map per face variables
figcnt=1; % (do not change)

%the root path of the code
base_path = 'C:\Users\ylipman\Dropbox\Projects_working\BoundedDistortion_Distribute_V1.1';
%MOSEK_path = 'C:\Program Files\Mosek\6\toolbox\r2009b\';

% Meshes, uncomment one:
 mesh_name='foot_decim.obj'; %CD=5; |V|=497
% mesh_name='fandisk_decim.obj'; %CD=5; |V|=2271
% mesh_name='tooth.obj';  %CD=5; |V|=8600
% mesh_name='hand.obj'; %CD=5 ; |V|=1056
% mesh_name='isis_decim.obj'; %CD=6 ; |V|=1731
% mesh_name='bunny_decim.obj'; %CD=2; |V|=911
% mesh_name='dino_decim.obj'; %CD=15; |V|=775

% %for the frames example:
% mesh_name='cow_low.obj';% CD=3; iter=10;


%--------------------------------------------------------------------------
% set path
path(path,[base_path '\toolbox_graph\']); path(path,[base_path '\toolbox_graph\toolbox_graph\']); path(path,[base_path '\toolbox_graph\toolbox_graph\toolbox\']);
path(path,[base_path '\CORR_functions\']);
% path(path,MOSEK_path);
imagepath=[base_path '\images\'];

% for comparison with conformal methods
meshpath=[base_path '\meshes\param_conf\'];
% targetpath = [base_path '\meshes\param_conf\bcd\'];
targetpath = [base_path '\results\'];



%--------------------------------------------------------------------------
% load data
switch(mesh_name((end-2):end))
    case 'off'
        [V F] = read_off([meshpath mesh_name]);V=V'; F=F';
        % [V F U0] = read_toff([meshpath mesh_name]);V=V'; F=F'; U0=U0';
        %        problem.U0=U0(:,1)+1i*U0(:,2);
    case 'obj'
        obj = read_wobj([meshpath mesh_name]);
        V = obj.vertices;
        if(length(obj.objects)==4)
            F = obj.objects(4).data.vertices;%for meshlab objs
        else
            F = obj.objects.data.vertices;%for standard objs
        end
        
        
end

disp([mesh_name '    |V|= ' num2str(size(V,1))]);
% return;

%--------------------------------------------------------------------------
% perform parametrization


% define the optimization problem
problem.quiet=quiet; %use quiet mode - "minimal" data on screen
% problem.constraints =  {  'CC' , 'PC', 'CDC_Linf', 'free_boundary'};%,'LBr'}%,'SVC_Linf'};%,'SVC_Linf'};%_Linf'}%,'HC'}%_Linf'}%,'HC'}%,'LBa'}%_Linf'}%, 'SVC' } %,CDC_Linf 'HC'} %'CDC','CDC-AP' 'SVC' };%, 'PC'  };
problem.constraints =  {  'CC' , 'PC', 'CDC_L1', 'free_boundary'};%,'LBr'}%,'SVC_Linf'};%,'SVC_Linf'};%_Linf'}%,'HC'}%_Linf'}%,'HC'}%,'LBa'}%_Linf'}%, 'SVC' } %,CDC_Linf 'HC'} %'CDC','CDC-AP' 'SVC' };%, 'PC'  };
problem.energy = { 'l2_L2' };%'l2_BIH','l1_L2','l2_L2','l1_Linf','l1_L1','l1_H2','l2_H2','l1_H2-AP','linf_Linf','linf_Linf_SMOOTH' };
problem.user_constraints = {'point'};% ''no_contraints'' 'point' 'rotation_scale'
problem.solver = {'QP_Matlab'};% 'Mosek','QP_Matlab'
problem.frame_initialization_method = 'harmonic';%%possibilities: 'identity','polydeform','param_with_init_frames'
q=1.5*sqrt(problem.C_);%for controling rigid distortion - inactive
problem.s_ = 1/q;%for controling rigid distortion - inactive
problem.S_ = q;%for controling rigid distortion - inactive

problem.U00 = [0 0 0]; %the point constraints: take the closest point to the origin
problem.U11 = 0; %to the origin of the 2D plane

% optimize for the Bounded-distortion map
[tP X Mdb] = QCONF_map(V,F,problem,[],[]);
U = tP(:,1)+1i*tP(:,2); %the UV coordinates

%--------------------------------------------------------------------------
% save results in obj file
tname = [targetpath mesh_name(1:(end-4)) '_bcd.obj'];
clear('obj');
obj.vertices = Mdb.V;
obj.vertices_texture = [X(Mdb.iu1) X(Mdb.iu2)];
obj.objects.type='f';
obj.objects.data.vertices = Mdb.F;
obj.objects.data.texture = Mdb.F;
write_wobj(obj,tname);


%--------------------------------------------------------------------------
% show results
disp('Display parametrization');

cax = [1 4];%color axis (corresponds to distortion)
edgecolor = 'none'; %edge color: do not plot edges

%draw the UV, and save UV-mesh to VTK file (can be shown in Paraview software)
QCONF_display_param_result(V,F,U,cax,edgecolor,'Bounded-Conformal Distortion',102);

