/** This file contains the code for generating the seed of the PRF. The seed of
 * the PRF forms the key to the encryption/decryption functions. Thus it is
 * important to store the seed in a place to which noone else except the user
 * can have access. 
 *
 * We provide this abstraction of a secret place in a naive manner by providing
 * a separate subdirectory for keys. The user may change permissions of this
 * directory to make it private to himself
 *
 */

#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include "Randomizer.hpp"

#define keyfile "keys/key.dat"
#define genfile "data/setsystemPRF.dat"

int stringToNumber(char *string);

main() {

	 // First read the value of n and d from the setsystem file
	 FILE *fp;
	 int test1;
	 test1 = (int)fopen(genfile, "r"); // Open file for writing
	 if (!test1) {
		  printf("\nThe file for setsystem could not be opened. Make sure you are in the right directory while executing this command.\n\n");
		  exit(1);
	 }
     fp = fopen(genfile, "r");
	 
	 int n, d;
	 fscanf(fp, "%d\n%d\n", &n, &d);
	 fclose(fp);
	 
	 Randomizer r;
	 int power = (int)pow(2.0, (double)d);
	 int entry;
	 char seedbit;
	
     // Take the random seed from the user
	 char string[200];
	 printf("\nThe currently stored values for n and d are %d and %d respectively. Thus the key that will be genrated will be of size %d.", n, d, power+n);
	 printf("\nEnter a random string (less than 200 characters) of your choice. It'll be used to generate the seed.\n");
	 scanf("%s", &string);
	 entry = stringToNumber(string);
	 srand(entry);
     r.init(rand(), 2);
	 
	 test1 = (int)fopen(keyfile, "w"); // Open file for writing
	 if (!test1) {
		  printf("\nThe file for the key could not be opened. Make sure you are in the right directory while executing this command.\n\n");
		  exit(1);
	 }
	 fp = fopen(keyfile, "w");
	 
	 for (int k=0; k<power+n; ++k) {
		  seedbit = (r.nextNumber() == 1)?'1':'0';
		  putc(seedbit, fp);
	 }	  

	 printf("\nYour new key has been created and stored in the proper place.\n\n"); 
	 
	 fclose(fp);	 
}
		  
int stringToNumber(char *string) {
     int count = 0, ret = 0;
	 char next;
	 while ((next = string[count++]) != '\0') {
	      ret += (int)next; 
	 }
	 return ret;
}
 

