/** This code contains the function for generating the setsystem of the PRF.
 * The actual generation of the set-system occurs in a different file.
 * The value of the number of times the OWF has to be iterated is taken 
 * as input from the user and store in THE SAME FILE AS THE SETSYSTEM
 * 
 */

#include "Generate.hpp"

#define genfile "data/setsystemPRF.dat" // To store the default expanders for PRF

main() {
	 int choice;

	 printf("\n");
     
	 // Generate the setsystem :-
	 printf("Do you want to generate a new setsystem ?\n\n");
	 printf("\tEnter 1 to generate a new setsystem.\n\tEnter 0 to use the existing one\n\n");
	 printf("Your choice here - ");
	
	 while (1) {
		  scanf("%d", &choice);
		  if ((choice != 1) && (choice != 0)) 
			   printf("\nInvalid Entry. Enter again - ");
		  else 
			   break;
	 }
	
	 if (choice == 1) {
		  generateAndStoreExpander(genfile);
	 }
     
	 // Input number of iterations :-
	 FILE *fp;
	 int test1;
	 test1 = (int) fopen(genfile, "r");
	 if (!test1) {
		  printf("\nThe file for setsystem could not be opened. Make sure you are in the right directory while executing this command.\n\n");
		  exit(1);
	 }
	 fp = fopen(genfile, "r");
	 int n, iter, limit;

	 fscanf(fp, "%d\n", &n);
	 fclose(fp);

	 limit = (int)(log((double)n)/log(2.0));
	 if (limit < 5)
		  limit = 5;
	 printf("\nEnter the number of iterations for the OWF desired. The number of iterations should be at least min(5, log(n) to the base 2) where n is the input length of the function)."
		   );
	 printf("\nThe value of n currently is %d. So your entry should be at least %d\n", n, limit);
	 printf("Your choice here - ");

	 while (1) {
		  scanf("%d", &iter);
		  if (iter < limit)
			   printf("\nInvalid Entry. Enter again - ");
		  else 
			   break;
	 }

	 // Puteets ! 
	 test1 = (int) fopen(genfile, "a");
	 if (!test1) {
		  printf("\nThe file for predicate could not be opened. Make sure you are in the right directory while executing this command.\n\n");
		  exit(1);
	 }
	 fp = fopen(genfile, "a");
	 
	 fprintf(fp, "%d\n", iter);
	 fclose(fp);

	 printf("\nThe parameters for the PRF have been created and stored in their proper place.\n\n");

} 
	 

