function pt=comp_points_num(n,folder)
pt=[-1 1
    0 0];
figure
plot(pt(1,:),pt(2,:),'*')
saveas(gcf,[folder '\points_0.fig'])

for i=1:n
    drow_ints(pt)
    saveas(gcf,[folder '\pic_' num2str(i) '.fig'])
    pt = erase_dubels([pt comp_ints(pt)]);    
    figure
    plot(pt(1,:),pt(2,:),'*')
    saveas(gcf,[folder '\points_' num2str(i) '.fig'])
    save([folder '\data_' num2str(i)])
end
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function int=comp_ints(pt);
n=size(pt,2);
int=[];
for i=1:n;
for j=i:n;
for k=max(j,i+1):n;
for l=max(k,j+1):n;
    if (~(i==j))&(~(k==l));
        int=[int int_ll(pt(:,[i j k l])) ...
            int_lc(pt(:,[i j k l])) int_lc(pt(:,[i j l k])) int_lc(pt(:,[k l i j ])) int_lc(pt(:,[k l j i ]))...
            int_cc(pt(:,[i j k l])) int_cc(pt(:,[j i k l])) int_cc(pt(:,[i j l k])) int_cc(pt(:,[j i l k])) ];
    end;
    if (~(i==k))&(~(j==l));
        int=[int int_ll(pt(:,[i k j l]))...
            int_lc(pt(:,[i k j l])) int_lc(pt(:,[i k l j])) int_lc(pt(:,[j l i k])) int_lc(pt(:,[j l k i]))...
            int_cc(pt(:,[i k j l])) int_cc(pt(:,[k i j l])) int_cc(pt(:,[i k l j])) int_cc(pt(:,[k i l j])) ];
    end;
    if (~(i==l))&(~(j==k));
        int=[int int_ll(pt(:,[i l j k]))...
            int_lc(pt(:,[i l j k])) int_lc(pt(:,[i l k j])) int_lc(pt(:,[j k i l])) int_lc(pt(:,[j k l i]))...
            int_cc(pt(:,[i l j k])) int_cc(pt(:,[l i j k])) int_cc(pt(:,[i l k j])) int_cc(pt(:,[l i k j])) ];
    end;
end
end
end
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function m = erase_dubels(m);
i=1;
n=size(m,2);
while i<size(m,2)
    m=[m(:,1:(i-1)) erase_firsts_like(m(:,i:end))];
    i=i+1;
end    
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function m=erase_firsts_like(m)
n=size(m,2);
m(:,find(all(abs(m(:,1)*ones(1,(n-1))-m(:,2:end))<0.00001))+1)=[];
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function pt=int_ll(pts)
v=pts(:,1)-pts(:,3);
d1=pts(:,2)-pts(:,1);
d2=pts(:,4)-pts(:,3);
den= det([d1 d2]);
if abs(den)<0.000001;
    pt=[];
    return
end
t=-det([v d2])/den;
pt=pts(:,1)+d1*t;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function pt=int_lc(pts)
v=pts(:,1)-pts(:,3);
d=pts(:,2)-pts(:,1);
d2=(pts(:,4)-pts(:,3));
r2=d2'*d2;
a=d'*d;
b=2*v'*d;
c=v'*v-r2;
del=b*b-4*a*c;
if abs(del)<0.0000000001;
    del=0;
end

if (del<0);
    pt=[];
    return
end
del=sqrt(del);

tow_a=2*a;
if (del==0);
    pt=pts(:,1)-d*b/tow_a;
    return
end
t1=(-b+del)/tow_a;
t2=(-b-del)/tow_a;
pt(:,1)=pts(:,1)+d*t1;
pt(:,2)=pts(:,1)+d*t2;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function pt=int_cc(pts)
v=pts(:,1)-pts(:,3);
b=sqrt(v'*v);
if (b==0);
    pt=[];
    return
end
d1=pts(:,2)-pts(:,1);
r1=sqrt(d1'*d1);
d2=(pts(:,4)-pts(:,3));
r2=sqrt(d2'*d2);

p=(b+r1+r2)/2;
s=p*(p-b)*(p-r1)*(p-r2);
if abs(s)<0.0000000001;
    s=0;
end
if (s<0);
    pt=[];
    return
end
s=sqrt(s);

h=2*s/b;

p1=sqrt(r1*r1-h*h);
v=-v/b;
pt0=pts(:,1)+v*p1;
if (h==0);
    pt=pt0;
    return
end

v=[v(2); -v(1)];
pt=[pt0+v*h,pt0-v*h];
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function drow_ints(pt)
n=size(pt,2);
l=200;
k=10;
figure;
hold on;
for i=1:n;
for j=(i+1):n;
    drow_long_line(pt(:,i),pt(:,j),l);
    drow_cir(pt(:,i),pt(:,j),k);
    drow_cir(pt(:,j),pt(:,i),k)    ;
end
end
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function drow_long_line(pt1,pt2,l)
v=pt1-pt2;
v=v/norm(v);
pt1=pt1+v*l;
pt2=pt2-v*l;
plot([pt1(1) pt2(1)],[pt1(2) pt2(2)])
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function drow_cir(pt1,pt2,k);
r=norm(pt2-pt1);
k=max(k,floor(2*pi*r*5));
v=0:(2*pi/k):2*pi;
plot(pt1(1)+r*cos(v),pt1(2)+r*sin(v));