/*
 * Decompiled with CFR 0.152.
 */
package musd.compiler;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import musd.compiler.MUSDModelCompiler;

public class FilesWriter {
    public static final String ASPECT_EXTENSION = ".aj";
    public static final String METHODS_FILE_NAME = "MUSDMethods";
    public static final String JAVA_EXTENSION = ".java";
    public static final String COORDINATOR_NAME = "MUSDCoordinatorAspect";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void writeAll(MUSDModelCompiler compiledModel, String path) {
        try {
            boolean success;
            Iterator<String> it = compiledModel.getInteractionsAspects().keySet().iterator();
            File file = new File(path);
            if (!file.isDirectory() && !(success = new File(path).mkdirs())) {
                throw new IOException("Could Not Create the output directory , check privileges");
            }
            while (true) {
                PrintWriter out;
                if (!it.hasNext()) {
                    out = new PrintWriter(new FileWriter(String.valueOf(path) + METHODS_FILE_NAME + JAVA_EXTENSION));
                    String methods = compiledModel.getMUSDMethodsConstants();
                    out.println(methods);
                    out.flush();
                    out.close();
                    out = new PrintWriter(new FileWriter(String.valueOf(path) + COORDINATOR_NAME + ASPECT_EXTENSION));
                    String coordinator = compiledModel.getCoordinator();
                    out.println(coordinator);
                    out.flush();
                    out.close();
                    return;
                }
                String aspectName = it.next();
                String aspectCode = compiledModel.getInteractionsAspects().get(aspectName);
                out = new PrintWriter(new FileWriter(String.valueOf(path) + aspectName + ASPECT_EXTENSION));
                out.println(aspectCode);
                out.flush();
                out.close();
            }
        }
        catch (IOException e) {
            System.out.print(e.getStackTrace());
        }
    }

    public static void cleanAll(String folder) {
        File dir = folder.endsWith("\\") ? new File(folder.substring(0, folder.length() - 1)) : new File(folder);
        FilesWriter.deleteDir(dir);
    }

    private static boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            int i = 0;
            while (i < children.length) {
                boolean success = FilesWriter.deleteDir(new File(dir, children[i]));
                if (!success) {
                    return false;
                }
                ++i;
            }
        }
        return dir.delete();
    }
}

