/*
 * Decompiled with CFR 0.152.
 */
package musd.compiler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import musd.compiler.lib.MUSDArgument;
import musd.compiler.lib.MUSDMessage;
import musd.compiler.stringutils.CoordinatorStringGen;
import musd.compiler.stringutils.MUSDAspectStringGen;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MUSDInteractions2Coordinator {
    private StringBuffer code;
    private ArrayList<String> interactionAspectsNames;
    private HashSet<String> pointCutCores;
    private HashSet<MUSDMessage> executableMessages;
    private HashMap<String, String> varNamesToVarTypes;

    public MUSDInteractions2Coordinator(ArrayList<String> AspectNames, String coordinatoImplClass, HashSet<String> pointCutsCore, HashSet<MUSDMessage> exeMes, ArrayList<String> imports, String targetPack, HashMap<String, String> varNamesToVarTypes) {
        this.executableMessages = exeMes;
        this.interactionAspectsNames = AspectNames;
        this.varNamesToVarTypes = varNamesToVarTypes;
        this.code = new StringBuffer(3000);
        this.pointCutCores = pointCutsCore;
        this.addDeclerationAndImports(coordinatoImplClass, imports, targetPack);
        this.addWrappers();
        this.addPointCuts();
        this.addAfter();
        this.addCloser();
    }

    private void addDeclerationAndImports(String coordinatoImplClass, ArrayList<String> imports, String targetPack) {
        this.code.append(MUSDAspectStringGen.generateCoordinatorLicenceWarnning());
        this.code.append(MUSDAspectStringGen.generatePackageDeclaration(targetPack));
        Iterator<String> it = imports.iterator();
        while (it.hasNext()) {
            this.code.append(MUSDAspectStringGen.generateImport(it.next()));
        }
        this.code.append(CoordinatorStringGen.generateDeclaration(coordinatoImplClass));
    }

    private void addWrappers() {
        Iterator<MUSDMessage> it = this.executableMessages.iterator();
        HashSet<String> wrapperNames = new HashSet<String>();
        ArrayList<String> argsNames = new ArrayList<String>();
        ArrayList<String> argsTypes = new ArrayList<String>();
        while (it.hasNext()) {
            argsNames.clear();
            argsTypes.clear();
            MUSDMessage mes = it.next();
            String name = MUSDAspectStringGen.getMessageCoddedName(mes);
            if (wrapperNames.contains(name)) continue;
            wrapperNames.add(name);
            String targetType = mes.getReciever().getRepresentsType();
            String thisType = mes.getSender().getRepresentsType();
            String methodName = mes.getName();
            String returnType = mes.getReturnType();
            Iterator<MUSDArgument> it2 = mes.getArguments().iterator();
            while (it2.hasNext()) {
                String argName = it2.next().getName();
                argsTypes.add(this.varNamesToVarTypes.get(argName));
                argsNames.add(argName);
            }
            if (mes.isConstructor()) {
                this.code.append(CoordinatorStringGen.generateConstructorWrapper(thisType, targetType, methodName, argsNames, argsTypes));
                continue;
            }
            this.code.append(CoordinatorStringGen.generateWrapper(thisType, targetType, methodName, argsNames, argsTypes, returnType));
        }
    }

    private void addPointCuts() {
        this.code.append(CoordinatorStringGen.generateCoordinatorPointCutDecleration());
        Iterator<String> it = this.pointCutCores.iterator();
        boolean b = false;
        while (it.hasNext()) {
            this.code.append("\n\t");
            if (b) {
                this.code.append("|| ");
            }
            b = true;
            this.code.append(it.next());
        }
        this.code.append(";\n\n\n");
    }

    private void addAfter() {
        this.code.append(CoordinatorStringGen.generateCoordinatorAfter());
        Iterator<String> it = this.interactionAspectsNames.iterator();
        while (it.hasNext()) {
            this.code.append(CoordinatorStringGen.generateCoordinatorGetCutState(it.next()));
        }
        this.code.append(CoordinatorStringGen.generateCoordinatorAfterSwitch());
        Iterator<MUSDMessage> it2 = this.executableMessages.iterator();
        HashSet<String> casesNames = new HashSet<String>();
        ArrayList<String> argsType = new ArrayList<String>();
        while (it2.hasNext()) {
            MUSDMessage mes = it2.next();
            String caseName = MUSDAspectStringGen.getMessageCoddedName(mes);
            if (casesNames.contains(caseName)) continue;
            casesNames.add(caseName);
            argsType.clear();
            String thisType = mes.getSender().getRepresentsType();
            String targetType = mes.getReciever().getRepresentsType();
            String methodName = mes.getName();
            Iterator<MUSDArgument> itType = mes.getArguments().iterator();
            while (itType.hasNext()) {
                argsType.add(this.varNamesToVarTypes.get(itType.next().getName()));
            }
            this.code.append(CoordinatorStringGen.generateCoordinatorCase(thisType, targetType, methodName, argsType));
        }
    }

    private void addCloser() {
        this.code.append(CoordinatorStringGen.generateCoordinatorCloser());
    }

    public String getCode() {
        return this.code.toString();
    }
}

