/*
 * Decompiled with CFR 0.152.
 */
package musd.compiler;

import java.util.ArrayList;
import java.util.HashMap;
import musd.compiler.MUSDInteractionsCompiler;
import musd.compiler.lib.MUSDInteraction;
import org.eclipse.emf.common.util.EList;
import org.eclipse.uml2.uml.BehavioredClassifier;
import org.eclipse.uml2.uml.Interaction;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.PackageableElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MUSDModelCompiler {
    ArrayList<MUSDInteraction> interactionList;
    HashMap<String, String> interactionsAspects = null;
    Model model;
    String MUSDMethodsConstants;
    String coordinator;

    public MUSDModelCompiler(Model model) {
        this.model = model;
        this.interactionList = new ArrayList();
        EList ElementsList = model.getPackagedElements();
        for (PackageableElement pe : ElementsList) {
            if (!(pe instanceof BehavioredClassifier)) continue;
            this.handleCollaboration((BehavioredClassifier)pe);
        }
    }

    public void compileModel(String implClass, String[] importsArray, String targetPackage) {
        this.compileList(implClass, importsArray, targetPackage, this.interactionList);
    }

    public void compileModel(String[] selectedInteractions, String implClass, String[] importsArray, String targetPackage) {
        ArrayList<String> imports = new ArrayList<String>();
        int i = 0;
        while (i < importsArray.length) {
            imports.add(importsArray[i]);
            ++i;
        }
        ArrayList<String> selectedInteractionsArray = new ArrayList<String>();
        int i2 = 0;
        while (i2 < selectedInteractions.length) {
            selectedInteractionsArray.add(selectedInteractions[i2].trim());
            ++i2;
        }
        ArrayList<MUSDInteraction> toCompileList = new ArrayList<MUSDInteraction>();
        int i3 = 0;
        while (i3 < this.interactionList.size()) {
            if (selectedInteractionsArray.contains(this.interactionList.get(i3).getName())) {
                toCompileList.add(this.interactionList.get(i3));
            }
            ++i3;
        }
        MUSDInteractionsCompiler compiler = new MUSDInteractionsCompiler(toCompileList);
        this.interactionsAspects = compiler.compileAspects(imports, targetPackage);
        this.MUSDMethodsConstants = compiler.compileMethodConstants(targetPackage);
        this.coordinator = compiler.compileCoordinator(implClass, imports, targetPackage);
    }

    private void compileList(String implClass, String[] importsArray, String targetPackage, ArrayList<MUSDInteraction> toCompileList) {
        ArrayList<String> imports = new ArrayList<String>();
        int i = 0;
        while (i < importsArray.length) {
            imports.add(importsArray[i]);
            ++i;
        }
        MUSDInteractionsCompiler compiler = new MUSDInteractionsCompiler(toCompileList);
        this.interactionsAspects = compiler.compileAspects(imports, targetPackage);
        this.MUSDMethodsConstants = compiler.compileMethodConstants(targetPackage);
        this.coordinator = compiler.compileCoordinator(implClass, imports, targetPackage);
    }

    public String getMUSDMethodsConstants() {
        return this.MUSDMethodsConstants;
    }

    public String getCoordinator() {
        return this.coordinator;
    }

    public HashMap<String, String> getInteractionsAspects() {
        return this.interactionsAspects;
    }

    private void handleCollaboration(BehavioredClassifier col) {
        EList list = col.getOwnedBehaviors();
        for (Object obj : list) {
            if (!(obj instanceof Interaction)) continue;
            this.handleInteraction((Interaction)obj);
        }
    }

    private void handleInteraction(Interaction inter) {
        MUSDInteraction musdInter = new MUSDInteraction(inter);
        this.interactionList.add(musdInter);
    }
}

