/*
 * Decompiled with CFR 0.152.
 */
package musd.compiler.interaction2aspect;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import musd.compiler.interaction2aspect.ImmidiateEventsTree;
import musd.compiler.interaction2aspect.MUSDInteraction2Aspect;
import musd.compiler.interaction2aspect.MessageData;
import musd.compiler.lib.CutState;
import musd.compiler.lib.MUSDArgument;
import musd.compiler.lib.MUSDMessage;
import musd.compiler.stringutils.ChangeCutStringGen;
import musd.compiler.stringutils.MUSDAspectStringGen;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MUSDChangeCutStateBuilder {
    int consNumber = 0;
    HashMap<String, Integer> lineToIndexes;
    HashMap<Integer, String> constraintsAndGuardsStringsMap;
    HashMap<String, Integer> constraintReverseMap;
    private MUSDInteraction2Aspect inter2Aspect;
    private HashMap<String, String> varNamesToVarTypes;
    private HashSet<String> finalStates;

    public MUSDChangeCutStateBuilder(MUSDInteraction2Aspect inter2Aspect) {
        this.inter2Aspect = inter2Aspect;
        this.lineToIndexes = inter2Aspect.lineToIndexes;
        this.varNamesToVarTypes = inter2Aspect.varNamesToVarTypes;
        this.constraintsAndGuardsStringsMap = new HashMap();
        this.constraintReverseMap = new HashMap();
        this.finalStates = this.stateToStrings(inter2Aspect.interactionLogic.getFinalStates());
    }

    public String getChangeCutState() {
        HashSet<String> bodies = new HashSet<String>();
        StringBuffer code = new StringBuffer(1000);
        StringBuffer changeCutStateInits = this.inter2Aspect.staticInit.append(this.inter2Aspect.exactVarsInit);
        code.append(MUSDAspectStringGen.generateChangeCutStateConstants(changeCutStateInits.toString()));
        Iterator<MUSDMessage> it = this.inter2Aspect.interaction.getMessages().iterator();
        HashSet<String> casesName = new HashSet<String>();
        while (it.hasNext()) {
            bodies.clear();
            MUSDMessage mes = it.next();
            String caseName = MUSDAspectStringGen.getMessageCoddedName(mes);
            if (!casesName.add(caseName)) continue;
            code.append(MUSDAspectStringGen.generateCaseForCahngeCutState(mes.getSender().getRepresentsType(), mes.getReciever().getRepresentsType(), mes.getName()));
            Iterator dataListIterator = ((ArrayList)this.inter2Aspect.interactionLogic.get(MUSDAspectStringGen.getMessageCoddedName(mes))).iterator();
            while (dataListIterator.hasNext()) {
                String body = this.getCodeForBranch((MessageData)dataListIterator.next());
                if (!bodies.add(body)) continue;
                code.append(body);
            }
            code.append("\t\t\t\tbreak;\n");
        }
        code.append(ChangeCutStringGen.generateChangeCutStateCloser());
        code.append(this.getEvaluteConstraints());
        return code.toString();
    }

    private String getCodeForBranch(MessageData data) {
        StringBuffer str = new StringBuffer(200);
        String oldStateString = data.oldState.getCutStateString(this.lineToIndexes);
        String newStateString = data.newState.getCutStateString(this.lineToIndexes);
        ImmidiateEventsTree tree = new ImmidiateEventsTree(data, this);
        this.consNumber = tree.getConstraintNumber();
        String varsCheck = this.getVarsCheckString(data);
        String varsSets = this.getVarsSetsString(data);
        if (data.realMessage.isConstructor()) {
            str.append(ChangeCutStringGen.getChangeCutForConstructors(oldStateString, data.receiverBindingConstant, newStateString, this.finalStates, varsCheck, varsSets, tree));
            if (!data.realMessage.getSender().isEnv() && data.isSenderBound) {
                str.append(ChangeCutStringGen.getChangeCutForSmallConstructorsSenderUnified(newStateString, data.senderBindingConstant));
            }
            if (!data.realMessage.getSender().isEnv() && !data.isSenderBound) {
                str.append(ChangeCutStringGen.getChangeCutForSmallConstructorsSenderNotUnified(newStateString, data.senderBindingConstant));
            }
            return str.toString();
        }
        if ((data.isReceiverBound || data.receiverBindingConstant.equals("env")) && data.isSenderBound) {
            str.append(ChangeCutStringGen.getChangeCutForSrcAndTargetUni(oldStateString, data.senderBindingConstant, data.receiverBindingConstant, newStateString, this.finalStates, varsCheck, varsSets, tree));
            return str.toString();
        }
        if (data.isSenderBound || data.receiverBindingConstant.equals("env")) {
            str.append(ChangeCutStringGen.getChangeCutForSrcUni(oldStateString, data.senderBindingConstant, data.receiverBindingConstant, newStateString, this.finalStates, varsCheck, varsSets, tree));
            return str.toString();
        }
        if (data.isReceiverBound) {
            str.append(ChangeCutStringGen.getChangeCutForTargetUni(oldStateString, data.senderBindingConstant, data.receiverBindingConstant, newStateString, this.finalStates, varsCheck, varsSets, tree));
            return str.toString();
        }
        str.append(ChangeCutStringGen.getChangeCutNoUni(oldStateString, data.senderBindingConstant, data.receiverBindingConstant, newStateString, this.finalStates, varsCheck, varsSets, tree));
        return str.toString();
    }

    private String getVarsCheckString(MessageData data) {
        StringBuffer str = new StringBuffer();
        Iterator<MUSDArgument> it = data.realMessage.getArguments().iterator();
        int i = 0;
        while (it.hasNext()) {
            MUSDArgument arg = it.next();
            boolean isBounded = data.varNamesToBindingState.get(arg.getName());
            if (isBounded) {
                str.append(MUSDAspectStringGen.generateVarsEquals(arg.getName(), this.varNamesToVarTypes.get(arg.getName()), i));
            }
            ++i;
        }
        return str.toString();
    }

    private String getVarsSetsString(MessageData data) {
        StringBuffer str = new StringBuffer();
        Iterator<MUSDArgument> it = data.realMessage.getArguments().iterator();
        int i = 0;
        while (it.hasNext()) {
            MUSDArgument arg = it.next();
            boolean isBounded = data.varNamesToBindingState.get(arg.getName());
            if (!isBounded) {
                str.append(MUSDAspectStringGen.generateVarsSetter(arg.getName(), this.varNamesToVarTypes.get(arg.getName()), i));
            }
            ++i;
        }
        return str.toString();
    }

    private String getEvaluteConstraints() {
        HashMap<String, ArrayList<Integer>> repetitionMap = new HashMap<String, ArrayList<Integer>>();
        HashMap<Integer, String> reducedMap = new HashMap<Integer, String>();
        for (int i : this.constraintsAndGuardsStringsMap.keySet()) {
            String constraint = this.constraintsAndGuardsStringsMap.get(i);
            ArrayList<Integer> stringList = repetitionMap.get(constraint);
            if (stringList == null) {
                reducedMap.put(i, constraint);
                stringList = new ArrayList();
                repetitionMap.put(constraint, stringList);
                continue;
            }
            stringList.add(i);
        }
        return ChangeCutStringGen.generateEvaluateCondition(this.inter2Aspect.getInstAndVarsDecleration(true), reducedMap, repetitionMap);
    }

    private HashSet<String> stateToStrings(HashSet<CutState> states) {
        HashSet<String> resSet = new HashSet<String>();
        Iterator<CutState> it = states.iterator();
        while (it.hasNext()) {
            resSet.add(it.next().getCutStateString(this.lineToIndexes));
        }
        return resSet;
    }
}

