/*
 * Decompiled with CFR 0.152.
 */
package musd.compiler.interaction2aspect;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import musd.compiler.interaction2aspect.MUSDInteraction2Aspect;
import musd.compiler.interaction2aspect.MUSDInteractionLogic;
import musd.compiler.interaction2aspect.MessageData;
import musd.compiler.lib.CutState;
import musd.compiler.lib.MUSDArgument;
import musd.compiler.lib.MUSDConstraint;
import musd.compiler.lib.MUSDInteractionFragment;
import musd.compiler.lib.MUSDMessage;
import musd.compiler.stringutils.GetCutStateStringGen;
import musd.compiler.stringutils.MUSDAspectStringGen;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MUSDGetCutStateBuilder {
    private final int MAX_ADD = 7;
    private MUSDInteraction2Aspect inter2Aspect;
    private MUSDInteractionLogic interactionLogic;
    private HashMap<MessageData, Integer> messageDataToGeneratedMethodsNum;
    private HashMap<String, Integer> lineToIndexes;
    private HashMap<String, Integer> methodsToNumber;

    public MUSDGetCutStateBuilder(MUSDInteraction2Aspect inter2Aspect) {
        this.inter2Aspect = inter2Aspect;
        this.interactionLogic = inter2Aspect.interactionLogic;
        this.lineToIndexes = inter2Aspect.lineToIndexes;
        this.messageDataToGeneratedMethodsNum = new HashMap();
        this.methodsToNumber = new HashMap();
    }

    String getGetCutState() {
        StringBuffer code = new StringBuffer(1000);
        code.append(MUSDAspectStringGen.generateGetCutStateConst());
        code.append(this.inter2Aspect.getInstAndVarsDecleration(false));
        code.append(this.getMethodDeclerations());
        code.append(this.getIsInCutIfs());
        return code.toString();
    }

    private String getMethodDeclerations() {
        Iterator it = this.interactionLogic.keySet().iterator();
        StringBuffer str = new StringBuffer(100);
        int methodNumber = this.inter2Aspect.methodNumberRange;
        boolean isSenderEnv = false;
        boolean hasArgs = false;
        while (it.hasNext()) {
            String mesName = (String)it.next();
            for (MessageData data : (ArrayList)this.interactionLogic.get(mesName)) {
                String sender = data.realMessage.getSender().getName();
                String receiver = data.realMessage.getReciever().getName();
                String senderType = data.realMessage.getSender().getRepresentsType();
                String receiverType = data.realMessage.getReciever().getRepresentsType();
                isSenderEnv = data.realMessage.getSender().isEnv();
                hasArgs = data.realMessage.hasArguments();
                if (hasArgs) {
                    str.append(this.getMethodArguments(data.realMessage, methodNumber));
                }
                int num = hasArgs ? methodNumber : -1;
                String methodAssignment = GetCutStateStringGen.generateMUSDMethodDecleration(sender, receiver, data.isExecute, data.realMessage.getName(), isSenderEnv, senderType, receiverType, num);
                Integer realMethodNumber = this.methodsToNumber.get(methodAssignment);
                if (realMethodNumber == null) {
                    this.methodsToNumber.put(methodAssignment, methodNumber);
                    realMethodNumber = methodNumber;
                    str.append(GetCutStateStringGen.generateMUSDMethodAssignment(methodNumber, methodAssignment));
                }
                this.messageDataToGeneratedMethodsNum.put(data, realMethodNumber);
                ++methodNumber;
            }
        }
        this.inter2Aspect.finalRange = methodNumber - 1;
        return str.append("\n").toString();
    }

    private String getMethodArguments(MUSDMessage mes, int number) {
        StringBuffer str = new StringBuffer(80);
        Iterator<MUSDArgument> it = mes.getArguments().iterator();
        ArrayList<String> argsNames = new ArrayList<String>();
        while (it.hasNext()) {
            argsNames.add("VAR_" + it.next().getName());
        }
        if (argsNames.size() > 0) {
            str.append(MUSDAspectStringGen.generateMethodArgsInit(number));
            str.append(MUSDAspectStringGen.getArgsInit(argsNames));
        }
        return str.toString();
    }

    private String getIsInCutIfs() {
        ArrayList cutList = new ArrayList(this.interactionLogic.getCutToEnabledMessages().keySet());
        Collections.sort(cutList);
        Iterator it = cutList.iterator();
        StringBuffer str = new StringBuffer(400);
        while (it.hasNext()) {
            str.append(this.generateIfIsInCutBlock((CutState)it.next()));
        }
        str.append("\t}\n");
        return str.toString();
    }

    private String generateIfIsInCutBlock(CutState cut) {
        StringBuffer str = new StringBuffer(100);
        str.append(GetCutStateStringGen.generateIfIsInCutForGetCutState(cut.getCutStateString(this.lineToIndexes)));
        Iterator<MessageData> it = this.interactionLogic.getCutToEnabledMessages().get(cut).iterator();
        HashSet<String> enabledMethodsConstants = new HashSet<String>();
        HashSet<String> forbiddenMethodsConstants = new HashSet<String>();
        HashSet<MessageData> forbiddenMethodsData = new HashSet<MessageData>();
        HashSet<String> methodConstants = new HashSet<String>();
        while (it.hasNext()) {
            MessageData data = it.next();
            int number = this.messageDataToGeneratedMethodsNum.get(data);
            String methodConstant = GetCutStateStringGen.generateMethodName(number);
            if (methodConstants.add(methodConstant)) {
                if (data.isExecute) {
                    str.append(GetCutStateStringGen.generateExecuteEnable(methodConstant));
                } else {
                    str.append(GetCutStateStringGen.generateMonitoredEnable(methodConstant));
                }
            }
            if (this.isForbbidenMessage(data)) {
                forbiddenMethodsConstants.add(methodConstant);
                forbiddenMethodsData.add(data);
                continue;
            }
            enabledMethodsConstants.add(methodConstant);
        }
        if (cut.isHot()) {
            this.appendHotViolations(this.messageDataToGeneratedMethodsNum.keySet(), str, enabledMethodsConstants);
        } else {
            this.appendColdViolations(str, enabledMethodsConstants, forbiddenMethodsConstants);
            this.appendHotViolations(forbiddenMethodsData, str, null);
        }
        str.append("\t\t\t\treturn;\n\t\t}\n");
        return str.toString();
    }

    private void appendHotViolations(Set<MessageData> set, StringBuffer str, HashSet<String> methodsConstants) {
        Iterator<MessageData> it = set.iterator();
        HashSet<String> allReadyProcessed = new HashSet<String>();
        int mod = 0;
        while (it.hasNext()) {
            MessageData data = it.next();
            int num = this.messageDataToGeneratedMethodsNum.get(data);
            String constant = GetCutStateStringGen.generateMethodName(num);
            if (!allReadyProcessed.add(constant) || methodsConstants != null && methodsConstants.contains(constant)) continue;
            this.addHotViolation(str, mod++, constant);
        }
        this.addViolationCloser(str, mod);
    }

    private void appendColdViolations(StringBuffer str, HashSet<String> methodsConstants, HashSet<String> forbiddenConstants) {
        Iterator<MessageData> it = this.messageDataToGeneratedMethodsNum.keySet().iterator();
        HashSet<String> allReadyProcessed = new HashSet<String>();
        int mod = 0;
        while (it.hasNext()) {
            MessageData data = it.next();
            int num = this.messageDataToGeneratedMethodsNum.get(data);
            String constant = GetCutStateStringGen.generateMethodName(num);
            if (!allReadyProcessed.add(constant) || forbiddenConstants.contains(constant) || methodsConstants.contains(constant)) continue;
            this.addColdViolation(str, mod++, constant);
        }
        this.addViolationCloser(str, mod);
    }

    private void addHotViolation(StringBuffer str, int mod, String violation) {
        if (mod % 8 == 0) {
            str.append(GetCutStateStringGen.generateHVopening(violation));
        } else {
            str.append(GetCutStateStringGen.generateCVHVConcatenating(violation));
        }
        if ((mod + 1) % 8 == 0) {
            str.append(GetCutStateStringGen.generateCVHVCloser());
        }
    }

    private void addColdViolation(StringBuffer str, int mod, String violation) {
        if (mod % 8 == 0) {
            str.append(GetCutStateStringGen.generateCVopening(violation));
        } else {
            str.append(GetCutStateStringGen.generateCVHVConcatenating(violation));
        }
        if ((mod + 1) % 8 == 0) {
            str.append(GetCutStateStringGen.generateCVHVCloser());
        }
    }

    private void addViolationCloser(StringBuffer str, int mod) {
        if (mod > 0 && mod % 8 != 0) {
            str.append(GetCutStateStringGen.generateCVHVCloser());
        }
    }

    private boolean isForbbidenMessage(MessageData data) {
        for (MUSDInteractionFragment fragment : data.followingImmidiateEvents) {
            MUSDConstraint constraint;
            if (fragment.getType() != 1 || !(constraint = (MUSDConstraint)fragment).isHotFalseConstraint()) continue;
            return true;
        }
        return false;
    }
}

