/*
 * Decompiled with CFR 0.152.
 */
package musd.compiler.lib;

import musd.uml.ModalProfileUtils;
import org.eclipse.uml2.uml.Lifeline;

public class MUSDLifeLine {
    public static final String ENV = "env";
    private String name;
    private String represents;
    private String representsType;
    private boolean isEnv;
    private boolean isStatic;

    public MUSDLifeLine(Lifeline line) {
        this.name = line.getName() != null ? line.getName() : line.getRepresents().getName();
        this.isStatic = ModalProfileUtils.isSystem(line);
        this.isEnv = ModalProfileUtils.isEnvironment(line);
        this.represents = line.getRepresents().getType().getName();
        this.representsType = this.isEnv ? ENV : line.getRepresents().getType().getName();
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public boolean isEnv() {
        return this.isEnv;
    }

    public String getName() {
        return this.name;
    }

    public String getRepresents() {
        return this.represents;
    }

    public String getRepresentsType() {
        return this.representsType;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object o) {
        MUSDLifeLine line = (MUSDLifeLine)o;
        return this.isStatic == line.isStatic && this.isEnv == line.isEnv && this.name.equals(line.getName());
    }
}

