/*
 * Decompiled with CFR 0.152.
 */
package musd.compiler.lib;

import java.util.ArrayList;
import java.util.Iterator;
import musd.compiler.lib.MUSDArgument;
import musd.compiler.lib.MUSDInteractionFragment;
import musd.compiler.lib.MUSDLifeLine;
import org.eclipse.emf.common.util.EList;
import org.eclipse.uml2.uml.Lifeline;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.MessageOccurrenceSpecification;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.ParameterDirectionKind;
import org.eclipse.uml2.uml.ValueSpecification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MUSDMessage
extends MUSDInteractionFragment {
    private boolean isConstructor;
    private MUSDLifeLine sender;
    private MUSDLifeLine receiver;
    private MessageOccurrenceSpecification sendPoint;
    private MessageOccurrenceSpecification receivePoint;
    private String returnType;
    private ArrayList<MUSDArgument> arguments;
    private ArrayList<String> argumentTypes;

    public MUSDMessage(Message mes) {
        this.isImmediate = false;
        this.sendPoint = (MessageOccurrenceSpecification)mes.getSendEvent();
        this.receivePoint = (MessageOccurrenceSpecification)mes.getReceiveEvent();
        this.sender = new MUSDLifeLine((Lifeline)this.sendPoint.getCovereds().get(0));
        this.receiver = new MUSDLifeLine((Lifeline)this.receivePoint.getCovereds().get(0));
        this.arguments = this.initArguments(mes.getArguments());
        this.type = 0;
        this.initCoverdsLifeLines();
        if (mes.getMessageSort().getValue() == 3) {
            this.name = mes.getName();
            this.isConstructor = true;
            this.returnType = this.receiver.getRepresentsType();
            this.argumentTypes = this.initArgumentsTypes(mes.getOwnedElements());
            return;
        }
        this.isConstructor = false;
        Operation operation = (Operation)mes.getSignature();
        this.name = operation.getName();
        if (operation.getReturnResult() != null && operation.getReturnResult().getType() != null) {
            this.returnType = operation.getReturnResult().getType().getName();
        }
        this.argumentTypes = this.initArgumentsTypes(operation);
    }

    private ArrayList<String> initArgumentsTypes(EList list) {
        ArrayList<String> arr = new ArrayList<String>();
        for (ValueSpecification val : list) {
            if (val.getType() != null) {
                arr.add(val.getType().getName());
                continue;
            }
            arr.add(MUSDArgument.getValueSpecificationType(val));
        }
        return arr;
    }

    private ArrayList<String> initArgumentsTypes(Operation operation) {
        ArrayList<String> arr = new ArrayList<String>();
        for (Parameter par : operation.getOwnedParameters()) {
            if (par.getDirection() == ParameterDirectionKind.RETURN_LITERAL) continue;
            arr.add(par.getType().getName());
        }
        return arr;
    }

    private ArrayList<MUSDArgument> initArguments(EList args) {
        Iterator it = args.iterator();
        ArrayList<MUSDArgument> arr = new ArrayList<MUSDArgument>();
        while (it.hasNext()) {
            arr.add(new MUSDArgument((ValueSpecification)it.next()));
        }
        return arr;
    }

    private boolean returnTypeEqual(String res1, String res2) {
        if (res1 == null && res2 == null) {
            return true;
        }
        if (res1 == null && res2 != null) {
            return false;
        }
        if (res2 == null && res1 != null) {
            return false;
        }
        return res1.equals(res2);
    }

    private boolean paramsTypeEqual(ArrayList<String> parametersType1, ArrayList<String> parametersType2) {
        if (parametersType1.size() != parametersType2.size()) {
            return false;
        }
        Iterator<String> it1 = parametersType1.iterator();
        Iterator<String> it2 = parametersType2.iterator();
        while (it1.hasNext()) {
            if (it1.next().equals(it2.next())) continue;
            return false;
        }
        return true;
    }

    private boolean exactParamsValueEqual(ArrayList<MUSDArgument> args1, ArrayList<MUSDArgument> args2) {
        if (args1.size() != args2.size()) {
            return false;
        }
        Iterator<MUSDArgument> it1 = args1.iterator();
        Iterator<MUSDArgument> it2 = args2.iterator();
        while (it1.hasNext()) {
            MUSDArgument arg1 = it1.next();
            MUSDArgument arg2 = it2.next();
            if (!arg1.isExact() && !arg2.isExact()) continue;
            if (arg1.isExact() && !arg2.isExact()) {
                return false;
            }
            if (arg2.isExact() && !arg1.isExact()) {
                return false;
            }
            if (arg1.equals(arg2)) continue;
            return false;
        }
        return true;
    }

    private void initCoverdsLifeLines() {
        this.coveredLifeLines = new ArrayList();
        this.coveredLifeLines.add(this.sender);
        if (!this.sender.equals(this.receiver)) {
            this.coveredLifeLines.add(this.receiver);
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof MUSDMessage)) {
            return false;
        }
        MUSDMessage mes = (MUSDMessage)o;
        return this.name.equals(mes.name) && this.sender.getRepresentsType().equals(mes.sender.getRepresentsType()) && this.receiver.getRepresentsType().equals(mes.receiver.getRepresentsType()) && this.isConstructor == mes.isConstructor && this.returnTypeEqual(this.returnType, mes.returnType) && this.paramsTypeEqual(this.argumentTypes, mes.getArgumentsTypes()) && this.exactParamsValueEqual(this.arguments, mes.getArguments());
    }

    public ArrayList<MUSDArgument> getArguments() {
        return this.arguments;
    }

    public ArrayList<String> getArgumentsTypes() {
        return this.argumentTypes;
    }

    public MessageOccurrenceSpecification getSendPoint() {
        return this.sendPoint;
    }

    public MessageOccurrenceSpecification getReceivePoint() {
        return this.receivePoint;
    }

    public MUSDLifeLine getSender() {
        return this.sender;
    }

    public MUSDLifeLine getReciever() {
        return this.receiver;
    }

    public String getReturnType() {
        return this.returnType;
    }

    public boolean hasArguments() {
        return !this.arguments.isEmpty();
    }

    public boolean isConstructor() {
        return this.isConstructor;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public static boolean isRelevantMessage(Message mes) {
        int sort = mes.getMessageSort().getValue();
        return sort != 5 && sort != 2;
    }
}

