/*
 * Decompiled with CFR 0.152.
 */
package musd.compiler.lib;

import java.util.ArrayList;
import java.util.HashMap;
import musd.compiler.lib.CutState;
import musd.compiler.lib.InteractionFragmentKey;
import musd.compiler.lib.MUSDCombinedFragment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StateNode {
    private CutState cutState;
    private HashMap<InteractionFragmentKey, StateNode> children;
    private HashMap<MUSDCombinedFragment, ArrayList<InteractionFragmentKey>> comb2guardsList;
    private HashMap<StateNode, InteractionFragmentKey> dummyNodes;
    private boolean isExecute;
    private StateNode parent;
    private StateNode combinedNextNode;
    private CutState combinedNextCut;

    StateNode(CutState cutState, StateNode parent) {
        this.parent = parent;
        this.cutState = new CutState(cutState);
        this.isExecute = false;
        this.children = new HashMap();
        this.dummyNodes = new HashMap();
        this.comb2guardsList = new HashMap();
        this.combinedNextCut = new CutState(cutState);
    }

    void addCombinedFragment(MUSDCombinedFragment comb) {
        this.comb2guardsList.put(comb, new ArrayList());
    }

    boolean addCombinedFragmentGuard(MUSDCombinedFragment comb, InteractionFragmentKey key) {
        ArrayList<InteractionFragmentKey> list = this.comb2guardsList.get(comb);
        if (list != null) {
            return list.add(key);
        }
        return false;
    }

    void addChild(InteractionFragmentKey key, StateNode node) {
        this.children.put(key, node);
    }

    void setHot(boolean b) {
        this.cutState.setHot(b);
    }

    void setExecute(boolean b) {
        this.isExecute = b;
    }

    boolean isExecute() {
        return this.isExecute;
    }

    int getChildrenNumber() {
        return this.children.keySet().size();
    }

    StateNode getParent() {
        return this.parent;
    }

    void addDummyChild(StateNode node, InteractionFragmentKey key) {
        this.dummyNodes.put(node, key);
    }

    InteractionFragmentKey getDummyKey(StateNode node) {
        return this.dummyNodes.get(node);
    }

    void setCombinedNextCut(CutState cut) {
        this.combinedNextCut = cut;
    }

    public HashMap<InteractionFragmentKey, StateNode> getChildren() {
        return this.children;
    }

    public CutState getCutState() {
        return this.cutState;
    }

    public boolean isHot() {
        return this.cutState.isHot();
    }

    public ArrayList<InteractionFragmentKey> getCombGuardList(MUSDCombinedFragment comb) {
        return this.comb2guardsList.get(comb);
    }

    public HashMap<MUSDCombinedFragment, ArrayList<InteractionFragmentKey>> getComb2guardList() {
        return this.comb2guardsList;
    }

    public CutState getChildrenState(InteractionFragmentKey key) {
        StateNode son = this.children.get(key);
        return son != null ? son.getCutState() : null;
    }

    public CutState getCombinedNextCut() {
        return this.combinedNextCut;
    }

    public StateNode getCombinedNextNode() {
        return this.combinedNextNode;
    }

    public void setCombinedNextNode(StateNode node) {
        this.combinedNextNode = node;
    }

    public StateNode getChild(InteractionFragmentKey key) {
        return this.children.get(key);
    }
}

