/*
 * Decompiled with CFR 0.152.
 */
package musd.compiler.stringutils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import musd.compiler.interaction2aspect.ImmidiateEventsTree;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangeCutStringGen {
    private static final int MAX_CASE = 7;

    public static String getChangeCutForConstructors(String oldState, String TargetConstant, String newState, HashSet<String> finalStates, String varCheck, String varsSet, ImmidiateEventsTree tree) {
        StringBuffer str = new StringBuffer(100);
        str.append("\t\t\t\tif(");
        str.append(ChangeCutStringGen.getInstanceEquals(TargetConstant, "null")).append("\n\t\t\t\t\t&& ");
        str.append("activeMUSD").append(".isInCut(").append(oldState).append(")");
        str.append(varCheck).append(")\n\t\t\t\t{\n");
        str.append("\t\t\t\t\t").append(ChangeCutStringGen.getInstanceSetter(TargetConstant, "targetObject")).append(";\n");
        str.append(varsSet);
        str.append(ChangeCutStringGen.addBranchBody(newState, finalStates, tree));
        return str.toString();
    }

    public static String getChangeCutForSmallConstructorsSenderUnified(String oldState, String sourceConstant) {
        StringBuffer str = new StringBuffer(100);
        str.append("\t\t\t\tif(");
        str.append(ChangeCutStringGen.getInstanceEquals(sourceConstant, "sourceObject")).append("\n\t\t\t\t\t&& ");
        str.append("activeMUSD").append(".isInCut(").append(oldState).append(")");
        str.append(")\n\t\t\t\t{\n\t\t\t\t\t");
        str.append(ChangeCutStringGen.getSetCut(oldState)).append("\t\t\t\t\treturn;\n\t\t\t\t}\n");
        return str.toString();
    }

    public static String getChangeCutForSmallConstructorsSenderNotUnified(String oldState, String sourceConstant) {
        StringBuffer str = new StringBuffer(100);
        str.append("\t\t\t\tif(");
        str.append("activeMUSD").append(".isInCut(").append(oldState).append(")");
        str.append(")\n\t\t\t\t{\n\t\t\t\t\t");
        str.append(ChangeCutStringGen.getInstanceSetter(sourceConstant, "sourceObject"));
        str.append(";\n\t\t\t\t\t").append(ChangeCutStringGen.getSetCut(oldState));
        str.append("\t\t\t\t\treturn;\n\t\t\t\t}\n");
        return str.toString();
    }

    public static String getChangeCutForSrcAndTargetUni(String oldState, String sourceConstant, String TargetConstant, String newState, HashSet<String> finalStates, String varCheck, String varsSet, ImmidiateEventsTree tree) {
        StringBuffer str = new StringBuffer(100);
        str.append("\t\t\t\tif(");
        if (!sourceConstant.equals("env")) {
            str.append(ChangeCutStringGen.getInstanceEquals(sourceConstant, "sourceObject")).append("\n\t\t\t\t\t&& ");
        }
        str.append(ChangeCutStringGen.getInstanceEquals(TargetConstant, "targetObject"));
        str.append("\n\t\t\t\t\t&& ").append("activeMUSD").append(".isInCut(").append(oldState).append(")");
        str.append(varCheck).append(")\n\t\t\t\t{\n");
        str.append(varsSet);
        str.append(ChangeCutStringGen.addBranchBody(newState, finalStates, tree));
        return str.toString();
    }

    public static String getChangeCutForTargetUni(String oldState, String sourceConstant, String TargetConstant, String newState, HashSet<String> finalStates, String varCheck, String varsSet, ImmidiateEventsTree tree) {
        StringBuffer str = new StringBuffer(100);
        str.append("\t\t\t\tif(").append(ChangeCutStringGen.getInstanceEquals(TargetConstant, "targetObject"));
        str.append("\n\t\t\t\t\t&& ").append("activeMUSD").append(".isInCut(").append(oldState);
        str.append(")\n\t\t\t\t\t&& ").append(ChangeCutStringGen.getInstanceEquals(sourceConstant, "null"));
        str.append(varCheck).append(")\n\t\t\t\t{\n");
        str.append("\t\t\t\t\t").append(ChangeCutStringGen.getInstanceSetter(sourceConstant, "sourceObject"));
        str.append(";\n");
        str.append(varsSet);
        str.append(ChangeCutStringGen.addBranchBody(newState, finalStates, tree));
        return str.toString();
    }

    public static String getChangeCutForSrcUni(String oldState, String sourceConstant, String TargetConstant, String newState, HashSet<String> finalStates, String varCheck, String varsSet, ImmidiateEventsTree tree) {
        StringBuffer str = new StringBuffer(100);
        str.append("\t\t\t\tif(");
        if (!sourceConstant.equals("env")) {
            str.append(ChangeCutStringGen.getInstanceEquals(sourceConstant, "sourceObject")).append("\n\t\t\t\t\t&& ");
        }
        str.append(ChangeCutStringGen.getInstanceEquals(TargetConstant, "null")).append("\n\t\t\t\t\t&& ");
        str.append("activeMUSD").append(".isInCut(").append(oldState).append(")");
        str.append(varCheck).append(")\n\t\t\t\t{\n");
        str.append("\t\t\t\t\t").append(ChangeCutStringGen.getInstanceSetter(TargetConstant, "targetObject")).append(";\n");
        str.append(varsSet);
        str.append(ChangeCutStringGen.addBranchBody(newState, finalStates, tree));
        return str.toString();
    }

    public static String getChangeCutNoUni(String oldState, String sourceConstant, String TargetConstant, String newState, HashSet<String> finalStates, String varCheck, String varsSet, ImmidiateEventsTree tree) {
        StringBuffer str = new StringBuffer(100);
        str.append("\t\t\t\tif(").append(ChangeCutStringGen.getInstanceEquals(TargetConstant, "null"));
        str.append("\n\t\t\t\t\t&& ").append(ChangeCutStringGen.getInstanceEquals(sourceConstant, "null"));
        str.append("\n\t\t\t\t\t&& ").append("activeMUSD").append(".isInCut(");
        str.append(oldState).append(")").append(varCheck).append(")\n\t\t\t\t{\n");
        str.append("\t\t\t\t\t").append(ChangeCutStringGen.getInstanceSetter(TargetConstant, "targetObject")).append(";\n");
        if (!sourceConstant.equals(TargetConstant)) {
            str.append("\t\t\t\t\t").append(ChangeCutStringGen.getInstanceSetter(sourceConstant, "sourceObject")).append(";\n");
        }
        str.append(varsSet);
        str.append(ChangeCutStringGen.addBranchBody(newState, finalStates, tree));
        return str.toString();
    }

    private static String addBranchBody(String newState, HashSet<String> finalStates, ImmidiateEventsTree tree) {
        StringBuffer str = new StringBuffer();
        StringBuffer ident = new StringBuffer("\t\t\t\t\t");
        if (!tree.isEmpty()) {
            str.append(ChangeCutStringGen.getTreeEvaluation(tree.getRoot(), ident, finalStates));
        } else {
            str.append("\t\t\t\t\t").append(ChangeCutStringGen.getSetCut(newState));
            if (!finalStates.contains(newState)) {
                str.append("\t\t\t\t").append("\treturn;\n");
            } else {
                str.append("\t\t\t\t").append("\tbreak;\n");
            }
        }
        str.append("\t\t\t\t}\n");
        return str.toString();
    }

    static String getTreeEvaluation(ImmidiateEventsTree.ImmidiateEventsTreeNode node, StringBuffer ident, HashSet<String> finalStates) {
        StringBuffer str = new StringBuffer(100);
        StringBuffer realIdent = new StringBuffer(ident);
        Iterator<ImmidiateEventsTree.ImmidiateEventsTreeNode> it = node.getChildren().iterator();
        ImmidiateEventsTree tree = node.getTree();
        int childNumber = 0;
        while (it.hasNext()) {
            ImmidiateEventsTree.ImmidiateEventsTreeNode child = it.next();
            int stringId = tree.getStringId(child.getId());
            String oldState = tree.getBeforeConstraintStates().get(child.getId());
            String newState = tree.getAfterConstraintStates().get(child.getId());
            if (childNumber == 0) {
                str.append(realIdent).append(ChangeCutStringGen.getSetCut(oldState));
            }
            str.append(ChangeCutStringGen.getConstraintExpressions(stringId, realIdent.toString()));
            str.append(realIdent).append("\t").append(ChangeCutStringGen.getSetCut(newState));
            str.append(ChangeCutStringGen.getTreeEvaluation(child, ident.append("\t"), finalStates));
            if (!child.hasChildren() && !finalStates.contains(newState)) {
                str.append(realIdent).append("\t").append("return;\n");
            } else if (finalStates.contains(newState)) {
                str.append(realIdent).append("\t").append("break;\n");
            }
            str.append(realIdent).append("}\n");
            if (child.isLastGuard()) {
                String cut = node.getNextCut();
                str.append(realIdent).append(ChangeCutStringGen.getSetCut(cut));
                if (!it.hasNext() && !finalStates.contains(cut)) {
                    str.append(realIdent).append("return;\n");
                } else if (finalStates.contains(cut)) {
                    str.append(realIdent).append("break;\n");
                }
            }
            if (!child.isGuard()) {
                str.append(realIdent).append("break;\n");
            }
            ++childNumber;
        }
        return str.toString();
    }

    private static String getSetCut(String newState) {
        StringBuffer str = new StringBuffer();
        str.append("activeMUSD").append(".setCut(").append(newState).append(");\n");
        return str.toString();
    }

    private static String getConstraintExpressions(int id, String ident) {
        StringBuffer str = new StringBuffer();
        str.append(ident).append("if(").append("evaluateCondition");
        str.append("(").append(id).append(",").append("activeMUSD");
        str.append("))\n").append(ident).append("{\n");
        return str.toString();
    }

    public static String generateEvaluateCondition(String inits, HashMap<Integer, String> condNumberToCondExpression, HashMap<String, ArrayList<Integer>> repetitionMap) {
        StringBuffer str = new StringBuffer(200);
        str.append("\t").append("@SuppressWarnings(\"unused\")");
        str.append("\n\tprivate boolean ").append("evaluateCondition");
        str.append("(int ").append("conditionNumber").append(",").append("ActiveMUSDAspect");
        str.append(" ").append("activeMUSD").append(")\n\t{\n");
        str.append(inits).append("\t\tswitch (").append("conditionNumber").append(")\n\t\t{\n");
        for (Integer i : condNumberToCondExpression.keySet()) {
            int count = 0;
            String expression = condNumberToCondExpression.get(i);
            str.append("\t\t\tcase ").append(i).append(": ");
            Iterator<Integer> repIt = repetitionMap.get(expression).iterator();
            while (repIt.hasNext()) {
                if (++count % 7 == 0) {
                    str.append("\n\t\t\t");
                }
                str.append("case ").append(repIt.next()).append(": ");
            }
            str.append("\n\t\t\t\treturn ");
            str.append(expression).append(";\n");
        }
        str.append("\t\t}\n\t\treturn false;\n\t}\n\n");
        return str.toString();
    }

    public static String generateChangeCutStateCloser() {
        StringBuffer str = new StringBuffer();
        str.append("\t\t\t}\n\t\tif(").append("activeMUSD.checkViolation()");
        str.append(")\n\t\t\t").append("activeMUSD");
        str.append(".completion();\n\t}\n\n");
        return str.toString();
    }

    public static String getLoopEvaluation(int id) {
        return "activeMUSD.countLoop(" + id + ")";
    }

    static String getInstanceEquals(String cons, String obj) {
        return "activeMUSD.instancesEquals(" + cons + "," + obj + ")";
    }

    static String getInstanceGetter(String constant) {
        return "activeMUSD.getLineInstance(" + constant + ")";
    }

    static String getInstanceSetter(String constant, String obj) {
        return "activeMUSD.setLineInstance(" + constant + "," + obj + ")";
    }
}

