/*
 * Decompiled with CFR 0.152.
 */
package musd.compiler.lib;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Stack;
import musd.compiler.lib.CombinedObject;
import musd.compiler.lib.CutState;
import musd.compiler.lib.InteractionFragmentKey;
import musd.compiler.lib.MUSDArgument;
import musd.compiler.lib.MUSDCombinedFragment;
import musd.compiler.lib.MUSDConstraint;
import musd.compiler.lib.MUSDInteraction;
import musd.compiler.lib.MUSDInteractionFragment;
import musd.compiler.lib.MUSDInteractionGuard;
import musd.compiler.lib.MUSDLifeLine;
import musd.compiler.lib.MUSDMessage;
import musd.compiler.lib.StateNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InteractionGraph {
    private MUSDInteraction refferedInteraction;
    private ArrayList<InteractionFragmentKey> fragmentOrderedList;
    private StateNode root;
    private HashMap<InteractionFragmentKey, CutState> keyToEnabledProjectedCutState;

    public InteractionGraph(MUSDInteraction interaction) {
        this.refferedInteraction = interaction;
        this.fragmentOrderedList = interaction.getFragmentsOrderedList();
        this.keyToEnabledProjectedCutState = this.processListOfFragments();
        this.root = this.createStateNode(new HashSet<InteractionFragmentKey>(), new CutState(this.refferedInteraction.getCoveredLines()), null, new Stack<CombinedObject>(), "");
    }

    private HashMap<InteractionFragmentKey, CutState> processListOfFragments() {
        HashMap<InteractionFragmentKey, CutState> map = new HashMap<InteractionFragmentKey, CutState>();
        Iterator<InteractionFragmentKey> it = this.fragmentOrderedList.iterator();
        CutState curCut = new CutState(this.refferedInteraction.getCoveredLines());
        while (it.hasNext()) {
            InteractionFragmentKey key = it.next();
            CutState newCut = this.getNewCutState(key, curCut);
            map.put(key, newCut);
        }
        return map;
    }

    private CutState getNewCutState(InteractionFragmentKey key, CutState allCut) {
        CutState newCut = new CutState();
        Iterator<MUSDLifeLine> it = key.getCoveredLifelines().iterator();
        while (it.hasNext()) {
            String name = it.next().getName();
            int i = (Integer)allCut.get(name);
            newCut.put(name, new Integer(++i));
            allCut.put(name, new Integer(i));
        }
        return newCut;
    }

    private boolean isViolation(InteractionFragmentKey key, CutState cutState) {
        CutState newCut = this.keyToEnabledProjectedCutState.get(key);
        Iterator it = newCut.keySet().iterator();
        boolean equals = true;
        while (it.hasNext()) {
            int new_;
            String name = (String)it.next();
            int old = (Integer)cutState.get(name);
            if (old != (new_ = ((Integer)newCut.get(name)).intValue())) {
                equals = false;
            }
            if (new_ - old >= 0 && new_ - old <= 1) continue;
            return true;
        }
        return equals;
    }

    private StateNode createStateNode(HashSet<InteractionFragmentKey> occuredInterKeys, CutState cutState, StateNode parent, Stack<CombinedObject> combindObjectStack, String ident) {
        StateNode curNode = new StateNode(cutState, parent);
        HashSet<InteractionFragmentKey> minimalEvents = this.getMinimalEvents(occuredInterKeys, cutState);
        if (minimalEvents.isEmpty()) {
            return curNode;
        }
        Iterator<InteractionFragmentKey> it = minimalEvents.iterator();
        while (it.hasNext()) {
            HashSet<InteractionFragmentKey> tempOccuredInterKeys = new HashSet<InteractionFragmentKey>(occuredInterKeys);
            InteractionFragmentKey key = it.next();
            tempOccuredInterKeys.add(key);
            this.updateNodeTemperature(key, curNode);
            if (MUSDCombinedFragment.isCombined(this.getFragment(key))) {
                this.buildCombinedFragmentSection(key, combindObjectStack, curNode, tempOccuredInterKeys, String.valueOf(ident) + "\t");
                continue;
            }
            if (!combindObjectStack.isEmpty() && combindObjectStack.peek().isKeyLastInCurOperand(key)) {
                this.handleLastOperandsEvent(key, curNode, combindObjectStack.peek());
                continue;
            }
            CutState nextCut = this.getNextCutState(key, cutState);
            StateNode tempNode = this.createStateNode(tempOccuredInterKeys, nextCut, curNode, combindObjectStack, String.valueOf(ident) + "\t");
            curNode.addChild(key, tempNode);
        }
        return curNode;
    }

    private void handleLastOperandsEvent(InteractionFragmentKey key, StateNode currentNode, CombinedObject comb) {
        CutState nextCut = this.getNextCutState(key, currentNode.getCutState());
        StateNode dummyNode = new StateNode(nextCut, currentNode);
        comb.lastCut = nextCut;
        comb.dummyNodes.add(dummyNode);
        currentNode.addDummyChild(dummyNode, key);
    }

    private void buildCombinedFragmentSection(InteractionFragmentKey key, Stack<CombinedObject> combinedObjectStack, StateNode currentNode, HashSet<InteractionFragmentKey> occuredInterKeys, String ident) {
        MUSDCombinedFragment combined = (MUSDCombinedFragment)this.getFragment(key);
        CombinedObject combinedObject = new CombinedObject(this.refferedInteraction, combined, this.getNextCutState(key, currentNode.getCutState()));
        combinedObjectStack.push(combinedObject);
        ArrayList<MUSDInteractionGuard> guardList = combined.getAllGuards();
        Iterator<MUSDInteractionGuard> it = guardList.iterator();
        currentNode.addCombinedFragment(combined);
        while (it.hasNext()) {
            MUSDInteractionGuard guard = it.next();
            InteractionFragmentKey guardKey = new InteractionFragmentKey(false, true, combined.getCoveredLines());
            this.putFragment(guardKey, guard);
            currentNode.addCombinedFragmentGuard(combined, guardKey);
            StateNode nextNode = this.createStateNode(occuredInterKeys, combinedObject.getLastCut(), currentNode, combinedObjectStack, String.valueOf(ident) + "\t");
            currentNode.addChild(guardKey, nextNode);
            combinedObject.nextOperand();
            combinedObject.setFirstNode(nextNode);
        }
        combinedObjectStack.pop();
        int last = combinedObject.dummyNodes.size() - 1;
        StateNode parent = combinedObject.dummyNodes.get(last).getParent();
        combinedObject.realLastNode = this.createStateNode(occuredInterKeys, combinedObject.getLastCut(), parent, combinedObjectStack, ident);
        currentNode.setCombinedNextCut(combinedObject.getRealLastCutState());
        currentNode.setCombinedNextNode(combinedObject.getRealLastNode());
        this.handleDummyNode(combinedObject);
        if (this.getFragment((InteractionFragmentKey)key).type == 6) {
            this.handleLastLoopNode(combinedObject);
        }
    }

    private void handleDummyNode(CombinedObject combObject) {
        ArrayList<StateNode> list = combObject.dummyNodes;
        for (StateNode node : list) {
            StateNode parent = node.getParent();
            InteractionFragmentKey key = parent.getDummyKey(node);
            parent.addChild(key, combObject.realLastNode);
        }
    }

    private void handleLastLoopNode(CombinedObject object) {
        MUSDCombinedFragment combined = object.currentCombFragment;
        MUSDInteractionGuard guard = combined.getAllGuards().get(0);
        InteractionFragmentKey guardKey = new InteractionFragmentKey(false, true, combined.getCoveredLines());
        this.putFragment(guardKey, guard);
        StateNode lastNode = object.realLastNode;
        lastNode.addCombinedFragment(combined);
        lastNode.addCombinedFragmentGuard(combined, guardKey);
        lastNode.addChild(guardKey, object.getFirstNode());
        lastNode.setCombinedNextCut(object.getRealLastCutState());
        lastNode.setCombinedNextNode(object.getRealLastNode());
    }

    private void updateNodeTemperature(InteractionFragmentKey key, StateNode node) {
        if (key.isHot()) {
            node.setHot(true);
        }
        if (key.isExecute()) {
            node.setExecute(true);
        }
    }

    private CutState getNextCutState(InteractionFragmentKey key, CutState cutState) {
        CutState tempCut = new CutState(cutState);
        Iterator<MUSDLifeLine> it = key.getCoveredLifelines().iterator();
        while (it.hasNext()) {
            String name = it.next().getName();
            int state = (Integer)cutState.get(name);
            tempCut.put(name, new Integer(++state));
        }
        return tempCut;
    }

    private HashSet<InteractionFragmentKey> getMinimalEvents(HashSet<InteractionFragmentKey> occuredInterKeys, CutState cutState) {
        HashSet<InteractionFragmentKey> min = new HashSet<InteractionFragmentKey>(this.fragmentOrderedList);
        for (InteractionFragmentKey key : this.fragmentOrderedList) {
            if (!occuredInterKeys.contains(key) && !this.isViolation(key, cutState)) continue;
            min.remove(key);
        }
        return min;
    }

    private MUSDInteractionFragment getFragment(InteractionFragmentKey key) {
        return this.refferedInteraction.getInterKeyToInterFragments().get(key);
    }

    private void putFragment(InteractionFragmentKey key, MUSDInteractionFragment frag) {
        this.refferedInteraction.getInterKeyToInterFragments().put(key, frag);
    }

    public StateNode getRoot() {
        return this.root;
    }

    public void printGraph() {
        System.out.println("Printing Graph for interaction:" + this.refferedInteraction.getName() + "\n");
        StateNode root = this.root;
        HashMap<StateNode, Integer> isVisited = new HashMap<StateNode, Integer>();
        this.printSubGraph(root, isVisited, "");
        System.out.println("\n\n\n\n\n\n");
    }

    private void printSubGraph(StateNode node, HashMap<StateNode, Integer> isVisited, String ident) {
        this.printNode(ident, node);
        HashMap<InteractionFragmentKey, StateNode> map = node.getChildren();
        int i = -1;
        if (isVisited.get(node) != null) {
            i = isVisited.get(node);
        }
        isVisited.put(node, ++i);
        if (map == null || map.isEmpty()) {
            System.out.println("****** End Of one Sub Trace;****************");
            return;
        }
        Iterator<InteractionFragmentKey> it = map.keySet().iterator();
        ident = String.valueOf(ident) + "    ";
        while (it.hasNext()) {
            InteractionFragmentKey key = it.next();
            StateNode curNode = map.get(key);
            this.printInterKey(key);
            if (isVisited.get(curNode) != null && isVisited.get(curNode) >= 1) continue;
            this.printSubGraph(curNode, isVisited, ident);
        }
    }

    private void printInterKey(InteractionFragmentKey key) {
        StringBuffer str = new StringBuffer();
        MUSDInteractionFragment interFrag = this.getFragment(key);
        if (interFrag.getType() == 0) {
            str.append("Method named: ");
            MUSDMessage mes = (MUSDMessage)this.getFragment(key);
            str.append(String.valueOf(mes.getName()) + " sender is:" + mes.getSender().getName() + ". reciever is: " + mes.getReciever().getName());
            if (mes.hasArguments()) {
                Iterator<Object> it = mes.getArguments().iterator();
                int j = 0;
                while (it.hasNext()) {
                    str.append(" arg").append(j).append(": ");
                    str.append(((MUSDArgument)it.next()).getStringValue());
                    ++j;
                }
            }
        }
        if (interFrag.getType() == 1) {
            str.append("Constraint: ");
            MUSDConstraint con = (MUSDConstraint)this.getFragment(key);
            str.append(", expressions: ");
            for (String s : con.getExpression()) {
                str.append(String.valueOf(s) + " ");
            }
            Iterator<MUSDLifeLine> it2 = con.getCoveredLines().iterator();
            str.append(". covered lifeLines: ");
            while (it2.hasNext()) {
                str.append(String.valueOf(it2.next().getName()) + " , ");
            }
        }
        if (interFrag.type == 3) {
            str.append("GuardCondition: ");
            MUSDInteractionGuard guard = (MUSDInteractionGuard)this.getFragment(key);
            str.append(",expressions: ");
            for (String s : guard.getExpression()) {
                str.append(String.valueOf(s) + " ");
            }
            Iterator<MUSDLifeLine> it2 = guard.getCoveredLines().iterator();
            str.append(". the guard covers: ");
            while (it2.hasNext()) {
                str.append(String.valueOf(it2.next().getName()) + " , ");
            }
        }
        System.out.println(str.toString());
    }

    private void printNode(String ident, StateNode node) {
        StringBuffer str = new StringBuffer("node cut state:  ");
        for (String s : node.getCutState().keySet()) {
            Integer i = (Integer)node.getCutState().get(s);
            str.append(" " + s + " is in cut: " + i + " ");
        }
        System.out.println(String.valueOf(ident) + str.toString());
    }

    public void printList(String id, HashSet<InteractionFragmentKey> set) {
        this.printList(id, new ArrayList<InteractionFragmentKey>(set));
    }

    public void printList(String id, ArrayList<InteractionFragmentKey> list) {
        Iterator<InteractionFragmentKey> it = list.iterator();
        System.out.print(id);
        while (it.hasNext()) {
            InteractionFragmentKey key = it.next();
            this.printInterKey(key);
            CutState state = this.keyToEnabledProjectedCutState.get(key);
            System.out.println(" state is: " + state);
        }
    }
}

