/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.uml.internal.operations;

import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.RedefinableElement;
import org.eclipse.uml2.uml.UMLPlugin;
import org.eclipse.uml2.uml.internal.operations.NamedElementOperations;

public class RedefinableElementOperations
extends NamedElementOperations {
    protected RedefinableElementOperations() {
    }

    public static boolean validateRedefinitionContextValid(RedefinableElement redefinableElement, DiagnosticChain diagnostics, Map context) {
        boolean result = true;
        Iterator redefinedElements = redefinableElement.getRedefinedElements().iterator();
        while (redefinedElements.hasNext()) {
            RedefinableElement redefinedElement = (RedefinableElement)redefinedElements.next();
            if (redefinableElement.isRedefinitionContextValid(redefinedElement)) continue;
            result = false;
            if (diagnostics == null) {
                return result;
            }
            diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.uml2.uml", 24, UMLPlugin.INSTANCE.getString("_UI_RedefinableElement_RedefinitionContextValid_diagnostic", RedefinableElementOperations.getMessageSubstitutions((Map)context, (Object)redefinableElement, (Object)redefinedElement)), new Object[]{redefinableElement, redefinedElement}));
        }
        return result;
    }

    public static boolean validateRedefinitionConsistent(RedefinableElement redefinableElement, DiagnosticChain diagnostics, Map context) {
        boolean result = true;
        Iterator redefinedElements = redefinableElement.getRedefinedElements().iterator();
        while (redefinedElements.hasNext()) {
            RedefinableElement redefinedElement = (RedefinableElement)redefinedElements.next();
            if (redefinedElement.isConsistentWith(redefinableElement)) continue;
            result = false;
            if (diagnostics == null) {
                return result;
            }
            diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.uml2.uml", 25, UMLPlugin.INSTANCE.getString("_UI_RedefinableElement_RedefinitionConsistent_diagnostic", RedefinableElementOperations.getMessageSubstitutions((Map)context, (Object)redefinableElement, (Object)redefinedElement)), new Object[]{redefinableElement, redefinedElement}));
        }
        return result;
    }

    public static boolean isRedefinitionContextValid(RedefinableElement redefinableElement, RedefinableElement redefinable) {
        EList redefinableRedefinitionContexts = redefinable.getRedefinitionContexts();
        Iterator redefinitionContexts = redefinableElement.getRedefinitionContexts().iterator();
        while (redefinitionContexts.hasNext()) {
            EList redefinitionContextAllParents = ((Classifier)redefinitionContexts.next()).allParents();
            Iterator rrc = redefinableRedefinitionContexts.iterator();
            while (rrc.hasNext()) {
                Classifier redefinableRedefinitionContext = (Classifier)rrc.next();
                if (!redefinitionContextAllParents.contains((Object)redefinableRedefinitionContext)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isConsistentWith(RedefinableElement redefinableElement, RedefinableElement redefinee) {
        return false;
    }
}

