/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.common.util;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class CacheAdapter
extends ECrossReferenceAdapter {
    public static final CacheAdapter INSTANCE = new CacheAdapter();
    private final Map values = Collections.synchronizedMap(new HashMap());
    protected boolean adapting = false;
    static /* synthetic */ Class class$0;

    public static CacheAdapter getCacheAdapter(Notifier notifier) {
        EList eAdapters = notifier.eAdapters();
        int i = 0;
        int size = eAdapters.size();
        while (i < size) {
            Object adapter = eAdapters.get(i);
            if (adapter instanceof CacheAdapter) {
                return (CacheAdapter)((Object)adapter);
            }
            ++i;
        }
        return null;
    }

    protected boolean addAdapter(EList adapters) {
        return adapters.contains((Object)this) ? false : adapters.add((Object)this);
    }

    public boolean adapt(Notifier notifier) {
        boolean result = false;
        if (notifier != null) {
            this.adapting = true;
            result = this.addAdapter(notifier.eAdapters());
            this.adapting = false;
        }
        return result;
    }

    protected void addAdapter(Notifier notifier) {
        this.addAdapter(notifier.eAdapters());
    }

    protected void addAdapter(EObject eObject) {
        if (eObject != null && !eObject.eIsProxy()) {
            Resource eResource = eObject.eResource();
            if (eResource == null) {
                this.addAdapter(EcoreUtil.getRootContainer((EObject)eObject).eAdapters());
            } else {
                ResourceSet resourceSet = eResource.getResourceSet();
                if (resourceSet == null) {
                    this.addAdapter(eResource.eAdapters());
                } else {
                    this.addAdapter(resourceSet.eAdapters());
                }
            }
        }
    }

    public Collection getNonNavigableInverseReferences(EObject eObject) {
        this.addAdapter(eObject);
        return super.getNonNavigableInverseReferences(eObject);
    }

    public Collection getInverseReferences(EObject eObject) {
        this.addAdapter(eObject);
        return super.getInverseReferences(eObject);
    }

    public void handleCrossReference(EObject eObject) {
        this.inverseCrossReferencer.add(eObject);
    }

    public void setTarget(Notifier target) {
        if (!this.adapting) {
            super.setTarget(target);
        }
    }

    protected void unsetTarget(EObject target) {
        super.unsetTarget(target);
        this.clear(target.eResource());
    }

    protected void unsetTarget(Resource target) {
        super.unsetTarget(target);
        this.clear(target);
    }

    public void notifyChanged(Notification msg) {
        super.notifyChanged(msg);
        Object notifier = msg.getNotifier();
        if (notifier instanceof EObject) {
            this.clear(((EObject)notifier).eResource());
        } else if (notifier instanceof Resource) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.emf.ecore.resource.Resource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (msg.getFeatureID((Class)clazz) == 2) {
                this.clear();
            }
        }
    }

    public void clear() {
        this.values.clear();
    }

    public void clear(Resource resource) {
        this.values.remove(resource);
        if (resource != null) {
            this.values.remove(null);
        }
    }

    public boolean containsKey(EObject eObject, Object key) {
        return this.containsKey(null, eObject, key);
    }

    public boolean containsKey(Resource resource, EObject eObject, Object key) {
        Map eObjectMap;
        Map resourceMap = (Map)this.values.get(resource);
        if (resourceMap != null && (eObjectMap = (Map)resourceMap.get(eObject)) != null) {
            return eObjectMap.containsKey(key);
        }
        return false;
    }

    public Object get(EObject eObject, Object key) {
        return this.get(null, eObject, key);
    }

    public Object get(Resource resource, EObject eObject, Object key) {
        Map eObjectMap;
        Map resourceMap = (Map)this.values.get(resource);
        if (resourceMap != null && (eObjectMap = (Map)resourceMap.get(eObject)) != null) {
            return eObjectMap.get(key);
        }
        return null;
    }

    public Object put(EObject eObject, Object key, Object value) {
        return this.put(null, eObject, key, value);
    }

    public Object put(Resource resource, EObject eObject, Object key, Object value) {
        HashMap<Object, Object> eObjectMap;
        if (key == null) {
            throw new IllegalArgumentException(String.valueOf(key));
        }
        HashMap<EObject, HashMap<Object, Object>> resourceMap = (HashMap<EObject, HashMap<Object, Object>>)this.values.get(resource);
        if (resourceMap == null) {
            resourceMap = new HashMap<EObject, HashMap<Object, Object>>();
            this.values.put(resource, resourceMap);
        }
        if ((eObjectMap = (HashMap<Object, Object>)resourceMap.get(eObject)) == null) {
            eObjectMap = new HashMap<Object, Object>();
            resourceMap.put(eObject, eObjectMap);
        }
        return eObjectMap.put(key, value);
    }

    protected boolean resolve() {
        return false;
    }
}

