/*
 * Decompiled with CFR 0.152.
 */
package musd.runtime.lib;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import musd.runtime.lib.MUSDAspect;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.NoAspectBoundException;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Aspect
public class MUSDMonitor {
    private static final String PROPERTIES_FILE_NAME = "musdmonitor.properties";
    private static final String MONITOR_LEVEL = "monitorLevel";
    private static final String MONITOR_OUTPUT = "monitorOutput";
    private static final String TO_MONITOR_INTERACTIONS = "interactions";
    private static final String APPEND = "append";
    private static int monitorLevel;
    private static String monitorOutput;
    private static PrintWriter out;
    private static String[] toMonitorInterations;
    private static boolean append;
    private static /* synthetic */ Throwable ajc$initFailureCause;
    public static final /* synthetic */ MUSDMonitor ajc$perSingletonInstance;

    static {
        try {
            monitorLevel = 0;
            append = true;
            MUSDMonitor.ajc$perSingletonInstance = new MUSDMonitor();
        }
        catch (Throwable throwable) {
            ajc$initFailureCause = throwable;
        }
    }

    MUSDMonitor() {
        File file = new File(PROPERTIES_FILE_NAME);
        if (file.isFile()) {
            Properties properties = new Properties();
            try {
                FileInputStream in = new FileInputStream(PROPERTIES_FILE_NAME);
                properties.load(in);
                monitorLevel = Integer.parseInt(properties.getProperty(MONITOR_LEVEL));
                monitorOutput = properties.getProperty(MONITOR_OUTPUT);
                toMonitorInterations = properties.getProperty(TO_MONITOR_INTERACTIONS).split(";");
                String appendString = properties.getProperty(APPEND);
                if (appendString != null && appendString.trim().equals("false")) {
                    append = false;
                }
                out = new PrintWriter(new FileWriter(monitorOutput, append));
            }
            catch (NumberFormatException e) {
                monitorLevel = 0;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private boolean isInteractionLogged(String interName) {
        if (toMonitorInterations == null || toMonitorInterations.length == 0) {
            return false;
        }
        if (toMonitorInterations[0].equals("*")) {
            return true;
        }
        String s = this.getInteractionName(interName);
        int i = 0;
        while (i < toMonitorInterations.length) {
            if (toMonitorInterations[i].trim().equals(s)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private String getInteractionName(String name) {
        int last = name.lastIndexOf(".");
        if (last == -1) {
            return name;
        }
        return name.substring(last + ".MUSDAspect".length());
    }

    @Pointcut(value="(execution(musd.runtime.lib.MUSDAspect.new(..)) && (target(musdAspect) && if(void java.lang.Object.if_())))", argNames="musdAspect")
    /* synthetic */ void ajc$pointcut$$aspectStaticCreation$8ad(MUSDAspect musdAspect) {
    }

    @After(value="aspectStaticCreation(musdAspect)", argNames="musdAspect")
    public void ajc$after$musd_runtime_lib_MUSDMonitor$1$cd0c23d5(MUSDAspect musdAspect) {
        String name = musdAspect.getClass().getName();
        if (this.isInteractionLogged(name)) {
            this.out(String.valueOf(this.getInteractionName(name)) + " Static initialization.");
        }
    }

    @Pointcut(value="(execution(musd.runtime.lib.MUSDAspect$ActiveMUSDAspect.new(..)) && (target(activeMUSD) && if(void java.lang.Object.if_())))", argNames="activeMUSD")
    /* synthetic */ void ajc$pointcut$$activeAspectCreation$a15(MUSDAspect.ActiveMUSDAspect activeMUSD) {
    }

    @After(value="activeAspectCreation(activeMUSD)", argNames="activeMUSD")
    public void ajc$after$musd_runtime_lib_MUSDMonitor$2$6c8c455f(MUSDAspect.ActiveMUSDAspect activeMUSD, JoinPoint thisJoinPoint) {
        String name = activeMUSD.getOwner().getClass().getName();
        if (this.isInteractionLogged(name)) {
            Integer num = (Integer)thisJoinPoint.getArgs()[1];
            long id = activeMUSD.getId();
            StringBuffer str = new StringBuffer();
            str.append(name).append("[").append(id).append("] (0");
            int i = 1;
            while (i < num) {
                str.append(",0");
                ++i;
            }
            str.append(")");
            this.out(str.toString());
        }
    }

    @Pointcut(value="(execution(void musd.runtime.lib.MUSDAspect$ActiveMUSDAspect._setCut(..)) && (args(setLocations) && (target(activeMUSD) && if(void java.lang.Object.if_()))))", argNames="setLocations,activeMUSD")
    /* synthetic */ void ajc$pointcut$$setCut$cb4(ArrayList<Integer> setLocations, MUSDAspect.ActiveMUSDAspect activeMUSD) {
    }

    @After(value="setCut(setLocations, activeMUSD)", argNames="setLocations,activeMUSD")
    public void ajc$after$musd_runtime_lib_MUSDMonitor$3$efca0fd2(ArrayList<Integer> setLocations, MUSDAspect.ActiveMUSDAspect activeMUSD) {
        String name = activeMUSD.getOwner().getClass().getName();
        if (this.isInteractionLogged(name)) {
            long id = activeMUSD.getId();
            StringBuffer str = new StringBuffer();
            Iterator<Integer> it = setLocations.iterator();
            str.append(name).append("[").append(id).append("] (");
            boolean first = true;
            while (it.hasNext()) {
                if (first) {
                    str.append(it.next());
                } else {
                    str.append(",").append(it.next());
                }
                first = false;
            }
            str.append(")");
            this.out(str.toString());
        }
    }

    @Pointcut(value="(execution(void musd.runtime.lib.MUSDAspect$ActiveMUSDAspect.completion()) && (target(activeMUSD) && if(void java.lang.Object.if_())))", argNames="activeMUSD")
    /* synthetic */ void ajc$pointcut$$activeCompleted$101a(MUSDAspect.ActiveMUSDAspect activeMUSD) {
    }

    @After(value="activeCompleted(activeMUSD)", argNames="activeMUSD")
    public void ajc$after$musd_runtime_lib_MUSDMonitor$4$3cd82f47(MUSDAspect.ActiveMUSDAspect activeMUSD) {
        String name = activeMUSD.getOwner().getClass().getName();
        if (this.isInteractionLogged(name)) {
            long id = activeMUSD.getId();
            StringBuffer str = new StringBuffer();
            str.append(name).append("[").append(id).append("] Completed.");
            this.out(str.toString());
        }
    }

    private void out(String s) {
        out.print(String.valueOf(System.currentTimeMillis()) + " ");
        out.println(s);
        out.flush();
    }

    public static final boolean ajc$if_60(MUSDAspect musdAspect) {
        return monitorLevel > 0;
    }

    public static final boolean ajc$if_61(MUSDAspect.ActiveMUSDAspect activeMUSD) {
        return monitorLevel > 0;
    }

    public static final boolean ajc$if_62(ArrayList<Integer> setLocations, MUSDAspect.ActiveMUSDAspect activeMUSD) {
        return monitorLevel > 0;
    }

    public static final boolean ajc$if_63(MUSDAspect.ActiveMUSDAspect activeMUSD) {
        return monitorLevel > 0;
    }

    public static MUSDMonitor aspectOf() {
        if (ajc$perSingletonInstance == null) {
            throw new NoAspectBoundException("musd_runtime_lib_MUSDMonitor", ajc$initFailureCause);
        }
        return ajc$perSingletonInstance;
    }

    public static boolean hasAspect() {
        return ajc$perSingletonInstance != null;
    }
}

