/*
 * Decompiled with CFR 0.152.
 */
package musd.compiler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import musd.compiler.MUSDInteractions2Coordinator;
import musd.compiler.interaction2aspect.MUSDInteraction2Aspect;
import musd.compiler.lib.MUSDInteraction;
import musd.compiler.lib.MUSDMessage;
import musd.compiler.stringutils.MUSDAspectStringGen;
import musd.compiler.stringutils.MethodsConstantsStringGen;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MUSDInteractionsCompiler {
    private ArrayList<MUSDInteraction> interactionList;
    private HashSet<String> pointCutCore;
    private HashSet<MUSDMessage> executableMessages;
    private ArrayList<String> aspectNames;
    private HashMap<String, String> varNamesToVarTypes;

    public MUSDInteractionsCompiler(ArrayList<MUSDInteraction> interactionList) {
        this.interactionList = interactionList;
        this.pointCutCore = new HashSet();
        this.executableMessages = new HashSet();
        this.varNamesToVarTypes = new HashMap();
        this.aspectNames = new ArrayList();
    }

    public HashMap<String, String> compileAspects(ArrayList<String> imports, String targetPackage) {
        HashMap<String, String> map = new HashMap<String, String>();
        Iterator<MUSDInteraction> it = this.interactionList.iterator();
        int range = 0;
        while (it.hasNext()) {
            MUSDInteraction inter = it.next();
            MUSDInteraction2Aspect inter2Aspect = new MUSDInteraction2Aspect(inter, range, imports, targetPackage);
            String aspectCode = inter2Aspect.getAspectCode();
            this.pointCutCore.addAll(inter2Aspect.getPointCutCores());
            this.executableMessages.addAll(inter.getExecutableMessages());
            if (!inter.isTest()) {
                this.aspectNames.add(inter2Aspect.getAspectName());
            }
            range = inter2Aspect.getFinalRange() + 1;
            this.varNamesToVarTypes.putAll(inter2Aspect.getVarNamesToVarTypes());
            map.put(inter2Aspect.getAspectName(), aspectCode);
        }
        return map;
    }

    public String compileMethodConstants(String targetPackage) {
        StringBuffer str = new StringBuffer(300);
        Iterator<MUSDInteraction> it = this.interactionList.iterator();
        str.append(MUSDAspectStringGen.generateMethodsLicenceWarnning());
        str.append(MUSDAspectStringGen.generatePackageDeclaration(targetPackage));
        str.append(MethodsConstantsStringGen.generateMUSDMethodsClass());
        HashSet<MUSDMessage> set = new HashSet<MUSDMessage>();
        while (it.hasNext()) {
            set.addAll(it.next().getMessages());
        }
        str.append(this.generateMethodsConstants(set));
        str.append("}\n");
        return str.toString();
    }

    public String compileCoordinator(String implClass, ArrayList<String> imports, String targetPack) {
        return new MUSDInteractions2Coordinator(this.aspectNames, implClass, this.pointCutCore, this.executableMessages, imports, targetPack, this.varNamesToVarTypes).getCode();
    }

    private String generateMethodsConstants(HashSet<MUSDMessage> messages) {
        StringBuffer str = new StringBuffer(100);
        HashSet<String> constants = new HashSet<String>();
        Iterator<MUSDMessage> it = messages.iterator();
        int number = 0;
        while (it.hasNext()) {
            String methodName;
            String receiverType;
            MUSDMessage mes = it.next();
            String senderType = mes.getSender().getRepresentsType();
            String constant = MethodsConstantsStringGen.generateMethodConstForMethodsClass(senderType, receiverType = mes.getReciever().getRepresentsType(), methodName = mes.getName());
            if (constants.contains(constant)) continue;
            str.append(MethodsConstantsStringGen.generateMethodForMethodsClass(constant, number++));
            constants.add(constant);
        }
        return str.toString();
    }
}

