/*
 * Decompiled with CFR 0.152.
 */
package musd.compiler.interaction2aspect;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import musd.compiler.interaction2aspect.MUSDInteractionLogic;
import musd.compiler.lib.CutState;
import musd.compiler.lib.InteractionFragmentKey;
import musd.compiler.lib.MUSDCombinedFragment;
import musd.compiler.lib.MUSDInteraction;
import musd.compiler.lib.MUSDInteractionFragment;
import musd.compiler.lib.MUSDLifeLine;
import musd.compiler.lib.MUSDMessage;
import musd.compiler.lib.StateNode;
import musd.compiler.stringutils.MUSDAspectStringGen;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MUSDConstructorBuilder {
    private HashMap<String, Integer> lineToIndexes;
    private MUSDInteractionLogic interactionLogic;
    private MUSDInteraction interaction;

    public MUSDConstructorBuilder(MUSDInteraction inter, MUSDInteractionLogic logic, HashMap<String, Integer> lineToIndexes) {
        this.interaction = inter;
        this.interactionLogic = logic;
        this.lineToIndexes = lineToIndexes;
    }

    public String getConstructor() {
        StringBuffer code = new StringBuffer(200);
        code.append(MUSDAspectStringGen.getConstructorDecleration(this.interaction.getName()));
        code.append(this.getAddMinimalEvents());
        code.append(this.getHotCutsSetters());
        code.append(this.getLastCutSetter());
        code.append(this.getLoopSettings());
        code.append(this.getNumberOfsInit());
        code.append("\t}\n\n");
        return code.toString();
    }

    private String getLastCutSetter() {
        StringBuffer code = new StringBuffer(40);
        Iterator<CutState> it = this.interactionLogic.getFinalStates().iterator();
        ArrayList<String> cut = new ArrayList<String>(this.interaction.getNumberOfLifeLines());
        int i = 0;
        while (i < this.interaction.getNumberOfLifeLines()) {
            cut.add(null);
            ++i;
        }
        while (it.hasNext()) {
            CutState cutState = it.next();
            for (String name : cutState.keySet()) {
                String loc = String.valueOf(cutState.get(name));
                int index = this.lineToIndexes.get(name);
                cut.set(index, loc);
            }
            code.append(MUSDAspectStringGen.generateLastCutSetter(cut));
        }
        return code.toString();
    }

    private String getLoopSettings() {
        StringBuffer str = new StringBuffer();
        for (MUSDCombinedFragment comb : this.interaction.getLoopFragmentsMap().keySet()) {
            if (!comb.getFirstGuard().isConstantLoopGuard()) continue;
            int limit = comb.getFirstGuard().getLoopsNumber();
            str.append(MUSDAspectStringGen.generateAddLoop(limit));
        }
        return str.toString();
    }

    private String getHotCutsSetters() {
        StringBuffer code = new StringBuffer(40);
        Iterator<CutState> it = this.interactionLogic.getHotCutStates().iterator();
        ArrayList<String> cut = new ArrayList<String>(this.interaction.getNumberOfLifeLines());
        int i = 0;
        while (i < this.interaction.getNumberOfLifeLines()) {
            cut.add(null);
            ++i;
        }
        while (it.hasNext()) {
            CutState cutState = it.next();
            for (String name : cutState.keySet()) {
                String loc = String.valueOf(cutState.get(name));
                int index = this.lineToIndexes.get(name);
                cut.set(index, loc);
            }
            code.append(MUSDAspectStringGen.generateHotCutSetter(cut));
        }
        return code.toString();
    }

    private String getNumberOfsInit() {
        StringBuffer code = new StringBuffer(40);
        Iterator<MUSDLifeLine> it = this.interaction.getCoveredLines().iterator();
        int numberOfinstances = 0;
        int numberOfLifeLines = this.interaction.getNumberOfLifeLines();
        while (it.hasNext()) {
            if (it.next().isEnv()) continue;
            ++numberOfinstances;
        }
        int varsNum = this.interaction.getPrivateVariables().size();
        code.append(MUSDAspectStringGen.generateNumbersInit(numberOfLifeLines, numberOfinstances, varsNum));
        return code.toString();
    }

    private String getAddMinimalEvents() {
        StringBuffer code = new StringBuffer(40);
        HashMap<InteractionFragmentKey, StateNode> minimalEventsMap = this.interaction.getGraph().getRoot().getChildren();
        for (InteractionFragmentKey key : minimalEventsMap.keySet()) {
            MUSDInteractionFragment musdFragment = this.getFragment(key);
            if (musdFragment.getType() != 0) {
                throw new IllegalArgumentException("Interaction: " + this.interaction.getName() + " A Constraint can not be a minimal event (yet..)");
            }
            MUSDMessage mes = (MUSDMessage)this.getFragment(key);
            code.append(MUSDAspectStringGen.addMinimalEvent(mes.getSender().getRepresentsType(), mes.getReciever().getRepresentsType(), mes.getName()));
        }
        return code.toString();
    }

    private MUSDInteractionFragment getFragment(InteractionFragmentKey key) {
        return this.interaction.getInterKeyToInterFragments().get(key);
    }
}

