/*
 * Decompiled with CFR 0.152.
 */
package musd.compiler.lib;

import org.eclipse.uml2.uml.LiteralBoolean;
import org.eclipse.uml2.uml.LiteralInteger;
import org.eclipse.uml2.uml.LiteralString;
import org.eclipse.uml2.uml.LiteralUnlimitedNatural;
import org.eclipse.uml2.uml.OpaqueExpression;
import org.eclipse.uml2.uml.ValueSpecification;

public class MUSDArgument {
    public static final String STRING = "String";
    public static final String INT = "int";
    public static final String BOOLEAN = "boolean";
    public static final String VAR = "var";
    private static String EXACT = "exact";
    private static String SYMBOLIC = "symbolic";
    private boolean isExact;
    private String type;
    String stringValue;
    private String name;
    private String originalName;
    private static int identValue;

    public MUSDArgument(ValueSpecification val) {
        this.originalName = val.getName();
        if (val instanceof LiteralString) {
            this.type = STRING;
            this.stringValue = "\"" + val.stringValue() + "\"";
            this.isExact = true;
            this.name = this.buildName(val.getName(), this.isExact);
            return;
        }
        if (val instanceof LiteralUnlimitedNatural) {
            this.type = INT;
            int temp = ((LiteralUnlimitedNatural)val).getValue();
            this.stringValue = String.valueOf(temp);
            this.isExact = true;
            this.name = this.buildName(val.getName(), this.isExact);
            return;
        }
        if (val instanceof LiteralBoolean) {
            this.type = BOOLEAN;
            boolean temp = ((LiteralBoolean)val).booleanValue();
            this.stringValue = String.valueOf(temp);
            this.isExact = true;
            this.name = this.buildName(val.getName(), this.isExact);
            return;
        }
        if (val instanceof LiteralInteger) {
            this.type = INT;
            int temp = ((LiteralInteger)val).integerValue();
            this.stringValue = String.valueOf(temp);
            this.isExact = true;
            this.name = this.buildName(val.getName(), this.isExact);
            return;
        }
        if (val instanceof OpaqueExpression) {
            this.type = VAR;
            this.stringValue = (String)((OpaqueExpression)val).getBodies().get(0);
            this.isExact = true;
            this.name = this.buildName(val.getName(), this.isExact);
            return;
        }
        this.isExact = false;
        this.name = this.buildName(val.getName(), this.isExact);
        this.type = VAR;
        this.stringValue = val.getName();
    }

    private String buildName(String name, boolean isExact) {
        String type = isExact ? EXACT : SYMBOLIC;
        String str = String.valueOf(type) + "_" + name;
        if (isExact) {
            str = String.valueOf(str) + identValue++;
        }
        return str;
    }

    public int hashCode() {
        return this.stringValue.hashCode();
    }

    public String getType() {
        return this.type;
    }

    public String getStringValue() {
        return this.stringValue;
    }

    public boolean isExact() {
        return this.isExact;
    }

    public String getOriginalName() {
        return this.originalName;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        MUSDArgument arg = (MUSDArgument)o;
        return arg.originalName.equals(this.originalName) && arg.stringValue.equals(this.stringValue) && arg.type.equals(this.type) && arg.name.equals(arg.name);
    }

    public static String getValueSpecificationType(ValueSpecification val) {
        if (val instanceof LiteralString) {
            return STRING;
        }
        if (val instanceof LiteralUnlimitedNatural) {
            return INT;
        }
        if (val instanceof LiteralBoolean) {
            return BOOLEAN;
        }
        if (val instanceof LiteralInteger) {
            return INT;
        }
        if (val instanceof OpaqueExpression) {
            return VAR;
        }
        return VAR;
    }

    public static void initIdentValue() {
        identValue = 0;
    }

    public static String parstRealName(String name) {
        return name.split("_")[1];
    }
}

