/*
 * Decompiled with CFR 0.152.
 */
package musd.compiler.lib;

import java.util.ArrayList;
import java.util.Iterator;
import musd.compiler.lib.MUSDInteractionFragment;
import musd.compiler.lib.MUSDLifeLine;
import org.eclipse.uml2.uml.CombinedFragment;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.InteractionConstraint;
import org.eclipse.uml2.uml.InteractionFragment;
import org.eclipse.uml2.uml.InteractionOperand;
import org.eclipse.uml2.uml.OpaqueExpression;
import org.eclipse.uml2.uml.StateInvariant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MUSDConstraint
extends MUSDInteractionFragment {
    private ArrayList<String> expressions;
    private boolean isHot;
    private boolean isExecute;

    public MUSDConstraint(InteractionFragment fragment, boolean isExecute, boolean isHot) {
        super(fragment);
        this.isHot = isHot;
        this.isExecute = isExecute;
        this.isImmediate = true;
        this.type = 1;
        if (fragment instanceof StateInvariant) {
            this.initStateInvariant((StateInvariant)fragment);
        } else {
            this.initAssertFragment((CombinedFragment)fragment);
        }
    }

    public void initStateInvariant(StateInvariant state) {
        Constraint con = state.getInvariant();
        this.expressions = new ArrayList();
        OpaqueExpression opaque = (OpaqueExpression)con.getSpecification();
        Iterator it1 = opaque.getBodies().iterator();
        while (it1.hasNext()) {
            this.expressions.add((String)it1.next());
        }
    }

    public void initAssertFragment(CombinedFragment fragment) {
        InteractionOperand operand = (InteractionOperand)fragment.getOperands().get(0);
        InteractionConstraint con = operand.getGuard();
        this.expressions = new ArrayList();
        OpaqueExpression opaque = (OpaqueExpression)con.getSpecification();
        Iterator it1 = opaque.getBodies().iterator();
        while (it1.hasNext()) {
            this.expressions.add((String)it1.next());
        }
    }

    private MUSDConstraint(ArrayList<MUSDLifeLine> lines) {
        this.coveredLifeLines = lines;
        this.type = 1;
        this.expressions = new ArrayList();
    }

    public ArrayList<String> getExpression() {
        return this.expressions;
    }

    public boolean isHotFalseConstraint() {
        if (!this.isHot) {
            return false;
        }
        Iterator<String> it = this.expressions.iterator();
        while (it.hasNext()) {
            if (!it.next().equalsIgnoreCase("false")) continue;
            return true;
        }
        return false;
    }

    public boolean isHot() {
        return this.isHot;
    }

    public boolean isExecute() {
        return this.isExecute;
    }

    public String toString() {
        StringBuffer str = new StringBuffer(20);
        Iterator<String> it = this.expressions.iterator();
        boolean first = true;
        while (it.hasNext()) {
            String exp = it.next();
            if (!first) {
                str.append(" && ").append(exp);
                continue;
            }
            str.append(exp);
        }
        return str.toString();
    }

    public static MUSDConstraint getSyncConstraint(ArrayList<MUSDLifeLine> lines) {
        MUSDConstraint cons = new MUSDConstraint(lines);
        cons.name = "SYNC";
        cons.expressions.add("true");
        return cons;
    }
}

