/*
 * Decompiled with CFR 0.152.
 */
package musd.compiler.lib;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Stack;
import musd.compiler.lib.InteractionFragmentKey;
import musd.compiler.lib.InteractionGraph;
import musd.compiler.lib.MUSDArgument;
import musd.compiler.lib.MUSDCombinedFragment;
import musd.compiler.lib.MUSDConstraint;
import musd.compiler.lib.MUSDInteractionFragment;
import musd.compiler.lib.MUSDInteractionOperand;
import musd.compiler.lib.MUSDLifeLine;
import musd.compiler.lib.MUSDMessage;
import musd.uml.ModalProfileUtils;
import org.eclipse.emf.common.util.EList;
import org.eclipse.uml2.uml.BehavioredClassifier;
import org.eclipse.uml2.uml.CombinedFragment;
import org.eclipse.uml2.uml.Interaction;
import org.eclipse.uml2.uml.InteractionFragment;
import org.eclipse.uml2.uml.InteractionOperand;
import org.eclipse.uml2.uml.Lifeline;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.MessageOccurrenceSpecification;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.StateInvariant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MUSDInteraction
extends MUSDInteractionFragment {
    private static final boolean SYNC = true;
    private HashSet<MessageOccurrenceSpecification> alreadyProcessed;
    private ArrayList<InteractionFragmentKey> fragmentsOrderedList;
    private HashMap<String, Integer> linesToNumbersMap;
    private HashSet<MUSDMessage> MUSDMessages;
    private HashSet<MUSDMessage> executableMessages;
    private HashSet<MUSDArgument> privateVariables;
    private HashSet<MUSDConstraint> constraints;
    private HashMap<InteractionFragmentKey, MUSDInteractionFragment> interKeyToInterFragments;
    private InteractionGraph graph;
    private Stack<MUSDCombinedFragment> workingCombFragment;
    private HashMap<MUSDCombinedFragment, Integer> loopFragmentsMap;
    private int combinedCounter = 0;
    private boolean isTest;

    public MUSDInteraction(Interaction inter) {
        super(inter.getName(), inter.getLifelines());
        this.isImmediate = true;
        this.isTest = ModalProfileUtils.isTest((BehavioredClassifier)inter.getOwner()) || ModalProfileUtils.isTest((BehavioredClassifier)inter);
        MUSDArgument.initIdentValue();
        this.MUSDMessages = new HashSet();
        this.executableMessages = new HashSet();
        this.privateVariables = new HashSet();
        this.constraints = new HashSet();
        this.alreadyProcessed = new HashSet();
        this.fragmentsOrderedList = new ArrayList();
        this.interKeyToInterFragments = new HashMap();
        this.workingCombFragment = new Stack();
        this.loopFragmentsMap = new HashMap();
        this.intializeLifeLines(inter.getLifelines());
        this.appendInteractionsToInterKeyMap(inter.getFragments());
        this.graph = new InteractionGraph(this);
    }

    private void intializeLifeLines(EList lifeLines) {
        this.linesToNumbersMap = new HashMap();
        Iterator it = lifeLines.iterator();
        int i = 0;
        while (it.hasNext()) {
            Lifeline line = (Lifeline)it.next();
            this.linesToNumbersMap.put(line.getName(), new Integer(i++));
        }
    }

    private void appendInteractionsToInterKeyMap(EList fragments) {
        for (InteractionFragment fragment : fragments) {
            boolean isExe = ModalProfileUtils.getExecutionBooleanValue((NamedElement)fragment);
            boolean isHot = ModalProfileUtils.getTemperatureBooleanValue((NamedElement)fragment);
            if (fragment instanceof StateInvariant || this.isFragmentAnAssert(fragment)) {
                this.handleStateInvariant(fragment, isHot, isExe);
                continue;
            }
            if (fragment instanceof MessageOccurrenceSpecification) {
                this.handleOccurrenceSpecification((MessageOccurrenceSpecification)fragment, isHot, isExe);
            }
            if (fragment instanceof CombinedFragment) {
                this.handleCombinedFragment((CombinedFragment)fragment, isHot, isExe);
            }
            if (!(fragment instanceof InteractionOperand)) continue;
            this.handleInteractionOperand((InteractionOperand)fragment);
        }
    }

    private boolean isFragmentAnAssert(InteractionFragment fragment) {
        return fragment instanceof CombinedFragment && ((CombinedFragment)fragment).getInteractionOperator().getValue() == 9;
    }

    private void handleOccurrenceSpecification(MessageOccurrenceSpecification mos, boolean isHot, boolean isExe) {
        Message mes = mos.getMessage();
        if (mes == null || !MUSDMessage.isRelevantMessage(mes)) {
            return;
        }
        MUSDMessage MUSDMes = new MUSDMessage(mes);
        isExe = ModalProfileUtils.getExecutionBooleanValue((NamedElement)mes);
        isHot = ModalProfileUtils.getTemperatureBooleanValue((NamedElement)mes);
        this.MUSDMessages.add(MUSDMes);
        if (isExe) {
            this.executableMessages.add(MUSDMes);
        }
        MessageOccurrenceSpecification twinOccurence = MUSDMes.getReceivePoint().equals(mos) ? MUSDMes.getSendPoint() : MUSDMes.getReceivePoint();
        if (!this.alreadyProcessed.contains(mos)) {
            InteractionFragmentKey key = new InteractionFragmentKey(isHot, isExe, MUSDMes.getCoveredLines());
            this.interKeyToInterFragments.put(key, MUSDMes);
            this.privateVariables.addAll(MUSDMes.getArguments());
            this.fragmentsOrderedList.add(key);
            this.alreadyProcessed.add(mos);
            this.alreadyProcessed.add(twinOccurence);
        }
    }

    private void handleStateInvariant(InteractionFragment fragment, boolean isHot, boolean isExe) {
        MUSDConstraint constraint = new MUSDConstraint(fragment, isExe, isHot);
        InteractionFragmentKey key = new InteractionFragmentKey(isHot, isExe, constraint.getCoveredLines());
        this.interKeyToInterFragments.put(key, constraint);
        this.constraints.add(constraint);
        this.fragmentsOrderedList.add(key);
    }

    private void handleCombinedFragment(CombinedFragment fragment, boolean isHot, boolean isExe) {
        MUSDCombinedFragment combined = new MUSDCombinedFragment(fragment, this);
        this.updateLoopMap(combined);
        this.workingCombFragment.push(combined);
        InteractionFragmentKey key = new InteractionFragmentKey(isHot, isExe, combined.getCoveredLines());
        this.interKeyToInterFragments.put(key, combined);
        this.fragmentsOrderedList.add(key);
        this.appendInteractionsToInterKeyMap(fragment.getOperands());
        this.workingCombFragment.pop();
    }

    private void handleInteractionOperand(InteractionOperand operand) {
        MUSDCombinedFragment currentComb = this.workingCombFragment.peek();
        MUSDInteractionOperand op = new MUSDInteractionOperand(operand, currentComb);
        currentComb.addOperand(op);
        this.appendInteractionsToInterKeyMap(operand.getFragments());
        this.appendSyncObject(currentComb.getCoveredLines(), op);
    }

    private void appendSyncObject(ArrayList<MUSDLifeLine> lines, MUSDInteractionOperand op) {
        MUSDConstraint syncContraint = MUSDConstraint.getSyncConstraint(lines);
        InteractionFragmentKey key = new InteractionFragmentKey(false, true, lines);
        this.interKeyToInterFragments.put(key, syncContraint);
        this.fragmentsOrderedList.add(key);
        op.setLastFragment(syncContraint);
    }

    private void updateLoopMap(MUSDCombinedFragment combined) {
        if (combined.getType() != 6) {
            return;
        }
        this.loopFragmentsMap.put(combined, this.combinedCounter++);
    }

    ArrayList<InteractionFragmentKey> getFragmentsOrderedList() {
        return this.fragmentsOrderedList;
    }

    public HashSet<MUSDMessage> getMessages() {
        return this.MUSDMessages;
    }

    public InteractionGraph getGraph() {
        return this.graph;
    }

    public HashMap<InteractionFragmentKey, MUSDInteractionFragment> getInterKeyToInterFragments() {
        return this.interKeyToInterFragments;
    }

    public HashSet<MUSDMessage> getExecutableMessages() {
        return this.executableMessages;
    }

    public HashSet<MUSDConstraint> getConstraints() {
        return this.constraints;
    }

    public HashSet<MUSDArgument> getPrivateVariables() {
        return this.privateVariables;
    }

    public int getLoopFragmentId(MUSDCombinedFragment loopFragment) {
        Integer i = this.loopFragmentsMap.get(loopFragment);
        if (i != null) {
            return i;
        }
        return -1;
    }

    public HashMap<MUSDCombinedFragment, Integer> getLoopFragmentsMap() {
        return this.loopFragmentsMap;
    }

    public boolean isTest() {
        return this.isTest;
    }
}

